/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.PluginDropHandler;
import com.intellij.ide.plugins.newui.VerticalLayout;
import com.intellij.idea.SplashManager;
import com.intellij.jdkEx.JdkEx;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.widget.IdeNotificationArea;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.JBProtocolCommand;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomFrameDialogContent;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractActionWithPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractWelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.ActionPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.TabbedWelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeBalloonLayoutImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrameUpdater;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomePopupAction;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenComponentFactory;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenFocusManager;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.Gray;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBSlidingPanel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.MathUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextAccessor;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlatWelcomeFrame
extends JFrame
implements IdeFrame,
Disposable,
AccessibleContextAccessor,
WelcomeFrameUpdater {
    public static final String BOTTOM_PANEL = "BOTTOM_PANEL";
    private static final String ACTION_GROUP_KEY = "ACTION_GROUP_KEY";
    public static final int DEFAULT_HEIGHT = Registry.is((String)"use.tabbed.welcome.screen") ? 600 : 460;
    public static final int MAX_DEFAULT_WIDTH = 800;
    private final AbstractWelcomeScreen myScreen;
    private boolean myDisposed;

    public FlatWelcomeFrame() {
        SplashManager.hideBeforeShow(this);
        JRootPane rootPane = this.getRootPane();
        boolean useTabWelcomeScreen = Registry.is((String)"use.tabbed.welcome.screen");
        this.myScreen = useTabWelcomeScreen ? new TabbedWelcomeScreen() : new FlatWelcomeScreen();
        IdeGlassPaneImpl glassPane = new IdeGlassPaneImpl(rootPane){

            @Override
            public void addNotify() {
                super.addNotify();
                ApplicationManager.getApplication().invokeLater(() -> JBProtocolCommand.handleCurrentCommand());
            }
        };
        this.setGlassPane(glassPane);
        glassPane.setVisible(false);
        int defaultHeight = DEFAULT_HEIGHT;
        if (IdeFrameDecorator.isCustomDecorationActive()) {
            JComponent holder = CustomFrameDialogContent.getCustomContentHolder(this, this.myScreen.getWelcomePanel(), UIManager.getColor("WelcomeScreen.background"));
            this.setContentPane(holder);
            if (holder instanceof CustomFrameDialogContent) {
                defaultHeight += ((CustomFrameDialogContent)holder).getHeaderHeight();
            }
        } else {
            this.setContentPane(this.myScreen.getWelcomePanel());
        }
        this.setTitle(this.getWelcomeFrameTitle());
        AppUIUtil.updateWindowIcon(this);
        if (useTabWelcomeScreen) {
            this.getRootPane().setPreferredSize((Dimension)JBUI.size((int)800, (int)defaultHeight));
        } else {
            int width = RecentProjectListActionProvider.getInstance().getActions(false).size() == 0 ? 666 : 800;
            this.getRootPane().setPreferredSize((Dimension)JBUI.size((int)width, (int)defaultHeight));
        }
        this.setResizable(useTabWelcomeScreen);
        Dimension size = this.getPreferredSize();
        Point location = WindowStateService.getInstance().getLocation("WELCOME_SCREEN");
        Rectangle screenBounds = ScreenUtil.getScreenRectangle((Point)(location != null ? location : new Point(0, 0)));
        this.setBounds(screenBounds.x + (screenBounds.width - size.width) / 2, screenBounds.y + (screenBounds.height - size.height) / 3, size.width, size.height);
        this.setAutoRequestFocus(false);
        UiNotifyConnector.doWhenFirstShown((Component)this, this::pack);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                Disposer.dispose((Disposable)FlatWelcomeFrame.this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$2", "projectOpened"));
            }
        });
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            @Override
            public void appClosing() {
                FlatWelcomeFrame.saveLocation(FlatWelcomeFrame.this.getBounds());
            }
        });
        WelcomeFrame.setupCloseAction(this);
        MnemonicHelper.init((Component)this);
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this);
        UIUtil.decorateWindowHeader((JRootPane)this.getRootPane());
        UIUtil.setCustomTitleBar((Window)this, (JRootPane)this.getRootPane(), runnable2 -> Disposer.register((Disposable)this, () -> runnable2.run()));
        if (Registry.is((String)"use.tabbed.welcome.screen")) {
            rootPane.setJMenuBar(new WelcomeFrameMenuBar());
        }
    }

    @Override
    public void addNotify() {
        if (IdeFrameDecorator.isCustomDecorationActive()) {
            JdkEx.setHasCustomDecoration(this);
        }
        super.addNotify();
    }

    @Override
    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        super.dispose();
        Disposer.dispose((Disposable)this.myScreen);
        WelcomeFrame.resetInstance();
    }

    private static void saveLocation(@NotNull Rectangle location) {
        if (location == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(0);
        }
        Point middle2 = new Point(location.x + location.width / 2, location.y + location.height / 2);
        WindowStateService.getInstance().putLocation("WELCOME_SCREEN", middle2);
    }

    @Nullable
    public StatusBar getStatusBar() {
        return null;
    }

    public AccessibleContext getCurrentAccessibleContext() {
        return this.accessibleContext;
    }

    protected String getWelcomeFrameTitle() {
        return WelcomeScreenComponentFactory.getApplicationTitle();
    }

    @NotNull
    public static JComponent getPreferredFocusedComponent(@NotNull Pair<JPanel, JBList<AnAction>> pair) {
        JBTextField textField2;
        if (pair == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(1);
        }
        if (((JBList)pair.second).getModel().getSize() == 1 && (textField2 = (JBTextField)UIUtil.uiTraverser((Component)((Component)pair.first)).filter(JBTextField.class).first()) != null) {
            JBTextField jBTextField = textField2;
            if (jBTextField == null) {
                FlatWelcomeFrame.$$$reportNull$$$0(2);
            }
            return jBTextField;
        }
        JComponent jComponent = (JComponent)pair.second;
        if (jComponent == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    protected void extendActionsGroup(JPanel panel2) {
    }

    protected void onFirstActionShown(@NotNull Component action2) {
        if (action2 == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(4);
        }
    }

    @Override
    public void showPluginUpdates(@NotNull Runnable callback2) {
        if (callback2 == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(5);
        }
        if (this.myScreen instanceof WelcomeFrameUpdater) {
            ((WelcomeFrameUpdater)((Object)this.myScreen)).showPluginUpdates(callback2);
        }
    }

    @Override
    public void hidePluginUpdates() {
        if (this.myScreen instanceof WelcomeFrameUpdater) {
            ((WelcomeFrameUpdater)((Object)this.myScreen)).hidePluginUpdates();
        }
    }

    @Nullable
    public BalloonLayout getBalloonLayout() {
        return this.myScreen.getBalloonLayout();
    }

    @NotNull
    public Rectangle suggestChildFrameBounds() {
        Rectangle rectangle = this.getBounds();
        if (rectangle == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(6);
        }
        return rectangle;
    }

    @Nullable
    public Project getProject() {
        if (ApplicationManager.getApplication().isDisposed()) {
            return null;
        }
        return ProjectManager.getInstance().getDefaultProject();
    }

    public void setFrameTitle(String title) {
        this.setTitle(title);
    }

    public JComponent getComponent() {
        return this.getRootPane();
    }

    public static Pair<JPanel, JBList<AnAction>> createActionGroupPanel(ActionGroup action2, final Runnable backAction, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(7);
        }
        JPanel actionsListPanel = new JPanel(new BorderLayout());
        actionsListPanel.setBackground(WelcomeScreenUIManager.getProjectsBackground());
        List<AnAction> groups = FlatWelcomeFrame.flattenActionGroups(action2);
        final DefaultListModel model = JBList.createDefaultListModel(groups);
        JBList list2 = new JBList((ListModel)model);
        for (AnAction group : groups) {
            if (!(group instanceof Disposable)) continue;
            Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)group));
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                model.clear();
            }
        });
        list2.setBackground(WelcomeScreenUIManager.getProjectsBackground());
        list2.setCellRenderer((ListCellRenderer)new GroupedItemsListRenderer<AnAction>((ListItemDescriptor)new ListItemDescriptorAdapter<AnAction>(){

            @Nullable
            public String getTextFor(AnAction value2) {
                return FlatWelcomeFrame.getActionText(value2);
            }

            @Nullable
            public String getCaptionAboveOf(AnAction value2) {
                return FlatWelcomeFrame.getParentGroupName(value2);
            }

            public boolean hasSeparatorAboveOf(AnAction value2) {
                int index = model.indexOf(value2);
                String parentGroupName = FlatWelcomeFrame.getParentGroupName(value2);
                if (index < 1) {
                    return parentGroupName != null;
                }
                AnAction upper = (AnAction)model.get(index - 1);
                if (FlatWelcomeFrame.getParentGroupName(upper) == null && parentGroupName != null) {
                    return true;
                }
                return !Objects.equals(FlatWelcomeFrame.getParentGroupName(upper), parentGroupName);
            }
        }){

            @Override
            protected JComponent createItemComponent() {
                this.myTextLabel = new ErrorLabel();
                this.myTextLabel.setOpaque(true);
                this.myTextLabel.setBorder((Border)JBUI.Borders.empty((int)3, (int)7));
                return this.myTextLabel;
            }

            protected Color getBackground() {
                return WelcomeScreenUIManager.getProjectsBackground();
            }

            @Override
            protected void customizeComponent(JList<? extends AnAction> list2, AnAction value2, boolean isSelected) {
                if (this.myTextLabel != null) {
                    this.myTextLabel.setText(FlatWelcomeFrame.getActionText(value2));
                    this.myTextLabel.setIcon(value2.getTemplatePresentation().getIcon());
                }
            }
        });
        JScrollPane pane2 = ScrollPaneFactory.createScrollPane((Component)list2, (boolean)true);
        pane2.setBackground(WelcomeScreenUIManager.getProjectsBackground());
        actionsListPanel.add((Component)pane2, "Center");
        int width = (int)MathUtil.clamp((long)Math.round(list2.getPreferredSize().getWidth()), (long)JBUIScale.scale((int)100), (long)JBUIScale.scale((int)200));
        pane2.setPreferredSize((Dimension)JBUI.size((int)(width + 14), (int)-1));
        boolean singleProjectGenerator = list2.getModel().getSize() == 1;
        Ref selected2 = Ref.create();
        JPanel main2 = new JPanel(new BorderLayout());
        main2.add((Component)actionsListPanel, "West");
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        bottomPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, (Color)new JBColor((Color)Gray._217, (Color)Gray._81)));
        main2.add((Component)bottomPanel, "South");
        HashMap panelsMap = new HashMap();
        ListSelectionListener selectionListener = e -> {
            Object value2;
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (!selected2.isNull()) {
                main2.remove((Component)selected2.get());
            }
            if ((value2 = list2.getSelectedValue()) instanceof AbstractActionWithPanel) {
                JPanel panel2 = panelsMap.computeIfAbsent(value2, o -> ((AbstractActionWithPanel)((Object)((Object)((Object)value2)))).createPanel());
                ((AbstractActionWithPanel)((Object)((Object)value2))).onPanelSelected();
                panel2.setBorder((Border)JBUI.Borders.empty((int)7, (int)10));
                selected2.set((Object)panel2);
                main2.add((Component)selected2.get());
                FlatWelcomeFrame.updateBottomPanel(panel2, (AbstractActionWithPanel)((Object)((Object)value2)), bottomPanel, backAction);
                main2.revalidate();
                main2.repaint();
            }
        };
        list2.addListSelectionListener(selectionListener);
        if (backAction != null) {
            new DumbAwareAction(){

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    e.getPresentation().setEnabled(!StackingPopupDispatcher.getInstance().isPopupFocused());
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        7.$$$reportNull$$$0(1);
                    }
                    backAction.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$7";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "update";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.registerCustomShortcutSet(CommonShortcuts.ESCAPE, (JComponent)main2, parentDisposable);
        }
        FlatWelcomeFrame.installQuickSearch((JBList<? extends AnAction>)list2);
        if (singleProjectGenerator) {
            actionsListPanel.setPreferredSize(new Dimension(0, 0));
        }
        return Pair.create((Object)main2, (Object)list2);
    }

    private static void updateBottomPanel(@NotNull JPanel currentPanel, @NotNull AbstractActionWithPanel actionWithPanel, @NotNull JPanel bottomPanel, @Nullable Runnable backAction) {
        if (currentPanel == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(8);
        }
        if (actionWithPanel == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(9);
        }
        if (bottomPanel == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(10);
        }
        bottomPanel.removeAll();
        if (SystemInfo.isMac) {
            FlatWelcomeFrame.addCancelButton(bottomPanel, backAction);
            FlatWelcomeFrame.addActionButton(bottomPanel, actionWithPanel, currentPanel);
        } else {
            FlatWelcomeFrame.addActionButton(bottomPanel, actionWithPanel, currentPanel);
            FlatWelcomeFrame.addCancelButton(bottomPanel, backAction);
        }
    }

    private static void addCancelButton(@NotNull JPanel bottomPanel, @Nullable Runnable backAction) {
        JComponent cancelButton;
        if (bottomPanel == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(11);
        }
        if ((cancelButton = FlatWelcomeFrame.createCancelButton(backAction)) != null) {
            bottomPanel.add(cancelButton);
        }
    }

    private static void addActionButton(@NotNull JPanel bottomPanel, @NotNull AbstractActionWithPanel actionWithPanel, @NotNull JPanel currentPanel) {
        if (bottomPanel == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(12);
        }
        if (actionWithPanel == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(13);
        }
        if (currentPanel == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(14);
        }
        JButton actionButton = actionWithPanel.getActionButton();
        bottomPanel.add(actionButton);
        currentPanel.getRootPane().setDefaultButton(actionButton);
    }

    @Nullable
    private static JComponent createCancelButton(@Nullable Runnable cancelAction) {
        if (cancelAction == null) {
            return null;
        }
        JButton cancelButton = new JButton(CommonBundle.getCancelButtonText());
        cancelButton.addActionListener(e -> cancelAction.run());
        return cancelButton;
    }

    public static void installQuickSearch(JBList<? extends AnAction> list2) {
        new ListSpeedSearch<AnAction>((JList<? extends AnAction>)list2, (Function<? extends AnAction, String>)((Function)o -> {
            if (o instanceof AbstractActionWithPanel) {
                return o.getTemplatePresentation().getText();
            }
            return null;
        }));
    }

    private static List<AnAction> flattenActionGroups(@NotNull ActionGroup action2) {
        if (action2 == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(15);
        }
        ArrayList<AnAction> groups = new ArrayList<AnAction>();
        for (AnAction anAction : action2.getChildren(null)) {
            if (anAction instanceof ActionGroup) {
                String groupName = FlatWelcomeFrame.getActionText(anAction);
                for (AnAction childAction : ((ActionGroup)anAction).getChildren(null)) {
                    if (groupName != null) {
                        FlatWelcomeFrame.setParentGroupName(groupName, childAction);
                    }
                    groups.add(childAction);
                }
                continue;
            }
            groups.add(anAction);
        }
        return groups;
    }

    private static String getActionText(@NotNull AnAction value2) {
        if (value2 == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(16);
        }
        return value2.getTemplatePresentation().getText();
    }

    private static String getParentGroupName(@NotNull AnAction value2) {
        if (value2 == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(17);
        }
        return (String)value2.getTemplatePresentation().getClientProperty(ACTION_GROUP_KEY);
    }

    private static void setParentGroupName(@NotNull String groupName, @NotNull AnAction childAction) {
        if (groupName == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(18);
        }
        if (childAction == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(19);
        }
        childAction.getTemplatePresentation().putClientProperty(ACTION_GROUP_KEY, (Object)groupName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentPanel";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionWithPanel";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bottomPanel";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestChildFrameBounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "saveLocation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredFocusedComponent";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onFirstActionShown";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showPluginUpdates";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createActionGroupPanel";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateBottomPanel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addCancelButton";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addActionButton";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "flattenActionGroups";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getActionText";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getParentGroupName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setParentGroupName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class WelcomeFrameMenuBar
    extends IdeMenuBar {
        private WelcomeFrameMenuBar() {
        }

        @Override
        @NotNull
        public ActionGroup getMainMenuActionGroup() {
            return new DefaultActionGroup(new AnAction[]{ActionManager.getInstance().getAction("FileMenu"), ActionManager.getInstance().getAction("HelpMenu")});
        }
    }

    private final class FlatWelcomeScreen
    extends AbstractWelcomeScreen
    implements WelcomeFrameUpdater {
        private final JBSlidingPanel mySlidingPanel = new JBSlidingPanel();
        private final DefaultActionGroup myTouchbarActions = new DefaultActionGroup();
        public Consumer<List<NotificationType>> myEventListener;
        public Computable<Point> myEventLocation;
        private LinkLabel<Object> myUpdatePluginsLink;
        private boolean inDnd;
        private BalloonLayoutImpl myBalloonLayout;

        FlatWelcomeScreen() {
            this.mySlidingPanel.add("root", (Component)this);
            this.setBackground(WelcomeScreenUIManager.getMainBackground());
            if (RecentProjectListActionProvider.getInstance().getActions(false, true).size() > 0) {
                final JComponent recentProjects = WelcomeScreenComponentFactory.createRecentProjects((Disposable)this);
                this.add((Component)recentProjects, "West");
                final JList projectsList = (JList)UIUtil.findComponentOfType((JComponent)recentProjects, JList.class);
                if (projectsList != null) {
                    projectsList.getModel().addListDataListener(new ListDataListener(){

                        @Override
                        public void intervalAdded(ListDataEvent e) {
                        }

                        @Override
                        public void intervalRemoved(ListDataEvent e) {
                            this.removeIfNeeded();
                        }

                        private void removeIfNeeded() {
                            if (RecentProjectListActionProvider.getInstance().getActions(false, true).size() == 0) {
                                FlatWelcomeScreen.this.remove(recentProjects);
                                FlatWelcomeScreen.this.revalidate();
                                FlatWelcomeScreen.this.repaint();
                            }
                        }

                        @Override
                        public void contentsChanged(ListDataEvent e) {
                            this.removeIfNeeded();
                        }
                    });
                    projectsList.addFocusListener(new FocusListener(){

                        @Override
                        public void focusGained(FocusEvent e) {
                            projectsList.repaint();
                        }

                        @Override
                        public void focusLost(FocusEvent e) {
                            projectsList.repaint();
                        }
                    });
                }
            }
            this.add((Component)this.createBody(), "Center");
            this.setDropTarget(new DropTarget(this, new DropTargetAdapter(){

                @Override
                public void dragEnter(DropTargetDragEvent e) {
                    this.setDnd(true);
                }

                @Override
                public void dragExit(DropTargetEvent e) {
                    this.setDnd(false);
                }

                @Override
                public void drop(DropTargetDropEvent e) {
                    this.setDnd(false);
                    e.acceptDrop(3);
                    Transferable transferable = e.getTransferable();
                    List<File> list2 = FileCopyPasteUtil.getFileList(transferable);
                    if (list2 != null && list2.size() > 0) {
                        PluginDropHandler pluginHandler = new PluginDropHandler();
                        if (!pluginHandler.canHandle(transferable, null) || !pluginHandler.handleDrop(transferable, null, null)) {
                            ProjectUtil.tryOpenFileList(null, list2, "WelcomeFrame");
                        }
                        e.dropComplete(true);
                        return;
                    }
                    e.dropComplete(false);
                }

                private void setDnd(boolean dnd) {
                    FlatWelcomeScreen.this.inDnd = dnd;
                    FlatWelcomeScreen.this.repaint();
                }
            }));
            TouchbarDataKeys.putActionDescriptor((AnAction)this.myTouchbarActions).setShowText(true);
        }

        public JComponent getWelcomePanel() {
            return this.mySlidingPanel;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.inDnd) {
                Rectangle bounds2 = this.getBounds();
                JBColor background = JBColor.namedColor((String)"DragAndDrop.areaBackground", (Color)new Color(225, 235, 245));
                g.setColor(new Color(background.getRed(), background.getGreen(), background.getBlue(), 206));
                g.fillRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
                JBColor backgroundBorder = JBColor.namedColor((String)"DragAndDrop.areaBorderColor", (Color)new Color(137, 178, 222));
                g.setColor((Color)backgroundBorder);
                g.drawRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
                g.drawRect(bounds2.x + 1, bounds2.y + 1, bounds2.width - 2, bounds2.height - 2);
                JBColor foreground = JBColor.namedColor((String)"DragAndDrop.areaForeground", (Color)Gray._120);
                g.setColor((Color)foreground);
                Font labelFont = StartupUiUtil.getLabelFont();
                Font font = labelFont.deriveFont((float)labelFont.getSize() + 5.0f);
                String drop = "Drop files here to open";
                g.setFont(font);
                int dropWidth = g.getFontMetrics().stringWidth(drop);
                int dropHeight = g.getFontMetrics().getHeight();
                g.drawString(drop, bounds2.x + (bounds2.width - dropWidth) / 2, (int)((double)bounds2.y + (double)(bounds2.height - dropHeight) * 0.45));
            }
        }

        @NotNull
        private JComponent createBody() {
            NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
            panel2.add((Component)WelcomeScreenComponentFactory.createLogo(), (Object)"North");
            this.myTouchbarActions.removeAll();
            ActionPanel actionPanel = this.createQuickStartActionPanel();
            panel2.add((Component)actionPanel, (Object)"Center");
            this.myTouchbarActions.addAll(actionPanel.getActions());
            panel2.add((Component)this.createUpdatesSettingsAndDocs(), (Object)"South");
            NonOpaquePanel nonOpaquePanel = panel2;
            if (nonOpaquePanel == null) {
                FlatWelcomeScreen.$$$reportNull$$$0(0);
            }
            return nonOpaquePanel;
        }

        private JComponent createUpdatesSettingsAndDocs() {
            NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
            panel2.add((Component)this.createUpdatePluginsLink(), "West");
            panel2.add((Component)this.createSettingsAndDocsPanel(FlatWelcomeFrame.this), "East");
            return panel2;
        }

        private JComponent createSettingsAndDocsPanel(JFrame frame) {
            NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
            NonOpaquePanel toolbar = new NonOpaquePanel();
            toolbar.setLayout((LayoutManager)new BoxLayout((Container)toolbar, 0));
            toolbar.add((Component)WelcomeScreenComponentFactory.createErrorsLink((Disposable)this));
            toolbar.add((Component)this.createEventsLink());
            toolbar.add((Component)WelcomeScreenComponentFactory.createActionLink(FlatWelcomeFrame.this, IdeBundle.message((String)"action.Anonymous.text.configure", (Object[])new Object[0]), "WelcomeScreen.Configure", AllIcons.General.GearPlain, UIUtil.findComponentOfType((JComponent)frame.getRootPane(), JList.class)));
            toolbar.add((Component)WelcomeScreenComponentFactory.createActionLink(FlatWelcomeFrame.this, IdeBundle.message((String)"action.GetHelp", (Object[])new Object[0]), "WelcomeScreen.Documentation", null, null));
            panel2.add((Component)toolbar, "East");
            panel2.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)8, (int)11));
            return panel2;
        }

        private JComponent createEventsLink() {
            Ref actionLinkRef = new Ref();
            JComponent panel2 = WelcomeScreenComponentFactory.createActionLink(IdeBundle.message((String)"action.Events", (Object[])new Object[0]), AllIcons.Ide.Notification.NoEvents, (Ref<? super ActionLink>)actionLinkRef, new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    ((WelcomeBalloonLayoutImpl)FlatWelcomeScreen.this.myBalloonLayout).showPopup();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen$4", "actionPerformed"));
                }
            });
            panel2.setVisible(false);
            this.myEventListener = types -> {
                NotificationType type = null;
                for (NotificationType t : types) {
                    if (NotificationType.ERROR == t) {
                        type = NotificationType.ERROR;
                        break;
                    }
                    if (NotificationType.WARNING == t) {
                        type = NotificationType.WARNING;
                        continue;
                    }
                    if (type != null || NotificationType.INFORMATION != t) continue;
                    type = NotificationType.INFORMATION;
                }
                if (types.isEmpty()) {
                    panel2.setVisible(false);
                } else {
                    ((ActionLink)actionLinkRef.get()).setIcon((Icon)IdeNotificationArea.createIconWithNotificationCount((JComponent)actionLinkRef.get(), type, types.size(), false));
                    panel2.setVisible(true);
                }
            };
            this.myEventLocation = () -> {
                Point location = SwingUtilities.convertPoint(panel2, 0, 0, this.getRootPane().getLayeredPane());
                return new Point(location.x, location.y + 5);
            };
            this.myBalloonLayout = new WelcomeBalloonLayoutImpl(FlatWelcomeFrame.this.rootPane, (Insets)JBUI.insets((int)8), this.myEventListener, this.myEventLocation);
            return panel2;
        }

        @Override
        @Nullable
        public BalloonLayout getBalloonLayout() {
            return this.myBalloonLayout;
        }

        @NotNull
        private ActionPanel createQuickStartActionPanel() {
            DefaultActionGroup group = new DefaultActionGroup();
            ActionGroup quickStart = (ActionGroup)ActionManager.getInstance().getAction("WelcomeScreen.QuickStart");
            WelcomeScreenComponentFactory.collectAllActions(group, quickStart);
            ActionPanel mainPanel = new ActionPanel((LayoutManager)new MigLayout("ins 0, novisualpadding, gap " + JBUI.scale((int)5) + ", flowy", "push[pref!, center]push"));
            mainPanel.setOpaque(false);
            JPanel panel2 = new JPanel((LayoutManager)((Object)new VerticalLayout(JBUI.scale((int)5)))){
                Component firstAction;
                {
                    this.firstAction = null;
                }

                @Override
                public Component add(Component comp) {
                    Component cmp = super.add(comp);
                    if (this.firstAction == null) {
                        this.firstAction = cmp;
                    }
                    return cmp;
                }

                @Override
                public void addNotify() {
                    super.addNotify();
                    if (this.firstAction != null) {
                        FlatWelcomeFrame.this.onFirstActionShown(this.firstAction);
                    }
                }
            };
            panel2.setOpaque(false);
            FlatWelcomeFrame.this.extendActionsGroup(mainPanel);
            mainPanel.add(panel2);
            for (AnAction action2 : group.getChildren(null)) {
                Icon icon2;
                AnActionEvent e = AnActionEvent.createFromAnAction((AnAction)action2, null, (String)"WelcomeScreen", (DataContext)DataManager.getInstance().getDataContext((Component)this));
                action2.update(e);
                Presentation presentation2 = e.getPresentation();
                if (!presentation2.isVisible()) continue;
                String text = presentation2.getText();
                if (text != null && text.endsWith("...")) {
                    text = text.substring(0, text.length() - 3);
                }
                if ((icon2 = presentation2.getIcon()) == null || icon2.getIconHeight() != JBUIScale.scale((int)16) || icon2.getIconWidth() != JBUIScale.scale((int)16)) {
                    icon2 = icon2 != null ? IconUtil.scale((Icon)icon2, null, (float)(16.0f / (float)icon2.getIconWidth())) : JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)16));
                    icon2 = IconUtil.colorize((Icon)icon2, (Color)new JBColor(0x6E6E6E, 11514291));
                }
                action2 = this.wrapGroups(action2);
                ActionLink link = new ActionLink(text, icon2, action2, null, "WelcomeScreen");
                link.setFocusable(false);
                link.setPaintUnderline(false);
                link.setNormalColor(WelcomeScreenUIManager.getLinkNormalColor());
                WelcomeScreenComponentFactory.JActionLinkPanel button2 = new WelcomeScreenComponentFactory.JActionLinkPanel(link);
                button2.setBorder((Border)JBUI.Borders.empty((int)8, (int)20));
                if (action2 instanceof WelcomePopupAction) {
                    button2.add((Component)WelcomeScreenComponentFactory.createArrow(link), "East");
                    TouchbarDataKeys.putActionDescriptor((AnAction)action2).setContextComponent((JComponent)link);
                }
                WelcomeScreenFocusManager.installFocusable(FlatWelcomeFrame.this, button2, action2, 40, 38, UIUtil.findComponentOfType((JComponent)FlatWelcomeFrame.this.getComponent(), JList.class));
                panel2.add(button2);
                mainPanel.addAction(action2);
            }
            ActionPanel actionPanel = mainPanel;
            if (actionPanel == null) {
                FlatWelcomeScreen.$$$reportNull$$$0(1);
            }
            return actionPanel;
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                FlatWelcomeScreen.$$$reportNull$$$0(2);
            }
            if (TouchbarDataKeys.ACTIONS_KEY.is(dataId)) {
                return this.myTouchbarActions;
            }
            return null;
        }

        private AnAction wrapGroups(AnAction action2) {
            if (action2 instanceof ActionGroup && ((ActionGroup)action2).isPopup()) {
                Pair<JPanel, JBList<AnAction>> panel2 = FlatWelcomeFrame.createActionGroupPanel((ActionGroup)action2, () -> this.goBack(), (Disposable)this);
                final Runnable onDone = () -> {
                    ListSelectionListener[] listeners;
                    FlatWelcomeFrame.this.setTitle(ProjectBundle.message((String)"dialog.title.new.project", (Object[])new Object[0]));
                    JBList list2 = (JBList)panel2.second;
                    ScrollingUtil.ensureSelectionExists((JList)list2);
                    for (ListSelectionListener listener2 : listeners = (ListSelectionListener[])((DefaultListSelectionModel)list2.getSelectionModel()).getListeners(ListSelectionListener.class)) {
                        listener2.valueChanged(new ListSelectionEvent(list2, list2.getSelectedIndex(), list2.getSelectedIndex(), false));
                    }
                    JComponent toFocus = FlatWelcomeFrame.getPreferredFocusedComponent(panel2);
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)toFocus, true));
                };
                final String name = action2.getClass().getName();
                this.mySlidingPanel.add(name, (Component)panel2.first);
                Presentation p = action2.getTemplatePresentation();
                return new DumbAwareAction(p.getText(), p.getDescription(), p.getIcon()){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        FlatWelcomeScreen.this.mySlidingPanel.getLayout().swipe((Container)FlatWelcomeScreen.this.mySlidingPanel, name, JBCardLayout.SwipeDirection.FORWARD, onDone);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen$6", "actionPerformed"));
                    }
                };
            }
            return action2;
        }

        private void goBack() {
            this.mySlidingPanel.swipe("root", JBCardLayout.SwipeDirection.BACKWARD).doWhenDone(() -> {
                this.mySlidingPanel.getRootPane().setDefaultButton(null);
                FlatWelcomeFrame.this.setTitle(FlatWelcomeFrame.this.getWelcomeFrameTitle());
            });
        }

        public void setupFrame(JFrame frame) {
        }

        public void dispose() {
            if (this.myBalloonLayout != null) {
                this.myBalloonLayout.dispose();
                this.myBalloonLayout = null;
            }
        }

        private JComponent createUpdatePluginsLink() {
            this.myUpdatePluginsLink = new LinkLabel(IdeBundle.message((String)"updates.plugins.welcome.screen.link.message", (Object[])new Object[0]), null);
            this.myUpdatePluginsLink.setVisible(false);
            NonOpaquePanel wrap = new NonOpaquePanel(this.myUpdatePluginsLink);
            wrap.setBorder((Border)JBUI.Borders.empty((int)0, (int)10, (int)8, (int)11));
            return wrap;
        }

        @Override
        public void showPluginUpdates(@NotNull Runnable callback2) {
            if (callback2 == null) {
                FlatWelcomeScreen.$$$reportNull$$$0(3);
            }
            this.myUpdatePluginsLink.setListener((__, ___) -> callback2.run(), null);
            this.myUpdatePluginsLink.setVisible(true);
        }

        @Override
        public void hidePluginUpdates() {
            this.myUpdatePluginsLink.setListener(null, null);
            this.myUpdatePluginsLink.setVisible(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createBody";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createQuickStartActionPanel";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "showPluginUpdates";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

