/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.search.BulkOccurrenceProcessor;
import com.intellij.psi.impl.search.HelperKt;
import com.intellij.psi.impl.search.InjectionAwareOccurrenceProcessor;
import com.intellij.psi.impl.search.LeafOccurrence;
import com.intellij.psi.impl.search.LowLevelSearchUtilKt;
import com.intellij.psi.impl.search.RequestProcessors;
import com.intellij.util.text.StringSearcher;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/psi/impl/search/MyBulkOccurrenceProcessor;", "Lcom/intellij/psi/impl/search/BulkOccurrenceProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "processors", "Lcom/intellij/psi/impl/search/RequestProcessors;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/impl/search/RequestProcessors;)V", "execute", "", "scope", "Lcom/intellij/psi/PsiElement;", "offsetsInScope", "", "searcher", "Lcom/intellij/util/text/StringSearcher;", "executeInner", "Companion", "intellij.platform.indexing.impl"})
public final class MyBulkOccurrenceProcessor
implements BulkOccurrenceProcessor {
    private final Project project;
    private final RequestProcessors processors;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    public boolean execute(@NotNull PsiElement scope, @NotNull int[] offsetsInScope, @NotNull StringSearcher searcher) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)offsetsInScope, (String)"offsetsInScope");
        Intrinsics.checkParameterIsNotNull((Object)searcher, (String)"searcher");
        int[] nArray = offsetsInScope;
        boolean bl = false;
        if (nArray.length == 0) {
            return true;
        }
        try {
            return this.executeInner(scope, offsetsInScope, searcher);
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return true;
        }
        catch (Error e) {
            LOG.error((Throwable)e);
            return true;
        }
    }

    private final boolean executeInner(PsiElement scope, int[] offsetsInScope, StringSearcher searcher) {
        InjectedLanguageManager manager;
        ProgressIndicator progress2 = HelperKt.getIndicatorOrEmpty();
        InjectedLanguageManager injectedLanguageManager = manager = InjectedLanguageManager.getInstance((Project)this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)injectedLanguageManager, (String)"manager");
        InjectionAwareOccurrenceProcessor topOccurrenceProcessor = new InjectionAwareOccurrenceProcessor(progress2, this.processors, injectedLanguageManager, searcher);
        return LowLevelSearchUtilKt.processOffsets(scope, offsetsInScope, searcher.getPatternLength(), progress2, (Function1<? super LeafOccurrence, Boolean>)((Function1)topOccurrenceProcessor));
    }

    public MyBulkOccurrenceProcessor(@NotNull Project project, @NotNull RequestProcessors processors) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)processors, (String)"processors");
        this.project = project;
        this.processors = processors;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(MyBulkOccurrenceProcessor.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(MyBul\u2026nceProcessor::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/psi/impl/search/MyBulkOccurrenceProcessor$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.indexing.impl"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

