/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.ide.TitledHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenameHandler;
import com.intellij.refactoring.util.RadioUpDownListener;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameHandlerRegistry {
    public static final Key<Boolean> SELECT_ALL = Key.create((String)"rename.selectAll");
    private final PsiElementRenameHandler myDefaultElementRenameHandler;
    private Function<? super Collection<RenameHandler>, ? extends RenameHandler> myRenameHandlerSelectorInTests = ContainerUtil::getFirstItem;

    public static RenameHandlerRegistry getInstance() {
        return (RenameHandlerRegistry)ServiceManager.getService(RenameHandlerRegistry.class);
    }

    protected RenameHandlerRegistry() {
        this.myDefaultElementRenameHandler = new PsiElementRenameHandler();
    }

    public boolean hasAvailableHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            RenameHandlerRegistry.$$$reportNull$$$0(0);
        }
        for (RenameHandler renameHandler : RenameHandler.EP_NAME.getExtensionList()) {
            if (!renameHandler.isAvailableOnDataContext(dataContext)) continue;
            return true;
        }
        return this.myDefaultElementRenameHandler.isAvailableOnDataContext(dataContext);
    }

    @Nullable
    public RenameHandler getRenameHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            RenameHandlerRegistry.$$$reportNull$$$0(1);
        }
        TreeMap<String, RenameHandler> availableHandlers = new TreeMap<String, RenameHandler>();
        for (RenameHandler renameHandler : RenameHandler.EP_NAME.getExtensionList()) {
            RenameHandlerRegistry.checkHandler(renameHandler, dataContext, availableHandlers);
        }
        if (availableHandlers.size() == 1) {
            return (RenameHandler)availableHandlers.values().iterator().next();
        }
        Iterator iterator2 = availableHandlers.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            if (!(entry.getValue() instanceof MemberInplaceRenameHandler)) continue;
            iterator2.remove();
            break;
        }
        if (availableHandlers.size() == 1) {
            return (RenameHandler)availableHandlers.values().iterator().next();
        }
        if (availableHandlers.size() > 1) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return this.myRenameHandlerSelectorInTests.apply(availableHandlers.values());
            }
            String[] strings = ArrayUtilRt.toStringArray(availableHandlers.keySet());
            HandlersChooser chooser = new HandlersChooser((Project)CommonDataKeys.PROJECT.getData(dataContext), strings);
            if (chooser.showAndGet()) {
                return (RenameHandler)availableHandlers.get(chooser.getSelection());
            }
            throw new ProcessCanceledException();
        }
        return this.myDefaultElementRenameHandler.isRenaming(dataContext) ? this.myDefaultElementRenameHandler : null;
    }

    private static void checkHandler(RenameHandler renameHandler, DataContext dataContext, Map<String, RenameHandler> availableHandlers) {
        if (renameHandler.isRenaming(dataContext)) {
            availableHandlers.put(RenameHandlerRegistry.getHandlerTitle(renameHandler), renameHandler);
        }
    }

    public void setRenameHandlerSelectorInTests(Function<? super Collection<RenameHandler>, ? extends RenameHandler> selector, Disposable parentDisposable) {
        this.myRenameHandlerSelectorInTests = selector;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                RenameHandlerRegistry.this.myRenameHandlerSelectorInTests = ContainerUtil::getFirstItem;
            }
        });
    }

    private static String getHandlerTitle(RenameHandler renameHandler) {
        return renameHandler instanceof TitledHandler ? StringUtil.capitalize((String)StringUtil.toLowerCase((String)((TitledHandler)renameHandler).getActionTitle())) : renameHandler.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "dataContext";
        objectArray2[1] = "com/intellij/refactoring/rename/RenameHandlerRegistry";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasAvailableHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getRenameHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class HandlersChooser
    extends DialogWrapper {
        private final String[] myRenamers;
        private String mySelection;
        private final JRadioButton[] myRButtons;

        protected HandlersChooser(Project project, String[] renamers) {
            super(project);
            this.myRenamers = renamers;
            this.myRButtons = new JRadioButton[this.myRenamers.length];
            this.mySelection = renamers[0];
            this.setTitle(RefactoringBundle.message((String)"select.refactoring.title"));
            this.init();
        }

        protected JComponent createNorthPanel() {
            JPanel radioPanel = new JPanel();
            radioPanel.setLayout(new BoxLayout(radioPanel, 1));
            JLabel descriptionLabel = new JLabel(RefactoringBundle.message((String)"what.would.you.like.to.do"));
            descriptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            radioPanel.add(descriptionLabel);
            ButtonGroup bg = new ButtonGroup();
            boolean selected2 = true;
            int rIdx = 0;
            for (final String renamer : this.myRenamers) {
                final JRadioButton rb = new JRadioButton(renamer, selected2);
                this.myRButtons[rIdx++] = rb;
                ItemListener listener2 = new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (rb.isSelected()) {
                            mySelection = renamer;
                        }
                    }
                };
                rb.addItemListener(listener2);
                selected2 = false;
                bg.add(rb);
                radioPanel.add(rb);
            }
            new RadioUpDownListener(this.myRButtons);
            return radioPanel;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myRButtons[0];
        }

        public String getSelection() {
            return this.mySelection;
        }

        protected JComponent createCenterPanel() {
            return null;
        }
    }
}

