/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class PresentableId
implements Cloneable {
    @Nullable
    private final String myId;
    @Nullable
    private final String myName;

    @Contract(value="null, null -> fail")
    private PresentableId(@Nullable String id2, @Nullable String name) {
        if (name == null && id2 == null) {
            throw new IllegalStateException("Either id or name should be provided");
        }
        this.myId = id2;
        this.myName = name;
    }

    @Nullable
    public String getId() {
        return this.myId;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public boolean hasId() {
        return this.myId != null;
    }

    public boolean hasName() {
        return this.myName != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PresentableId id2 = (PresentableId)o;
        return Objects.equals(this.myId, id2.myId) && Objects.equals(this.myName, id2.myName);
    }

    public int hashCode() {
        return Objects.hash(this.myId, this.myName);
    }

    public PresentableId clone() {
        try {
            return (PresentableId)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "PresentableId{myId='" + this.myId + '\'' + ", myName='" + this.myName + '\'' + '}';
    }

    @Contract(value="_, !null->!null")
    @Nullable
    public static PresentableId createId(@Nullable String id2, @Nullable String name) {
        id2 = StringUtil.nullize((String)id2);
        name = StringUtil.nullize((String)name);
        if (id2 == null && name == null) {
            return null;
        }
        return new PresentableId(id2, name);
    }

    @Nullable
    public static PresentableId createMergedName(@Nullable PresentableId id2, @Nullable String name) {
        return PresentableId.createId(id2 == null ? null : id2.getId(), name);
    }

    @Nullable
    public static PresentableId createMergedId(@Nullable PresentableId presentableId, @Nullable String id2) {
        return PresentableId.createId(id2, presentableId == null ? null : presentableId.getName());
    }
}

