/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote.ui;

import com.intellij.DynamicBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.CredentialsEditor;
import com.intellij.remote.ext.CredentialsLanguageContribution;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.remote.ext.FormWithAlignableLabelsColumn;
import com.intellij.remote.ext.PathsBrowserDialogProvider;
import com.intellij.remote.ui.ApplicationOnlySdkScopeController;
import com.intellij.remote.ui.BundleAccessor;
import com.intellij.remote.ui.CredentialsEditorProvider;
import com.intellij.remote.ui.RemoteSdkEditorContainer;
import com.intellij.remote.ui.RemoteSdkEditorForm;
import com.intellij.remote.ui.SdkScopeController;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.StatusPanel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateRemoteSdkForm<T extends RemoteSdkAdditionalData>
extends JPanel
implements RemoteSdkEditorForm,
Disposable {
    private JPanel myMainPanel;
    private JBLabel myInterpreterPathLabel;
    protected TextFieldWithBrowseButton myInterpreterPathField;
    protected TextFieldWithBrowseButton myHelpersPathField;
    private JTextField myNameField;
    private JBLabel myNameLabel;
    private JBLabel myHelpersPathLabel;
    private JPanel myStatusPanelHolder;
    private final StatusPanel myStatusPanel;
    private JPanel myRadioPanel;
    private JPanel myTypesPanel;
    private JPanel myRunAsRootViaSudoPanel;
    private JBCheckBox myRunAsRootViaSudoJBCheckBox;
    private JPanel myRunAsRootViaSudoHelpPanel;
    private ButtonGroup myTypeButtonGroup;
    private boolean myNameVisible;
    private final Project myProject;
    @NotNull
    private final RemoteSdkEditorContainer myParentContainer;
    private final Runnable myValidator;
    @NotNull
    private final BundleAccessor myBundleAccessor;
    private boolean myTempFilesPathVisible;
    private CredentialsType myConnectionType;
    private final Map<CredentialsType, TypeHandler> myCredentialsType2Handler;
    private final Set<CredentialsType> myUnsupportedConnectionTypes;
    @NotNull
    private final SdkScopeController mySdkScopeController;
    @NotNull
    private final CredentialsEditorLabelsColumnTracker myLabelsColumnTracker;

    public CreateRemoteSdkForm(@Nullable Project project, @NotNull RemoteSdkEditorContainer parentContainer, @Nullable Runnable validator, @NotNull BundleAccessor bundleAccessor) {
        if (parentContainer == null) {
            CreateRemoteSdkForm.$$$reportNull$$$0(0);
        }
        if (bundleAccessor == null) {
            CreateRemoteSdkForm.$$$reportNull$$$0(1);
        }
        this(project, parentContainer, ApplicationOnlySdkScopeController.INSTANCE, validator, bundleAccessor);
    }

    public CreateRemoteSdkForm(@Nullable Project project, @NotNull RemoteSdkEditorContainer parentContainer, @NotNull SdkScopeController sdkScopeController, @Nullable Runnable validator, @NotNull BundleAccessor bundleAccessor) {
        if (parentContainer == null) {
            CreateRemoteSdkForm.$$$reportNull$$$0(2);
        }
        if (sdkScopeController == null) {
            CreateRemoteSdkForm.$$$reportNull$$$0(3);
        }
        if (bundleAccessor == null) {
            CreateRemoteSdkForm.$$$reportNull$$$0(4);
        }
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myUnsupportedConnectionTypes = new HashSet<CredentialsType>();
        this.myLabelsColumnTracker = new CredentialsEditorLabelsColumnTracker();
        this.myProject = project;
        this.myParentContainer = parentContainer;
        Disposer.register((Disposable)parentContainer.getDisposable(), (Disposable)this);
        this.mySdkScopeController = sdkScopeController;
        this.myBundleAccessor = bundleAccessor;
        this.myValidator = validator;
        this.add((Component)this.myMainPanel, "Center");
        this.myStatusPanel = new StatusPanel();
        this.myStatusPanelHolder.setLayout(new BorderLayout());
        this.myStatusPanelHolder.add((Component)((Object)this.myStatusPanel), "Center");
        this.setNameVisible(false);
        this.setTempFilesPathVisible(false);
        this.myInterpreterPathLabel.setLabelFor((Component)this.myInterpreterPathField.getTextField());
        this.myInterpreterPathLabel.setText(this.myBundleAccessor.message("remote.interpreter.configure.path.label", new Object[0]));
        this.myHelpersPathLabel.setText(this.myBundleAccessor.message("remote.interpreter.configure.temp.files.path.label", new Object[0]));
        this.myInterpreterPathField.addActionListener(e -> this.showBrowsePathsDialog(this.myInterpreterPathField, this.myBundleAccessor.message("remote.interpreter.configure.path.title", new Object[0])));
        this.myHelpersPathField.addActionListener(e -> this.showBrowsePathsDialog(this.myHelpersPathField, this.myBundleAccessor.message("remote.interpreter.configure.temp.files.path.title", new Object[0])));
        this.myTypesPanel.setLayout(new ResizingCardLayout());
        this.myCredentialsType2Handler = new HashMap<CredentialsType, TypeHandler>();
        this.installExtendedTypes(project);
        this.installRadioListeners(this.myCredentialsType2Handler.values());
        if (this.isSshSudoSupported()) {
            this.myRunAsRootViaSudoJBCheckBox.setText(bundleAccessor.message("remote.interpreter.configure.ssh.run_as_root_via_sudo.checkbox", new Object[0]));
            this.myRunAsRootViaSudoHelpPanel.add((Component)ContextHelpLabel.create((String)bundleAccessor.message("remote.interpreter.configure.ssh.run_as_root_via_sudo.help", new Object[0])), "West");
        } else {
            this.myRunAsRootViaSudoPanel.setVisible(false);
        }
        Iterator<TypeHandler> iterator2 = this.myCredentialsType2Handler.values().iterator();
        if (iterator2.hasNext()) {
            iterator2.next().getRadioButton().setSelected(true);
        }
        this.radioSelected(true);
    }

    public void showBrowsePathsDialog(@NotNull TextFieldWithBrowseButton textFieldWithBrowseButton2, @NotNull String dialogTitle) {
        if (textFieldWithBrowseButton2 == null) {
            CreateRemoteSdkForm.$$$reportNull$$$0(5);
        }
        if (dialogTitle == null) {
            CreateRemoteSdkForm.$$$reportNull$$$0(6);
        }
        if (this.myConnectionType instanceof PathsBrowserDialogProvider) {
            ((PathsBrowserDialogProvider)((Object)this.myConnectionType)).showPathsBrowserDialog(this.myProject, textFieldWithBrowseButton2.getTextField(), dialogTitle, () -> this.createSdkDataInner());
        }
    }

    protected void disableChangeTypePanel() {
        this.myRadioPanel.setVisible(false);
    }

    private void installRadioListeners(@NotNull Collection<TypeHandler> values2) {
        if (values2 == null) {
            CreateRemoteSdkForm.$$$reportNull$$$0(7);
        }
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateRemoteSdkForm.this.radioSelected(true);
            }
        };
        for (TypeHandler typeHandler : values2) {
            typeHandler.getRadioButton().addActionListener(l);
        }
    }

    private void installExtendedTypes(@Nullable Project project) {
        List<CredentialsType<?>> types = CredentialsManager.getInstance().getAllTypes();
        types.sort(Comparator.comparing(CredentialsType::getWeight));
        for (CredentialsType<?> type : types) {
            List<CredentialsLanguageContribution> contributions;
            CredentialsEditorProvider editorProvider = (CredentialsEditorProvider)ObjectUtils.tryCast(type, CredentialsEditorProvider.class);
            if (editorProvider == null || (contributions = this.getContributions()).isEmpty()) continue;
            for (CredentialsLanguageContribution contribution : contributions) {
                if (contribution.getType() != type || !editorProvider.isAvailable(contribution)) continue;
                CredentialsEditor editor = editorProvider.createEditor(project, contribution, this);
                this.trackEditorLabelsColumn(editor);
                JBRadioButton typeButton = new JBRadioButton(editor.getName());
                this.myTypeButtonGroup.add((AbstractButton)typeButton);
                this.myRadioPanel.add((Component)typeButton);
                JPanel editorMainPanel = editor.getMainPanel();
                this.myTypesPanel.add((Component)editorMainPanel, type.getName());
                this.myCredentialsType2Handler.put(type, new TypeHandlerEx(typeButton, editorMainPanel, editorProvider.getDefaultInterpreterPath(this.myBundleAccessor), type, editor));
                if (this.myConnectionType != null) continue;
                this.myConnectionType = type;
            }
        }
    }

    @NotNull
    protected List<CredentialsLanguageContribution> getContributions() {
        List<CredentialsLanguageContribution> list2 = Collections.emptyList();
        if (list2 == null) {
            CreateRemoteSdkForm.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Override
    @NotNull
    public final SdkScopeController getSdkScopeController() {
        SdkScopeController sdkScopeController = this.mySdkScopeController;
        if (sdkScopeController == null) {
            CreateRemoteSdkForm.$$$reportNull$$$0(9);
        }
        return sdkScopeController;
    }

    private void radioSelected(boolean propagateEvent) {
        CredentialsType selectedType = this.getSelectedType();
        CardLayout layout = (CardLayout)this.myTypesPanel.getLayout();
        layout.show(this.myTypesPanel, selectedType.getName());
        this.changeWindowHeightToPreferred();
        this.setBrowseButtonsVisible(this.myCredentialsType2Handler.get(selectedType).isBrowsingAvailable());
        if (propagateEvent) {
            this.myStatusPanel.resetState();
            String interpreterPath = this.myInterpreterPathField.getText();
            if (StringUtil.isNotEmpty((String)interpreterPath)) {
                this.myCredentialsType2Handler.get(this.myConnectionType).setInterpreterPath(interpreterPath);
            }
            this.myConnectionType = selectedType;
            TypeHandler typeHandler = this.myCredentialsType2Handler.get(this.myConnectionType);
            this.myInterpreterPathField.setText(typeHandler.getInterpreterPath());
            typeHandler.onSelected();
        }
    }

    private void changeWindowHeightToPreferred() {
        Window window = ComponentUtil.getWindow((Component)this.myMainPanel);
        if (window != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                Dimension currentSize = window.getSize();
                Dimension preferredSize = window.getPreferredSize();
                window.setSize(currentSize.width, preferredSize.height);
            }, ModalityState.stateForComponent((Component)window));
        }
    }

    private CredentialsType getSelectedType() {
        for (Map.Entry<CredentialsType, TypeHandler> type2handler : this.myCredentialsType2Handler.entrySet()) {
            if (!type2handler.getValue().getRadioButton().isSelected()) continue;
            return type2handler.getKey();
        }
        throw new IllegalStateException();
    }

    private void setBrowseButtonsVisible(boolean visible) {
        this.myInterpreterPathField.getButton().setVisible(visible);
        this.myHelpersPathField.getButton().setVisible(visible);
    }

    @NotNull
    public final RemoteSdkCredentials computeSdkCredentials() throws ExecutionException, InterruptedException {
        T sdkData = this.createSdkDataInner();
        RemoteSdkCredentials remoteSdkCredentials = sdkData.getRemoteSdkCredentials(this.myProject, true);
        if (remoteSdkCredentials == null) {
            CreateRemoteSdkForm.$$$reportNull$$$0(10);
        }
        return remoteSdkCredentials;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        JComponent preferredFocusedComponent;
        if (this.myNameVisible) {
            return this.myNameField;
        }
        CredentialsType selectedType = this.getSelectedType();
        TypeHandler typeHandler = this.myCredentialsType2Handler.get(selectedType);
        if (typeHandler != null && (preferredFocusedComponent = UIUtil.getPreferredFocusedComponent((Container)typeHandler.getContentComponent())) != null) {
            return preferredFocusedComponent;
        }
        return this.myTypesPanel;
    }

    public T createSdkData() throws RemoteSdkException {
        return this.createSdkDataInner();
    }

    protected T createSdkDataInner() {
        T sdkData = this.doCreateSdkData(this.getInterpreterPath());
        this.myConnectionType.saveCredentials((RemoteSdkAdditionalData)sdkData, new CaseCollector(){

            @Override
            protected void processEx(CredentialsEditor editor, Object credentials) {
                editor.saveCredentials(credentials);
            }
        }.collectCases(new CredentialsCase[0]));
        sdkData.setRunAsRootViaSudo(this.myRunAsRootViaSudoJBCheckBox.isSelected());
        sdkData.setHelpersPath(this.getTempFilesPath());
        return sdkData;
    }

    @NotNull
    protected abstract T doCreateSdkData(@NotNull String var1);

    private void setNameVisible(boolean visible) {
        this.myNameField.setVisible(visible);
        this.myNameLabel.setVisible(visible);
        this.myNameVisible = visible;
    }

    public void setSdkName(String name) {
        if (name != null) {
            this.setNameVisible(true);
            this.myNameField.setText(name);
        }
    }

    public void init(@NotNull T data2) {
        if (data2 == null) {
            CreateRemoteSdkForm.$$$reportNull$$$0(11);
        }
        this.myConnectionType = data2.connectionCredentials().getRemoteConnectionType();
        TypeHandler typeHandler = this.myCredentialsType2Handler.get(this.myConnectionType);
        if (typeHandler == null) {
            typeHandler = new UnsupportedCredentialsTypeHandler(this.myConnectionType.getName());
            this.myUnsupportedConnectionTypes.add(this.myConnectionType);
            this.myCredentialsType2Handler.put(this.myConnectionType, typeHandler);
            this.myTypeButtonGroup.add((AbstractButton)typeHandler.getRadioButton());
            this.myRadioPanel.add((Component)typeHandler.getRadioButton());
            this.myTypesPanel.add((Component)typeHandler.getContentComponent(), this.myConnectionType.getName());
        }
        typeHandler.getRadioButton().setSelected(true);
        boolean connectionTypeIsSupported = !this.myUnsupportedConnectionTypes.contains(this.myConnectionType);
        this.myRadioPanel.setVisible(connectionTypeIsSupported);
        data2.switchOnConnectionType(new CaseCollector(){

            @Override
            protected void processEx(CredentialsEditor editor, Object credentials) {
                editor.init(credentials);
            }
        }.collectCases(new CredentialsCase[0]));
        this.radioSelected(false);
        String interpreterPath = data2.getInterpreterPath();
        this.myInterpreterPathField.setText(interpreterPath);
        typeHandler.setInterpreterPath(interpreterPath);
        this.setTempFilesPath((RemoteSdkAdditionalData)data2);
        if (this.isSshSudoSupported()) {
            this.myRunAsRootViaSudoJBCheckBox.setSelected(data2.isRunAsRootViaSudo());
        }
    }

    private void setTempFilesPath(RemoteSdkAdditionalData data2) {
        this.myHelpersPathField.setText(data2.getHelpersPath());
        if (!StringUtil.isEmpty((String)data2.getHelpersPath())) {
            this.setTempFilesPathVisible(true);
        }
    }

    protected void setTempFilesPathVisible(boolean visible) {
        this.myHelpersPathField.setVisible(visible);
        this.myHelpersPathLabel.setVisible(visible);
        this.myTempFilesPathVisible = visible;
    }

    protected void setInterpreterPathVisible(boolean visible) {
        this.myInterpreterPathField.setVisible(visible);
        this.myInterpreterPathLabel.setVisible(visible);
    }

    public String getInterpreterPath() {
        return this.myInterpreterPathField.getText().trim();
    }

    public String getTempFilesPath() {
        return this.myHelpersPathField.getText();
    }

    @Nullable
    public ValidationInfo validateRemoteInterpreter() {
        TypeHandler typeHandler = this.myCredentialsType2Handler.get(this.getSelectedType());
        if (StringUtil.isEmpty((String)this.getInterpreterPath())) {
            return new ValidationInfo(this.myBundleAccessor.message("remote.interpreter.unspecified.interpreter.path", new Object[0]), (JComponent)this.myInterpreterPathField);
        }
        if (this.myTempFilesPathVisible && StringUtil.isEmpty((String)this.getTempFilesPath())) {
            return new ValidationInfo(this.myBundleAccessor.message("remote.interpreter.unspecified.temp.files.path", new Object[0]), (JComponent)this.myHelpersPathField);
        }
        return typeHandler.validate();
    }

    @Nullable
    public String getSdkName() {
        if (this.myNameVisible) {
            return this.myNameField.getText().trim();
        }
        return null;
    }

    public void updateModifiedValues(RemoteSdkCredentials data2) {
        this.myHelpersPathField.setText(data2.getHelpersPath());
    }

    public void updateHelpersPath(String helpersPath) {
        this.myHelpersPathField.setText(helpersPath);
    }

    @Override
    public boolean isSdkInConsistentState(@NotNull CredentialsType<?> connectionType) {
        if (connectionType == null) {
            CreateRemoteSdkForm.$$$reportNull$$$0(12);
        }
        return this.myCredentialsType2Handler.get(connectionType).getRadioButton().isSelected();
    }

    public String getValidationError() {
        return this.myStatusPanel.getError();
    }

    @Nullable
    public String validateFinal() {
        return this.myCredentialsType2Handler.get(this.myConnectionType).validateFinal();
    }

    public void dispose() {
    }

    @Override
    @NotNull
    public final Disposable getDisposable() {
        CreateRemoteSdkForm createRemoteSdkForm = this;
        if (createRemoteSdkForm == null) {
            CreateRemoteSdkForm.$$$reportNull$$$0(13);
        }
        return createRemoteSdkForm;
    }

    @Override
    @NotNull
    public final BundleAccessor getBundleAccessor() {
        BundleAccessor bundleAccessor = this.myBundleAccessor;
        if (bundleAccessor == null) {
            CreateRemoteSdkForm.$$$reportNull$$$0(14);
        }
        return bundleAccessor;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public final RemoteSdkEditorContainer getParentContainer() {
        RemoteSdkEditorContainer remoteSdkEditorContainer = this.myParentContainer;
        if (remoteSdkEditorContainer == null) {
            CreateRemoteSdkForm.$$$reportNull$$$0(15);
        }
        return remoteSdkEditorContainer;
    }

    @Override
    @NotNull
    public StatusPanel getStatusPanel() {
        StatusPanel statusPanel = this.myStatusPanel;
        if (statusPanel == null) {
            CreateRemoteSdkForm.$$$reportNull$$$0(16);
        }
        return statusPanel;
    }

    @Override
    @Nullable
    public Runnable getValidator() {
        return this.myValidator;
    }

    public boolean isSshSudoSupported() {
        return false;
    }

    public boolean isConnectionTypeSupported(@NotNull CredentialsType type) {
        if (type == null) {
            CreateRemoteSdkForm.$$$reportNull$$$0(17);
        }
        return this.myCredentialsType2Handler.containsKey(type) && !this.myUnsupportedConnectionTypes.contains(type);
    }

    public void selectType(CredentialsType credentialsType) {
        for (Map.Entry<CredentialsType, TypeHandler> type2handler : this.myCredentialsType2Handler.entrySet()) {
            if (type2handler.getKey() != credentialsType) continue;
            type2handler.getValue().getRadioButton().setSelected(true);
            break;
        }
        this.radioSelected(true);
    }

    private void trackEditorLabelsColumn(@NotNull CredentialsEditor<?> editor) {
        if (editor == null) {
            CreateRemoteSdkForm.$$$reportNull$$$0(18);
        }
        if (editor instanceof FormWithAlignableLabelsColumn) {
            for (JBLabel label2 : ((FormWithAlignableLabelsColumn)((Object)editor)).getLabelsColumn()) {
                label2.addAncestorListener((AncestorListener)this.myLabelsColumnTracker);
                label2.addComponentListener((ComponentListener)this.myLabelsColumnTracker);
            }
        }
    }

    public void setInterpreterPath(@NotNull String interpreterPath) {
        if (interpreterPath == null) {
            CreateRemoteSdkForm.$$$reportNull$$$0(19);
        }
        this.myInterpreterPathField.setText(interpreterPath);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ButtonGroup buttonGroup2;
        JPanel jPanel2;
        JBCheckBox jBCheckBox;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        JTextField jTextField;
        JBLabel jBLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JBLabel jBLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JBLabel jBLabel3;
        JPanel jPanel7;
        this.myMainPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(10, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel7.add((Component)spacer, new GridConstraints(9, 0, 1, 1, 0, 2, 1, 6, new Dimension(-1, 10), null, null));
        this.myInterpreterPathLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/IdeBundle", CreateRemoteSdkForm.class).getString("label.remote.sdk.python.interpreter.path"));
        jPanel7.add((Component)jBLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInterpreterPathField = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel7.add((Component)textFieldWithBrowseButton3, new GridConstraints(4, 1, 1, 3, 0, 1, 6, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(1, 1, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myHelpersPathLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/IdeBundle", CreateRemoteSdkForm.class).getString("label.remote.sdk.helpers.path"));
        jPanel7.add((Component)jBLabel2, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHelpersPathField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel7.add((Component)textFieldWithBrowseButton2, new GridConstraints(6, 1, 1, 3, 0, 1, 6, 0, null, null, null));
        this.myNameLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/IdeBundle", CreateRemoteSdkForm.class).getString("label.remote.sdk.name"));
        jPanel7.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jPanel7.add((Component)jTextField, new GridConstraints(0, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myStatusPanelHolder = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel6, new GridConstraints(8, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myTypesPanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new CardLayout(0, 0));
        jPanel7.add((Component)jPanel5, new GridConstraints(3, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel9, new GridConstraints(2, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myRadioPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(3, 5, 0));
        jPanel9.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRunAsRootViaSudoPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel3, new GridConstraints(5, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myRunAsRootViaSudoJBCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setHorizontalAlignment(2);
        jBCheckBox.setHorizontalTextPosition(11);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/IdeBundle", CreateRemoteSdkForm.class).getString("checkbox.remote.sdk.run.as.root.via.sudo"));
        jBCheckBox.setToolTipText("");
        jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 2, 0, 0, 0, 0, null, null, null));
        this.myRunAsRootViaSudoHelpPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 2, 1, 1, 8, 2, 3, 3, null, null, null));
        jBLabel.setLabelFor(jTextField);
        this.myTypeButtonGroup = buttonGroup2 = new ButtonGroup();
        buttonGroup2 = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentContainer";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleAccessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkScopeController";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textFieldWithBrowseButton";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogTitle";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remote/ui/CreateRemoteSdkForm";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remote/ui/CreateRemoteSdkForm";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContributions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkScopeController";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSdkCredentials";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposable";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleAccessor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentContainer";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showBrowsePathsDialog";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "installRadioListeners";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSdkInConsistentState";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isConnectionTypeSupported";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "trackEditorLabelsColumn";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreterPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CredentialsEditorLabelsColumnTracker
    implements ComponentListener,
    AncestorListener {
        @NotNull
        private final Set<JBLabel> myVisibleLabelsColumn = new HashSet<JBLabel>();
        @Nullable
        private JBLabel myAnchoredLabel;

        private CredentialsEditorLabelsColumnTracker() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.onEvent(e.getComponent());
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.onEvent(e.getComponent());
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            this.onEvent(event.getComponent());
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            this.onEvent(event.getComponent());
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
            this.onEvent(event.getComponent());
        }

        private void onEvent(@Nullable Component component2) {
            if (component2 == null) {
                return;
            }
            if (component2 instanceof JBLabel) {
                if (component2.isShowing()) {
                    this.onLabelShowing((JBLabel)component2);
                } else {
                    this.onLabelHidden((JBLabel)component2);
                }
            }
        }

        private void onLabelShowing(@NotNull JBLabel component2) {
            if (component2 == null) {
                CredentialsEditorLabelsColumnTracker.$$$reportNull$$$0(0);
            }
            if (this.myVisibleLabelsColumn.add(component2)) {
                this.alignForm();
            }
        }

        protected void onLabelHidden(@NotNull JBLabel component2) {
            if (component2 == null) {
                CredentialsEditorLabelsColumnTracker.$$$reportNull$$$0(1);
            }
            if (this.myVisibleLabelsColumn.remove(component2)) {
                this.alignForm();
            }
        }

        private void alignForm() {
            CreateRemoteSdkForm.this.myInterpreterPathLabel.setAnchor(null);
            if (this.myAnchoredLabel != null) {
                this.myAnchoredLabel.setAnchor(null);
                this.myAnchoredLabel = null;
            }
            if (!this.myVisibleLabelsColumn.isEmpty()) {
                JBLabel labelWithMaxWidth = Collections.max(this.myVisibleLabelsColumn, Comparator.comparingInt(o -> o.getPreferredSize().width));
                if ((double)((CreateRemoteSdkForm)CreateRemoteSdkForm.this).myInterpreterPathLabel.getPreferredSize().width < labelWithMaxWidth.getPreferredSize().getWidth()) {
                    CreateRemoteSdkForm.this.myInterpreterPathLabel.setAnchor((JComponent)labelWithMaxWidth);
                } else {
                    for (JBLabel label2 : this.myVisibleLabelsColumn) {
                        label2.setAnchor((JComponent)CreateRemoteSdkForm.this.myInterpreterPathLabel);
                        label2.revalidate();
                    }
                    this.myAnchoredLabel = labelWithMaxWidth;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "component";
            objectArray2[1] = "com/intellij/remote/ui/CreateRemoteSdkForm$CredentialsEditorLabelsColumnTracker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onLabelShowing";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onLabelHidden";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ResizingCardLayout
    extends CardLayout {
        private ResizingCardLayout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets insets = parent.getInsets();
                int ncomponents = parent.getComponentCount();
                int w = 0;
                int h = 0;
                for (int i2 = 0; i2 < ncomponents; ++i2) {
                    Component comp = parent.getComponent(i2);
                    if (!comp.isVisible()) continue;
                    Dimension d = comp.getPreferredSize();
                    if (d.width > w) {
                        w = d.width;
                    }
                    if (d.height <= h) continue;
                    h = d.height;
                }
                return new Dimension(insets.left + insets.right + w + this.getHgap() * 2, insets.top + insets.bottom + h + this.getVgap() * 2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets insets = parent.getInsets();
                int ncomponents = parent.getComponentCount();
                int w = 0;
                int h = 0;
                for (int i2 = 0; i2 < ncomponents; ++i2) {
                    Component comp = parent.getComponent(i2);
                    if (!comp.isVisible()) continue;
                    Dimension d = comp.getMinimumSize();
                    if (d.width > w) {
                        w = d.width;
                    }
                    if (d.height <= h) continue;
                    h = d.height;
                }
                return new Dimension(insets.left + insets.right + w + this.getHgap() * 2, insets.top + insets.bottom + h + this.getVgap() * 2);
            }
        }
    }

    private abstract class CaseCollector {
        private CaseCollector() {
        }

        public CredentialsCase[] collectCases(CredentialsCase ... cases2) {
            ArrayList<1> exCases = new ArrayList<1>();
            for (TypeHandler typeHandler : CreateRemoteSdkForm.this.myCredentialsType2Handler.values()) {
                final TypeHandlerEx handlerEx = (TypeHandlerEx)ObjectUtils.tryCast((Object)typeHandler, TypeHandlerEx.class);
                if (handlerEx == null) continue;
                exCases.add(new CredentialsCase(){

                    public CredentialsType getType() {
                        return handlerEx.getType();
                    }

                    public void process(Object credentials) {
                        CaseCollector.this.processEx(handlerEx.getEditor(), credentials);
                    }
                });
            }
            return (CredentialsCase[])ArrayUtil.mergeArrays((Object[])cases2, (Object[])exCases.toArray(new CredentialsCase[0]));
        }

        protected abstract void processEx(CredentialsEditor var1, Object var2);
    }

    private class TypeHandlerEx
    implements TypeHandler {
        @NotNull
        private final JBRadioButton myRadioButton;
        @NotNull
        private final JPanel myPanel;
        @Nullable
        private String myInterpreterPath;
        @NotNull
        private final CredentialsType<?> myType;
        @NotNull
        private final CredentialsEditor<?> myEditor;

        TypeHandlerEx(@NotNull JBRadioButton radioButton, @Nullable JPanel panel2, @NotNull String defaultInterpreterPath, @NotNull CredentialsType<?> type, CredentialsEditor editor) {
            if (radioButton == null) {
                TypeHandlerEx.$$$reportNull$$$0(0);
            }
            if (panel2 == null) {
                TypeHandlerEx.$$$reportNull$$$0(1);
            }
            if (type == null) {
                TypeHandlerEx.$$$reportNull$$$0(2);
            }
            if (editor == null) {
                TypeHandlerEx.$$$reportNull$$$0(3);
            }
            this.myRadioButton = radioButton;
            this.myPanel = panel2;
            this.myInterpreterPath = defaultInterpreterPath;
            this.myType = type;
            this.myEditor = editor;
        }

        @NotNull
        public CredentialsEditor getEditor() {
            CredentialsEditor<?> credentialsEditor = this.myEditor;
            if (credentialsEditor == null) {
                TypeHandlerEx.$$$reportNull$$$0(4);
            }
            return credentialsEditor;
        }

        @Override
        public void onSelected() {
            CreateRemoteSdkForm.this.myConnectionType = this.myType;
            this.myEditor.onSelected();
        }

        @Override
        @NotNull
        public JPanel getContentComponent() {
            JPanel jPanel2 = this.myPanel;
            if (jPanel2 == null) {
                TypeHandlerEx.$$$reportNull$$$0(5);
            }
            return jPanel2;
        }

        @Override
        @NotNull
        public JBRadioButton getRadioButton() {
            JBRadioButton jBRadioButton = this.myRadioButton;
            if (jBRadioButton == null) {
                TypeHandlerEx.$$$reportNull$$$0(6);
            }
            return jBRadioButton;
        }

        @Override
        public void setInterpreterPath(@Nullable String interpreterPath) {
            this.myInterpreterPath = interpreterPath;
        }

        @Override
        @Nullable
        public String getInterpreterPath() {
            return this.myInterpreterPath;
        }

        @Override
        @Nullable
        public ValidationInfo validate() {
            return this.myEditor.validate();
        }

        @Override
        @Nullable
        public String validateFinal() {
            return this.myEditor.validateFinal(() -> CreateRemoteSdkForm.this.createSdkDataInner(), helpersPath -> CreateRemoteSdkForm.this.updateHelpersPath((String)helpersPath));
        }

        @NotNull
        public CredentialsType<?> getType() {
            CredentialsType<?> credentialsType = this.myType;
            if (credentialsType == null) {
                TypeHandlerEx.$$$reportNull$$$0(7);
            }
            return credentialsType;
        }

        @Override
        public boolean isBrowsingAvailable() {
            return this.myType instanceof PathsBrowserDialogProvider;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "radioButton";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/remote/ui/CreateRemoteSdkForm$TypeHandlerEx";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/remote/ui/CreateRemoteSdkForm$TypeHandlerEx";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentComponent";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRadioButton";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class UnsupportedCredentialsTypeHandler
    implements TypeHandler {
        @NotNull
        private final JBRadioButton myTypeButton;
        @NotNull
        private final JPanel myPanel;

        private UnsupportedCredentialsTypeHandler(@Nullable String credentialsTypeName) {
            this.myTypeButton = new JBRadioButton(credentialsTypeName);
            this.myPanel = new JPanel(new BorderLayout());
            String errorMessage = ExecutionBundle.message((String)"remote.interpreter.cannot.load.interpreter.message", (Object[])new Object[]{credentialsTypeName});
            JBLabel errorLabel = new JBLabel(errorMessage);
            errorLabel.setIcon(AllIcons.General.BalloonError);
            this.myPanel.add((Component)errorLabel, "Center");
        }

        @Override
        @NotNull
        public JPanel getContentComponent() {
            JPanel jPanel2 = this.myPanel;
            if (jPanel2 == null) {
                UnsupportedCredentialsTypeHandler.$$$reportNull$$$0(0);
            }
            return jPanel2;
        }

        @Override
        @NotNull
        public JBRadioButton getRadioButton() {
            JBRadioButton jBRadioButton = this.myTypeButton;
            if (jBRadioButton == null) {
                UnsupportedCredentialsTypeHandler.$$$reportNull$$$0(1);
            }
            return jBRadioButton;
        }

        @Override
        @Nullable
        public String getInterpreterPath() {
            return null;
        }

        @Override
        public void setInterpreterPath(@Nullable String interpreterPath) {
        }

        @Override
        public void onSelected() {
        }

        @Override
        @Nullable
        public ValidationInfo validate() {
            return null;
        }

        @Override
        @Nullable
        public String validateFinal() {
            return null;
        }

        @Override
        public boolean isBrowsingAvailable() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/remote/ui/CreateRemoteSdkForm$UnsupportedCredentialsTypeHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRadioButton";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static interface TypeHandler {
        @NotNull
        public JPanel getContentComponent();

        @NotNull
        public JBRadioButton getRadioButton();

        public void onSelected();

        @Nullable
        public String getInterpreterPath();

        public void setInterpreterPath(@Nullable String var1);

        @Nullable
        public ValidationInfo validate();

        @Nullable
        public String validateFinal();

        public boolean isBrowsingAvailable();
    }
}

