/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurator;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.configuration.deployment.SingletonDeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeployToServerConfigurationType
extends ConfigurationTypeBase {
    private final ServerType<?> myServerType;
    private final MultiSourcesConfigurationFactory myMultiSourcesFactory;
    private final Map<SingletonDeploymentSourceType, SingletonTypeConfigurationFactory> myPerTypeFactories;

    public DeployToServerConfigurationType(@NotNull ServerType<?> serverType) {
        if (serverType == null) {
            DeployToServerConfigurationType.$$$reportNull$$$0(0);
        }
        super(serverType.getId() + "-deploy", serverType.getDeploymentConfigurationTypePresentableName(), CloudBundle.message((String)"deploy.to.server.configuration.type.description", (Object[])new Object[]{serverType.getPresentableName()}), serverType.getIcon());
        this.myPerTypeFactories = new HashMap<SingletonDeploymentSourceType, SingletonTypeConfigurationFactory>();
        this.myServerType = serverType;
        if (this.myServerType.mayHaveProjectSpecificDeploymentSources()) {
            this.myMultiSourcesFactory = new MultiSourcesConfigurationFactory();
            this.addFactory(this.myMultiSourcesFactory);
        } else {
            this.myMultiSourcesFactory = null;
        }
        for (SingletonDeploymentSourceType next : serverType.getSingletonDeploymentSourceTypes()) {
            SingletonTypeConfigurationFactory nextFactory = new SingletonTypeConfigurationFactory(next);
            this.addFactory(nextFactory);
            this.myPerTypeFactories.put(next, nextFactory);
        }
    }

    boolean isForServerType(@NotNull ServerType<?> serverType) {
        if (serverType == null) {
            DeployToServerConfigurationType.$$$reportNull$$$0(1);
        }
        return serverType.equals(this.myServerType);
    }

    @NotNull
    public ConfigurationFactory getFactoryForType(@Nullable DeploymentSourceType<?> sourceType) {
        MultiSourcesConfigurationFactory result2 = null;
        if (sourceType instanceof SingletonDeploymentSourceType && this.myServerType.getSingletonDeploymentSourceTypes().contains(sourceType)) {
            result2 = this.myPerTypeFactories.get(sourceType);
        }
        if (result2 == null) {
            result2 = this.myMultiSourcesFactory;
        }
        assert (result2 != null) : "server type: " + this.myServerType + ", requested source type: " + sourceType;
        MultiSourcesConfigurationFactory multiSourcesConfigurationFactory = result2;
        if (multiSourcesConfigurationFactory == null) {
            DeployToServerConfigurationType.$$$reportNull$$$0(2);
        }
        return multiSourcesConfigurationFactory;
    }

    @Deprecated
    public ConfigurationFactoryEx getFactory() {
        return (ConfigurationFactoryEx)this.getFactoryForType(null);
    }

    @NotNull
    public ServerType<?> getServerType() {
        ServerType<?> serverType = this.myServerType;
        if (serverType == null) {
            DeployToServerConfigurationType.$$$reportNull$$$0(3);
        }
        return serverType;
    }

    public String getHelpTopic() {
        return "reference.dialogs.rundebug." + this.myServerType.getId() + "-deploy";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactoryForType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isForServerType";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public final class SingletonTypeConfigurationFactory
    extends DeployToServerConfigurationFactory {
        private final SingletonDeploymentSourceType mySourceType;

        public SingletonTypeConfigurationFactory(SingletonDeploymentSourceType sourceType) {
            if (sourceType == null) {
                SingletonTypeConfigurationFactory.$$$reportNull$$$0(0);
            }
            this.mySourceType = sourceType;
        }

        @NotNull
        public String getId() {
            String string = this.mySourceType.getId();
            if (string == null) {
                SingletonTypeConfigurationFactory.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        @Nls
        public String getName() {
            String string = this.mySourceType.getPresentableName();
            if (string == null) {
                SingletonTypeConfigurationFactory.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public DeployToServerRunConfiguration createTemplateConfiguration(@NotNull Project project) {
            if (project == null) {
                SingletonTypeConfigurationFactory.$$$reportNull$$$0(3);
            }
            DeployToServerRunConfiguration result2 = super.createTemplateConfiguration(project);
            result2.lockDeploymentSource(this.mySourceType);
            DeployToServerRunConfiguration deployToServerRunConfiguration = result2;
            if (deployToServerRunConfiguration == null) {
                SingletonTypeConfigurationFactory.$$$reportNull$$$0(4);
            }
            return deployToServerRunConfiguration;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceType";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationType$SingletonTypeConfigurationFactory";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationType$SingletonTypeConfigurationFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTemplateConfiguration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createTemplateConfiguration";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public final class MultiSourcesConfigurationFactory
    extends DeployToServerConfigurationFactory {
        @NotNull
        public String getId() {
            String string = DeployToServerConfigurationType.this.getServerType().getDeploymentConfigurationFactoryId();
            if (string == null) {
                MultiSourcesConfigurationFactory.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationType$MultiSourcesConfigurationFactory", "getId"));
        }
    }

    public abstract class DeployToServerConfigurationFactory
    extends ConfigurationFactoryEx<DeployToServerRunConfiguration<?, ?>> {
        public DeployToServerConfigurationFactory() {
            super((ConfigurationType)DeployToServerConfigurationType.this);
        }

        public boolean isApplicable(@NotNull Project project) {
            if (project == null) {
                DeployToServerConfigurationFactory.$$$reportNull$$$0(0);
            }
            return DeployToServerConfigurationType.this.myServerType.canAutoDetectConfiguration() || !RemoteServersManager.getInstance().getServers(DeployToServerConfigurationType.this.myServerType).isEmpty();
        }

        @NotNull
        public DeployToServerRunConfiguration createTemplateConfiguration(@NotNull Project project) {
            if (project == null) {
                DeployToServerConfigurationFactory.$$$reportNull$$$0(1);
            }
            DeploymentConfigurator deploymentConfigurator = DeployToServerConfigurationType.this.myServerType.createDeploymentConfigurator(project);
            return new DeployToServerRunConfiguration(project, this, "", DeployToServerConfigurationType.this.myServerType, deploymentConfigurator);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationType$DeployToServerConfigurationFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isApplicable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createTemplateConfiguration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

