/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.terminal.PtyBasedProcess;
import com.jediterm.terminal.Questioner;
import com.jediterm.terminal.TtyConnector;
import com.pty4j.PtyProcess;
import com.pty4j.WinSize;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class ProcessHandlerTtyConnector
implements TtyConnector {
    private final BaseProcessHandler<?> myProcessHandler;
    private final Process myPtyProcess;
    private final Charset myCharset;

    public ProcessHandlerTtyConnector(@NotNull ProcessHandler processHandler2, @NotNull Charset charset) {
        if (processHandler2 == null) {
            ProcessHandlerTtyConnector.$$$reportNull$$$0(0);
        }
        if (charset == null) {
            ProcessHandlerTtyConnector.$$$reportNull$$$0(1);
        }
        if (!(processHandler2 instanceof BaseProcessHandler)) {
            throw new IllegalArgumentException("Works currently only with BaseProcessHandler");
        }
        this.myProcessHandler = (BaseProcessHandler)processHandler2;
        this.myPtyProcess = this.myProcessHandler.getProcess();
        if (!(this.myPtyProcess instanceof PtyBasedProcess) && !(this.myPtyProcess instanceof PtyProcess)) {
            throw new IllegalArgumentException("Not a PTY based process: " + this.myPtyProcess.getClass());
        }
        this.myCharset = charset;
    }

    public boolean init(Questioner q) {
        return true;
    }

    public void close() {
        this.myProcessHandler.destroyProcess();
    }

    public void resize(Dimension termSize, Dimension pixelSize) {
        if (termSize != null && pixelSize != null) {
            if (this.myPtyProcess instanceof PtyProcess) {
                PtyProcess ptyProcess = (PtyProcess)this.myPtyProcess;
                if (ptyProcess.isRunning()) {
                    ptyProcess.setWinSize(new WinSize(termSize.width, termSize.height, pixelSize.width, pixelSize.height));
                }
            } else {
                assert (this.myPtyProcess instanceof PtyBasedProcess);
                ((PtyBasedProcess)((Object)this.myPtyProcess)).resizePtyWindow(termSize.width, termSize.height, pixelSize.width, pixelSize.height);
            }
        }
    }

    public String getName() {
        return "TtyConnector:" + this.myProcessHandler.toString();
    }

    public int read(char[] buf, int offset, int length) throws IOException {
        throw new IllegalStateException("all reads should be performed by ProcessHandler");
    }

    public void write(byte[] bytes) throws IOException {
        this.writeBytes(bytes);
    }

    public boolean isConnected() {
        return false;
    }

    public void write(String string) throws IOException {
        this.writeBytes(string.getBytes(this.myCharset));
    }

    public int waitFor() throws InterruptedException {
        return this.myPtyProcess.waitFor();
    }

    private void writeBytes(byte[] bytes) throws IOException {
        OutputStream input = this.myProcessHandler.getProcessInput();
        input.write(bytes);
        input.flush();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "processHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "charset";
                break;
            }
        }
        objectArray[1] = "com/intellij/terminal/ProcessHandlerTtyConnector";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

