/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.ImageObserver;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class NotificationBalloonShadowBorderProvider
implements BalloonImpl.ShadowBorderProvider {
    private static final Insets INSETS = new JBInsets(4, 6, 8, 6);
    private final Color myFillColor;
    private final Color myBorderColor;

    public NotificationBalloonShadowBorderProvider(@NotNull Color fillColor, @NotNull Color borderColor) {
        if (fillColor == null) {
            NotificationBalloonShadowBorderProvider.$$$reportNull$$$0(0);
        }
        if (borderColor == null) {
            NotificationBalloonShadowBorderProvider.$$$reportNull$$$0(1);
        }
        this.myFillColor = fillColor;
        this.myBorderColor = borderColor;
    }

    @Override
    @NotNull
    public Insets getInsets() {
        Insets insets = INSETS;
        if (insets == null) {
            NotificationBalloonShadowBorderProvider.$$$reportNull$$$0(2);
        }
        return insets;
    }

    @Override
    public void paintShadow(@NotNull JComponent component2, @NotNull Graphics g) {
        if (component2 == null) {
            NotificationBalloonShadowBorderProvider.$$$reportNull$$$0(3);
        }
        if (g == null) {
            NotificationBalloonShadowBorderProvider.$$$reportNull$$$0(4);
        }
        int width = component2.getWidth();
        int height = component2.getHeight();
        int topLeftWidth = AllIcons.Ide.Shadow.TopLeft.getIconWidth();
        int topLeftHeight = AllIcons.Ide.Shadow.TopLeft.getIconHeight();
        int topRightWidth = AllIcons.Ide.Shadow.TopRight.getIconWidth();
        int topRightHeight = AllIcons.Ide.Shadow.TopRight.getIconHeight();
        int bottomLeftWidth = AllIcons.Ide.Shadow.BottomLeft.getIconWidth();
        int bottomLeftHeight = AllIcons.Ide.Shadow.BottomLeft.getIconHeight();
        int bottomRightWidth = AllIcons.Ide.Shadow.BottomRight.getIconWidth();
        int bottomRightHeight = AllIcons.Ide.Shadow.BottomRight.getIconHeight();
        int topWidth = AllIcons.Ide.Shadow.Top.getIconWidth();
        int bottomWidth = AllIcons.Ide.Shadow.Bottom.getIconWidth();
        int bottomHeight = AllIcons.Ide.Shadow.Bottom.getIconHeight();
        int leftHeight = AllIcons.Ide.Shadow.Left.getIconHeight();
        int rightWidth = AllIcons.Ide.Shadow.Right.getIconWidth();
        int rightHeight = AllIcons.Ide.Shadow.Right.getIconHeight();
        NotificationBalloonShadowBorderProvider.drawLine(component2, g, AllIcons.Ide.Shadow.Top, width, topLeftWidth, topRightWidth, topWidth, 0, true);
        NotificationBalloonShadowBorderProvider.drawLine(component2, g, AllIcons.Ide.Shadow.Bottom, width, bottomLeftWidth, bottomRightWidth, bottomWidth, height - bottomHeight, true);
        NotificationBalloonShadowBorderProvider.drawLine(component2, g, AllIcons.Ide.Shadow.Left, height, topLeftHeight, bottomLeftHeight, leftHeight, 0, false);
        NotificationBalloonShadowBorderProvider.drawLine(component2, g, AllIcons.Ide.Shadow.Right, height, topRightHeight, bottomRightHeight, rightHeight, width - rightWidth, false);
        AllIcons.Ide.Shadow.TopLeft.paintIcon(component2, g, 0, 0);
        AllIcons.Ide.Shadow.TopRight.paintIcon(component2, g, width - topRightWidth, 0);
        AllIcons.Ide.Shadow.BottomRight.paintIcon(component2, g, width - bottomRightWidth, height - bottomRightHeight);
        AllIcons.Ide.Shadow.BottomLeft.paintIcon(component2, g, 0, height - bottomLeftHeight);
    }

    private static void drawLine(@NotNull JComponent component2, @NotNull Graphics g, @NotNull Icon icon2, int fullLength, int start2, int end, int step, int start22, boolean horizontal) {
        int i2;
        if (component2 == null) {
            NotificationBalloonShadowBorderProvider.$$$reportNull$$$0(5);
        }
        if (g == null) {
            NotificationBalloonShadowBorderProvider.$$$reportNull$$$0(6);
        }
        if (icon2 == null) {
            NotificationBalloonShadowBorderProvider.$$$reportNull$$$0(7);
        }
        int length = fullLength - start2 - end;
        int count = length / step;
        int calcLength = step * count;
        int lastValue = start2 + calcLength;
        if (horizontal) {
            for (i2 = start2; i2 < lastValue; i2 += step) {
                icon2.paintIcon(component2, g, i2, start22);
            }
        } else {
            for (i2 = start2; i2 < lastValue; i2 += step) {
                icon2.paintIcon(component2, g, start22, i2);
            }
        }
        if (calcLength < length) {
            Icon iconSnapshot = IconLoader.getIconSnapshot((Icon)icon2);
            Image image = IconUtil.toImage((Icon)iconSnapshot, (ScaleContext)ScaleContext.create((Component)component2));
            if (horizontal) {
                StartupUiUtil.drawImage((Graphics)g, (Image)image, (Rectangle)new Rectangle(lastValue, start22, length - calcLength, iconSnapshot.getIconHeight()), (Rectangle)new Rectangle(0, 0, length - calcLength, iconSnapshot.getIconHeight()), (ImageObserver)component2);
            } else {
                UIUtil.drawImage((Graphics)g, (Image)image, (Rectangle)new Rectangle(start22, lastValue, iconSnapshot.getIconWidth(), length - calcLength), (Rectangle)new Rectangle(0, 0, iconSnapshot.getIconWidth(), length - calcLength), (ImageObserver)component2);
            }
        }
    }

    @Override
    public void paintBorder(@NotNull Rectangle bounds2, @NotNull Graphics2D g) {
        if (bounds2 == null) {
            NotificationBalloonShadowBorderProvider.$$$reportNull$$$0(8);
        }
        if (g == null) {
            NotificationBalloonShadowBorderProvider.$$$reportNull$$$0(9);
        }
        g.setColor(this.myFillColor);
        g.fill(new Rectangle2D.Double(bounds2.x, bounds2.y, bounds2.width, bounds2.height));
        g.setColor(this.myBorderColor);
        g.draw(new RoundRectangle2D.Double((double)bounds2.x + 0.5, (double)bounds2.y + 0.5, bounds2.width - 1, bounds2.height - 1, 3.0, 3.0));
    }

    @Override
    public void paintPointingShape(@NotNull Rectangle bounds2, @NotNull Point pointTarget, @NotNull Balloon.Position position, @NotNull Graphics2D g) {
        int y;
        int x;
        int length;
        if (bounds2 == null) {
            NotificationBalloonShadowBorderProvider.$$$reportNull$$$0(10);
        }
        if (pointTarget == null) {
            NotificationBalloonShadowBorderProvider.$$$reportNull$$$0(11);
        }
        if (position == null) {
            NotificationBalloonShadowBorderProvider.$$$reportNull$$$0(12);
        }
        if (g == null) {
            NotificationBalloonShadowBorderProvider.$$$reportNull$$$0(13);
        }
        if (position == Balloon.Position.above) {
            length = NotificationBalloonShadowBorderProvider.INSETS.bottom;
            x = pointTarget.x;
            y = bounds2.y + bounds2.height + length;
        } else if (position == Balloon.Position.below) {
            length = NotificationBalloonShadowBorderProvider.INSETS.top;
            x = pointTarget.x;
            y = bounds2.y - length;
        } else if (position == Balloon.Position.atRight) {
            length = NotificationBalloonShadowBorderProvider.INSETS.left;
            x = bounds2.x - length;
            y = pointTarget.y;
        } else {
            length = NotificationBalloonShadowBorderProvider.INSETS.right;
            x = bounds2.x + bounds2.width + length;
            y = pointTarget.y;
        }
        Polygon p = new Polygon();
        p.addPoint(x, y);
        length += 2;
        if (position == Balloon.Position.above) {
            p.addPoint(x - length, y - length);
            p.addPoint(x + length, y - length);
        } else if (position == Balloon.Position.below) {
            p.addPoint(x - length, y + length);
            p.addPoint(x + length, y + length);
        } else if (position == Balloon.Position.atRight) {
            p.addPoint(x + length, y - length);
            p.addPoint(x + length, y + length);
        } else {
            p.addPoint(x - length, y - length);
            p.addPoint(x - length, y + length);
        }
        g.setColor(this.myFillColor);
        g.fillPolygon(p);
        g.setColor(this.myBorderColor);
        length -= 2;
        if (position == Balloon.Position.above) {
            g.drawLine(x, y, x - length, y - length);
            g.drawLine(x, y, x + length, y - length);
        } else if (position == Balloon.Position.below) {
            g.drawLine(x, y, x - length, y + length);
            g.drawLine(x, y, x + length, y + length);
        } else if (position == Balloon.Position.atRight) {
            g.drawLine(x, y, x + length, y - length);
            g.drawLine(x, y, x + length, y + length);
        } else {
            g.drawLine(x, y, x - length, y - length);
            g.drawLine(x, y, x - length, y + length);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fillColor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "borderColor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/NotificationBalloonShadowBorderProvider";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointTarget";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/NotificationBalloonShadowBorderProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "paintShadow";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "drawLine";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "paintBorder";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "paintPointingShape";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

