/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.ui.colorpicker.ColorValuePanelKt;
import com.intellij.ui.colorpicker.DigitColorDocument;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\b\u0010\r\u001a\u00020\u0003H\u0016R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ui/colorpicker/ColorValueField;", "Ljavax/swing/JTextField;", "hex", "", "showAlpha", "(ZZ)V", "colorValue", "", "getColorValue", "()I", "increaseValue", "", "diff", "isFocusable", "intellij.platform.ide.impl"})
public final class ColorValueField
extends JTextField {
    private final boolean hex;
    private final boolean showAlpha;

    private final void increaseValue(int diff) {
        boolean bl = !this.hex;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Document document = this.getDocument();
        if (document == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.ui.colorpicker.DigitColorDocument");
        }
        DigitColorDocument doc = (DigitColorDocument)document;
        String string = doc.getText(0, doc.getLength());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"doc.getText(0, doc.length)");
        String string2 = string;
        boolean bl5 = false;
        int newValue2 = Integer.parseInt(string2) + diff;
        int valueInRange = Math.max(doc.getValueRange().getStart(), Math.min(newValue2, doc.getValueRange().getEndInclusive()));
        this.setText(String.valueOf(valueInRange));
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    public final int getColorValue() {
        String rawText;
        String string = rawText = this.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"rawText");
        return StringsKt.isBlank((CharSequence)string) ? 0 : Integer.parseInt(rawText, this.hex ? 16 : 10);
    }

    public ColorValueField(boolean hex, boolean showAlpha) {
        super(ColorValuePanelKt.access$fieldLength(hex, showAlpha));
        this.hex = hex;
        this.showAlpha = showAlpha;
        this.setHorizontalAlignment(0);
        this.setEnabled(true);
        this.setEditable(true);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@Nullable FocusEvent e) {
                this.selectAll();
            }

            @Override
            public void focusLost(@Nullable FocusEvent e) {
                Document document = this.getDocument();
                if (document == null) {
                    return;
                }
                int size = document.getLength();
                this.setSelectionStart(size);
                this.setSelectionEnd(size);
            }
        });
        if (!this.hex) {
            Serializable serializable = this.getInputMap(0);
            boolean bl = false;
            boolean bl2 = false;
            InputMap $this$with = serializable;
            boolean bl3 = false;
            $this$with.put(KeyStroke.getKeyStroke(38, 0), "up");
            $this$with.put(KeyStroke.getKeyStroke(40, 0), "down");
            serializable = this.getActionMap();
            bl = false;
            bl2 = false;
            $this$with = serializable;
            boolean bl4 = false;
            ((ActionMap)((Object)$this$with)).put("up", new AbstractAction(this){
                final /* synthetic */ ColorValueField this$0;
                {
                    this.this$0 = colorValueField;
                }

                public void actionPerformed(@NotNull ActionEvent e) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    ColorValueField.access$increaseValue(this.this$0, 1);
                }
            });
            ((ActionMap)((Object)$this$with)).put("down", new AbstractAction(this){
                final /* synthetic */ ColorValueField this$0;
                {
                    this.this$0 = colorValueField;
                }

                public void actionPerformed(@NotNull ActionEvent e) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    ColorValueField.access$increaseValue(this.this$0, -1);
                }
            });
        }
    }

    public /* synthetic */ ColorValueField(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2);
    }

    public ColorValueField() {
        this(false, false, 3, null);
    }

    public static final /* synthetic */ void access$increaseValue(ColorValueField $this, int diff) {
        $this.increaseValue(diff);
    }
}

