/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ex.ClipboardUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;

public class AnalyzeStacktraceDialog
extends DialogWrapper {
    private final Project myProject;
    protected AnalyzeStacktraceUtil.StacktraceEditorPanel myEditorPanel;

    protected AnalyzeStacktraceDialog(Project project) {
        super(project, true);
        this.myProject = project;
        this.setTitle(IdeBundle.message((String)"unscramble.dialog.title", (Object[])new Object[0]));
        this.init();
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)new JLabel("Put a stacktrace here:"), "North");
        this.myEditorPanel = AnalyzeStacktraceUtil.createEditorPanel(this.myProject, this.myDisposable);
        this.myEditorPanel.pasteTextFromClipboard();
        panel2.add((Component)this.myEditorPanel, "Center");
        return panel2;
    }

    protected void doOKAction() {
        AnalyzeStacktraceUtil.addConsole(this.myProject, null, "<Stacktrace>", this.myEditorPanel.getText());
        super.doOKAction();
    }

    public JComponent getPreferredFocusedComponent() {
        String text = ClipboardUtil.getTextInClipboard();
        if (text == null || text.isEmpty()) {
            return this.myEditorPanel.getEditorComponent();
        }
        JRootPane pane2 = this.getRootPane();
        return pane2 != null ? pane2.getDefaultButton() : super.getPreferredFocusedComponent();
    }
}

