/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.classpath;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ui.classpath.GlobalLibraryReferenceElement;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SingleRootClasspathElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimpleClasspathElementFactory {
    private SimpleClasspathElementFactory() {
    }

    public static List<SimpleClasspathElement> createElements(@Nullable Project project, @NotNull Element element2) {
        Library library;
        LibraryTable libraryTable;
        if (element2 == null) {
            SimpleClasspathElementFactory.$$$reportNull$$$0(0);
        }
        String name = element2.getAttributeValue("name");
        String level = element2.getAttributeValue("level");
        String url = element2.getChildText("url");
        if (!StringUtil.isEmpty((String)url)) {
            return Collections.singletonList(new SingleRootClasspathElement(url));
        }
        if (name == null || level == null) {
            return Collections.emptyList();
        }
        if ("application".equals(level)) {
            return Collections.singletonList(new GlobalLibraryReferenceElement(name));
        }
        if (project != null && (libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(level, project)) != null && (library = libraryTable.getLibraryByName(name)) != null) {
            return SimpleClasspathElementFactory.createElements(library);
        }
        return Collections.emptyList();
    }

    public static List<SimpleClasspathElement> createElements(@NotNull Library library) {
        LibraryTable table;
        if (library == null) {
            SimpleClasspathElementFactory.$$$reportNull$$$0(1);
        }
        if ((table = library.getTable()) != null && "application".equals(table.getTableLevel())) {
            return Collections.singletonList(new GlobalLibraryReferenceElement(library.getName()));
        }
        ArrayList<SimpleClasspathElement> elements2 = new ArrayList<SimpleClasspathElement>();
        for (VirtualFile file2 : library.getFiles(OrderRootType.CLASSES)) {
            elements2.add(new SingleRootClasspathElement(file2.getUrl()));
        }
        return elements2;
    }

    public static List<SimpleClasspathElement> createElements(String ... urls) {
        ArrayList<SimpleClasspathElement> list2 = new ArrayList<SimpleClasspathElement>();
        for (String url : urls) {
            list2.add(new SingleRootClasspathElement(url));
        }
        return list2;
    }

    public static List<VirtualFile> convertToFiles(Collection<? extends SimpleClasspathElement> cpeList) {
        VirtualFileManager fileManager = VirtualFileManager.getInstance();
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        for (SimpleClasspathElement simpleClasspathElement : cpeList) {
            for (String fileUrl : simpleClasspathElement.getClassesRootUrls()) {
                VirtualFile file2 = fileManager.findFileByUrl(fileUrl);
                if (file2 == null) continue;
                files2.add(file2);
            }
        }
        return files2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "library";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/ui/classpath/SimpleClasspathElementFactory";
        objectArray[2] = "createElements";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

