/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.RegExpFileType;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpClosure;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.RegExpQuantifier;
import org.jetbrains.annotations.NotNull;

class SimplifyQuantifierAction
implements IntentionAction {
    private final RegExpQuantifier myQuantifier;
    private final String myReplacement;

    SimplifyQuantifierAction(RegExpQuantifier quantifier, String s) {
        this.myQuantifier = quantifier;
        this.myReplacement = s;
    }

    @NotNull
    public String getText() {
        String string = this.myReplacement == null ? CommonQuickFixBundle.message((String)"fix.remove", (Object[])new Object[]{"{1,1}"}) : CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myReplacement});
        if (string == null) {
            SimplifyQuantifierAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = RegExpBundle.message("intention.name.simplify.quantifier", new Object[0]);
        if (string == null) {
            SimplifyQuantifierAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            SimplifyQuantifierAction.$$$reportNull$$$0(2);
        }
        return this.myQuantifier.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            SimplifyQuantifierAction.$$$reportNull$$$0(3);
        }
        if (this.myReplacement == null) {
            PsiElement parent = this.myQuantifier.getParent();
            if (!(parent instanceof RegExpClosure)) {
                return;
            }
            RegExpClosure closure = (RegExpClosure)parent;
            RegExpReplacementUtil.replaceInContext(closure, closure.getAtom().getUnescapedText());
        } else {
            PsiFileFactory factory2 = PsiFileFactory.getInstance((Project)project);
            ASTNode modifier = this.myQuantifier.getModifier();
            PsiFile f = factory2.createFileFromText("dummy.regexp", (FileType)RegExpFileType.INSTANCE, (CharSequence)("a" + this.myReplacement + (modifier != null ? modifier.getText() : "")));
            RegExpPattern pattern = (RegExpPattern)PsiTreeUtil.getChildOfType((PsiElement)f, RegExpPattern.class);
            assert (pattern != null);
            RegExpClosure closure = (RegExpClosure)pattern.getBranches()[0].getAtoms()[0];
            this.myQuantifier.replace(closure.getQuantifier());
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/validation/SimplifyQuantifierAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/validation/SimplifyQuantifierAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

