/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.mandatory;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.intellij.util.ReflectionUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import org.jetbrains.io.mandatory.JsonMandatoryException;
import org.jetbrains.io.mandatory.Mandatory;
import org.jetbrains.io.mandatory.RestModel;

public class NullCheckingFactory
implements TypeAdapterFactory {
    public static final NullCheckingFactory INSTANCE = new NullCheckingFactory();

    public <T> TypeAdapter<T> create(Gson gson2, final TypeToken<T> type) {
        if (type.getRawType().getAnnotation(RestModel.class) == null) {
            return null;
        }
        final TypeAdapter defaultAdapter = gson2.getDelegateAdapter((TypeAdapterFactory)this, type);
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value2) throws IOException {
                defaultAdapter.write(out, value2);
            }

            public T read(JsonReader in) throws IOException {
                Object stub = defaultAdapter.read(in);
                if (stub == null) {
                    return null;
                }
                for (Field field : ReflectionUtil.collectFields((Class)type.getRawType())) {
                    if (field.getAnnotation(Mandatory.class) == null) continue;
                    try {
                        field.setAccessible(true);
                        if (field.get(stub) != null) continue;
                        throw new JsonMandatoryException(String.format("Field '%s' is mandatory, but missing in response", field.getName()));
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                return stub;
            }
        };
    }
}

