/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.intellij.facet.impl.DefaultFacetsProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleConfigurationStateImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.module.PyContentEntriesEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class PyContentEntriesModuleConfigurable
extends SearchableConfigurable.Parent.Abstract {
    private final Module myModule;
    private final JPanel myTopPanel = new JPanel(new BorderLayout());
    protected ModifiableRootModel myModifiableModel;
    protected PyContentEntriesEditor myEditor;

    public PyContentEntriesModuleConfigurable(Module module) {
        this.myModule = module;
    }

    public String getDisplayName() {
        return PyBundle.message((String)"configurable.PyContentEntriesModuleConfigurable.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.project.structure";
    }

    public JComponent createComponent() {
        this.createEditor();
        return this.myTopPanel;
    }

    private void createEditor() {
        if (this.myModule == null) {
            return;
        }
        this.myModifiableModel = (ModifiableRootModel)ReadAction.compute(() -> ModuleRootManager.getInstance((Module)this.myModule).getModifiableModel());
        ModuleConfigurationStateImpl moduleConfigurationState = new ModuleConfigurationStateImpl(this.myModule.getProject(), (ModulesProvider)new DefaultModulesProvider(this.myModule.getProject())){

            public ModifiableRootModel getRootModel() {
                return PyContentEntriesModuleConfigurable.this.myModifiableModel;
            }

            public FacetsProvider getFacetsProvider() {
                return DefaultFacetsProvider.INSTANCE;
            }
        };
        this.myEditor = this.createEditor(this.myModule, moduleConfigurationState);
        JComponent component = (JComponent)ReadAction.compute(() -> this.myEditor.createComponent());
        this.myTopPanel.add((Component)component, "Center");
    }

    protected PyContentEntriesEditor createEditor(@NotNull Module module, @NotNull ModuleConfigurationStateImpl state) {
        if (module == null) {
            PyContentEntriesModuleConfigurable.$$$reportNull$$$0(0);
        }
        if (state == null) {
            PyContentEntriesModuleConfigurable.$$$reportNull$$$0(1);
        }
        return new PyContentEntriesEditor(module, (ModuleConfigurationState)state, true, new JpsModuleSourceRootType[]{JavaSourceRootType.SOURCE});
    }

    public boolean isModified() {
        return this.myEditor != null && this.myEditor.isModified();
    }

    public void apply() throws ConfigurationException {
        if (this.myEditor == null) {
            return;
        }
        boolean editorWasModified = this.myEditor.isModified();
        this.myEditor.apply();
        if (editorWasModified) {
            ApplicationManager.getApplication().runWriteAction(() -> this.myModifiableModel.commit());
            this.resetEditor();
        }
    }

    public void reset() {
        if (this.myEditor == null) {
            return;
        }
        if (this.myModifiableModel != null) {
            this.myModifiableModel.dispose();
        }
        this.resetEditor();
    }

    private void resetEditor() {
        this.myEditor.disposeUIResources();
        this.myTopPanel.remove(this.myEditor.getComponent());
        this.createEditor();
    }

    public void disposeUIResources() {
        if (this.myEditor != null) {
            this.myEditor.disposeUIResources();
            this.myTopPanel.remove(this.myEditor.getComponent());
            this.myEditor = null;
        }
        if (this.myModifiableModel != null) {
            this.myModifiableModel.dispose();
            this.myModifiableModel = null;
        }
    }

    protected Configurable[] buildConfigurables() {
        return new Configurable[0];
    }

    @NotNull
    public String getId() {
        return "python.project.structure";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "state";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/configuration/PyContentEntriesModuleConfigurable";
        objectArray[2] = "createEditor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

