/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.jetbrains.rest.psi.RestElement;
import com.jetbrains.rest.validation.RestElementVisitor;
import java.text.StringCharacterIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestTitle
extends RestElement {
    private static final String ourAdornmentSymbols = "=-`:.'\\~^_*+#>";

    public RestTitle(@NotNull ASTNode node) {
        if (node == null) {
            RestTitle.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public String toString() {
        return "RestTitle:" + this.getNode().getElementType().toString();
    }

    @Nullable
    public String getName() {
        String text = this.getNode().getText().trim();
        if (text.length() < 2) {
            return null;
        }
        char adorn = text.charAt(text.length() - 2);
        StringCharacterIterator it = new StringCharacterIterator(text);
        int finish = 0;
        char ch = it.last();
        while (ch != '\uffff') {
            if (ch != adorn) {
                finish = it.getIndex();
                break;
            }
            ch = it.previous();
        }
        int start = 0;
        if (text.charAt(0) == adorn) {
            char ch2 = it.first();
            while (ch2 != '\uffff') {
                if (ch2 != adorn) {
                    start = it.getIndex() + 1;
                    break;
                }
                ch2 = it.next();
            }
        }
        if (finish <= 0 || start < 0) {
            return null;
        }
        return text.substring(start, finish).trim();
    }

    @Nullable
    public String getOverline() {
        String text = this.getNode().getText().trim();
        Pair<Character, Character> adornments = this.getAdornments();
        Character overlineChar = (Character)adornments.getFirst();
        if (overlineChar == null) {
            return null;
        }
        int end = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == overlineChar.charValue()) continue;
            end = i;
            break;
        }
        return text.substring(0, end);
    }

    @Nullable
    public String getUnderline() {
        String text = this.getNode().getText().trim();
        if (text.length() < 2) {
            return null;
        }
        char adorn = text.charAt(text.length() - 1);
        StringCharacterIterator it = new StringCharacterIterator(text);
        int start = 0;
        char ch = it.last();
        while (ch != '\uffff') {
            if (ch != adorn) {
                start = it.getIndex() + 1;
                break;
            }
            ch = it.previous();
        }
        return text.substring(start);
    }

    public Pair<Character, Character> getAdornments() {
        String text = this.getNode().getText().trim();
        if (text.length() < 2) {
            return Pair.empty();
        }
        Character overline = Character.valueOf(text.charAt(0));
        if (text.split("\n").length < 3 || ourAdornmentSymbols.indexOf(overline.charValue()) < 0) {
            overline = null;
        }
        char underline = text.charAt(text.length() - 2);
        return Pair.create((Object)overline, (Object)Character.valueOf(underline));
    }

    @Override
    protected void acceptRestVisitor(RestElementVisitor visitor) {
        visitor.visitTitle(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/rest/psi/RestTitle", "<init>"));
    }
}

