/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.validation;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.rest.RestBundle;
import com.jetbrains.rest.RestFile;
import com.jetbrains.rest.psi.RestReferenceTarget;
import com.jetbrains.rest.validation.RestAnnotator;

public class RestReferenceTargetAnnotator
extends RestAnnotator {
    @Override
    public void visitReferenceTarget(RestReferenceTarget node) {
        RestFile file = (RestFile)node.getContainingFile();
        RestReferenceTarget[] targets = (RestReferenceTarget[])PsiTreeUtil.getChildrenOfType((PsiElement)file, RestReferenceTarget.class);
        String quotedName = node.getReferenceName();
        String name = node.getReferenceName(false);
        if (targets != null) {
            if ("__".equals(name) && !node.hasReference()) {
                this.getHolder().newAnnotation(HighlightSeverity.WARNING, RestBundle.message("ANN.unusable.anonymous.target", new Object[0])).create();
            }
            for (RestReferenceTarget element : targets) {
                if (!element.getReferenceName().equalsIgnoreCase(name) && !element.getReferenceName(false).equalsIgnoreCase(name) && !element.getReferenceName().equalsIgnoreCase(quotedName) && !element.getReferenceName(false).equalsIgnoreCase(quotedName) || ((Object)((Object)element)).equals((Object)node) || "__".equals(name) || "[#]".equals(quotedName) || "[*]".equals(quotedName)) continue;
                this.getHolder().createWarningAnnotation((PsiElement)element, RestBundle.message("ANN.duplicate.target", name));
            }
        }
    }
}

