/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang;

import com.intellij.lang.Language;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.FileContentUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import one.util.streamex.StreamEx;
import org.intellij.plugins.intelliLang.IntelliLangBundle;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionConfigBean;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Configuration
extends SimpleModificationTracker
implements PersistentStateComponent<Element>,
ModificationTracker {
    static final Logger LOG = Logger.getInstance((String)Configuration.class.getName());
    private static final Condition<BaseInjection> LANGUAGE_INJECTION_CONDITION = o -> Language.findLanguageByID((String)o.getInjectedLanguageId()) != null;
    @NonNls
    public static final String COMPONENT_NAME = "LanguageInjectionConfiguration";
    @NonNls
    private static final String INSTRUMENTATION_TYPE_NAME = "INSTRUMENTATION";
    @NonNls
    private static final String LANGUAGE_ANNOTATION_NAME = "LANGUAGE_ANNOTATION";
    @NonNls
    private static final String PATTERN_ANNOTATION_NAME = "PATTERN_ANNOTATION";
    @NonNls
    private static final String SUBST_ANNOTATION_NAME = "SUBST_ANNOTATION";
    @NonNls
    private static final String RESOLVE_REFERENCES = "RESOLVE_REFERENCES";
    @NonNls
    private static final String LOOK_FOR_VAR_ASSIGNMENTS = "LOOK_FOR_VAR_ASSIGNMENTS";
    @NonNls
    private static final String USE_DFA_IF_AVAILABLE = "USE_DFA_IF_AVAILABLE";
    @NonNls
    private static final String INCLUDE_UNCOMPUTABLES_AS_LITERALS = "INCLUDE_UNCOMPUTABLES_AS_LITERALS";
    @NonNls
    private static final String SOURCE_MODIFICATION_ALLOWED = "SOURCE_MODIFICATION_ALLOWED";
    private final Map<String, List<BaseInjection>> myInjections = ConcurrentFactoryMap.createMap(key -> ContainerUtil.createLockFreeCopyOnWriteList());
    private final CachedValue<MultiMap<String, BaseInjection>> myInjectionsById = new CachedValueImpl(() -> {
        MultiMap map = new MultiMap();
        for (BaseInjection injection : this.getAllInjections()) {
            map.putValue((Object)injection.getInjectedLanguageId(), (Object)injection);
        }
        return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{this});
    });

    protected Collection<BaseInjection> getAllInjections() {
        ArrayList<BaseInjection> injections = new ArrayList<BaseInjection>();
        for (List<BaseInjection> list : this.myInjections.values()) {
            injections.addAll(list);
        }
        return injections;
    }

    public AdvancedConfiguration getAdvancedConfiguration() {
        throw new UnsupportedOperationException("getAdvancedConfiguration should not be called");
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            Configuration.$$$reportNull$$$0(0);
        }
        this.myInjections.clear();
        List injectionElements = element.getChildren("injection");
        if (!injectionElements.isEmpty()) {
            THashMap supports = new THashMap();
            for (LanguageInjectionSupport support : InjectorUtils.getActiveInjectionSupports()) {
                supports.put(support.getId(), support);
            }
            for (Element child : injectionElements) {
                String key = child.getAttributeValue("injector-id");
                LanguageInjectionSupport support = (LanguageInjectionSupport)supports.get(key);
                BaseInjection injection = support == null ? new BaseInjection(key) : support.createInjection(child);
                injection.loadState(child);
                InjectionPlace[] places = Configuration.dropKnownInvalidPlaces(injection.getInjectionPlaces());
                if (places == null) continue;
                injection.setInjectionPlaces(places);
                this.myInjections.get(key).add(injection);
            }
        }
        this.importPlaces(this.getDefaultInjections());
    }

    private static InjectionPlace @Nullable [] dropKnownInvalidPlaces(InjectionPlace[] places) {
        Object[] result = places;
        for (InjectionPlace place : places) {
            if (!place.getText().contains("matches(\"[^${}/\\\\]+\")")) continue;
            result = (InjectionPlace[])ArrayUtil.remove((Object[])result, (Object)place);
        }
        return places.length != 0 && result.length == 0 ? null : result;
    }

    private static boolean readBoolean(Element element, String key, boolean defValue) {
        String value = JDOMExternalizerUtil.readField((Element)element, (String)key);
        if (value == null) {
            return defValue;
        }
        return Boolean.parseBoolean(value);
    }

    private static List<BaseInjection> loadDefaultInjections() {
        ArrayList<Configuration> cfgList = new ArrayList<Configuration>();
        THashSet visited = new THashSet();
        for (LanguageInjectionConfigBean configBean : LanguageInjectionSupport.CONFIG_EP_NAME.getExtensionList()) {
            PluginDescriptor descriptor = configBean.getPluginDescriptor();
            ClassLoader loader = descriptor.getPluginClassLoader();
            try {
                Enumeration<URL> enumeration = loader.getResources(configBean.getConfigUrl());
                if (enumeration == null || !enumeration.hasMoreElements()) {
                    LOG.warn(descriptor.getPluginId() + ": " + configBean.getConfigUrl() + " was not found");
                    continue;
                }
                while (enumeration.hasMoreElements()) {
                    URL url = enumeration.nextElement();
                    if (!visited.add(url.getFile())) continue;
                    try {
                        InputStream stream = url.openStream();
                        try {
                            cfgList.add(Configuration.load(stream));
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOG.warn((Throwable)e);
                    }
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        ArrayList<BaseInjection> defaultInjections = new ArrayList<BaseInjection>();
        for (String supportId : InjectorUtils.getActiveInjectionSupportIds()) {
            for (Configuration cfg : cfgList) {
                List<BaseInjection> imported = cfg.getInjections(supportId);
                defaultInjections.addAll(imported);
            }
        }
        return defaultInjections;
    }

    public Element getState() {
        return this.getState(new Element(COMPONENT_NAME));
    }

    protected Element getState(Element element) {
        Comparator comparator = (o1, o2) -> {
            int rc = Comparing.compare((Comparable)((Object)o1.getDisplayName()), (Comparable)((Object)o2.getDisplayName()));
            if (rc != 0) {
                return rc;
            }
            return ContainerUtil.compareLexicographically(Arrays.asList(o1.getInjectionPlaces()), Arrays.asList(o2.getInjectionPlaces()), (o11, o22) -> {
                if (o11.isEnabled() && !o22.isEnabled()) {
                    return -1;
                }
                if (!o11.isEnabled() && o22.isEnabled()) {
                    return 1;
                }
                return Comparing.compare((Comparable)((Object)o11.getElementPattern().toString()), (Comparable)((Object)o22.getElementPattern().toString()));
            });
        };
        for (String key : new TreeSet<String>(this.myInjections.keySet())) {
            HashSet injections = new HashSet(this.myInjections.get(key));
            injections.removeAll(this.getDefaultInjections());
            for (BaseInjection injection : ContainerUtil.sorted(injections, (Comparator)comparator)) {
                element.addContent(injection.getState());
            }
        }
        return element;
    }

    public static Configuration getInstance() {
        return (Configuration)((Object)ServiceManager.getService(Configuration.class));
    }

    public static Configuration getProjectInstance(Project project) {
        return (Configuration)((Object)ServiceManager.getService((Project)project, Configuration.class));
    }

    public List<BaseInjection> getDefaultInjections() {
        return Collections.emptyList();
    }

    public Collection<BaseInjection> getInjectionsByLanguageId(String languageId) {
        return ((MultiMap)this.myInjectionsById.getValue()).get((Object)languageId);
    }

    @Nullable
    public static Configuration load(InputStream is) throws IOException, JDOMException {
        Element state;
        ArrayList<Element> elements = new ArrayList<Element>();
        Element rootElement = JDOMUtil.load((InputStream)is);
        if (rootElement.getName().equals(COMPONENT_NAME)) {
            state = rootElement;
        } else {
            elements.add(rootElement);
            elements.addAll(rootElement.getChildren("component"));
            state = (Element)ContainerUtil.find(elements, element -> "component".equals(element.getName()) && COMPONENT_NAME.equals(element.getAttributeValue("name")));
        }
        if (state != null) {
            Configuration cfg = new Configuration();
            cfg.loadState(state);
            return cfg;
        }
        return null;
    }

    private void importPlaces(List<BaseInjection> injections) {
        Map map = ContainerUtil.classify(injections.iterator(), o -> o.getSupportId());
        ArrayList originalInjections = new ArrayList();
        ArrayList newInjections = new ArrayList();
        for (String supportId : InjectorUtils.getActiveInjectionSupportIds()) {
            Set importingInjections = (Set)map.get(supportId);
            if (importingInjections == null) continue;
            Configuration.importInjections(this.getInjections(supportId), importingInjections, originalInjections, newInjections);
        }
        if (!newInjections.isEmpty()) {
            this.configurationModified();
        }
        this.replaceInjections(newInjections, originalInjections, true);
    }

    static void importInjections(Collection<? extends BaseInjection> existingInjections, Collection<? extends BaseInjection> importingInjections, Collection<? super BaseInjection> originalInjections, Collection<? super BaseInjection> newInjections) {
        MultiValuesMap placeMap = new MultiValuesMap();
        for (BaseInjection baseInjection : existingInjections) {
            for (InjectionPlace place : baseInjection.getInjectionPlaces()) {
                placeMap.put((Object)place, (Object)baseInjection);
            }
        }
        block2: for (BaseInjection baseInjection : importingInjections) {
            Object[] places = baseInjection.getInjectionPlaces();
            if (places.length == 0) {
                if (existingInjections.contains(baseInjection)) continue;
                newInjections.add(baseInjection);
                continue;
            }
            Set matchingInjections = JBIterable.of((Object[])places).flatten(o -> JBIterable.from((Iterable)placeMap.get(o))).toSet();
            if (matchingInjections.isEmpty()) {
                newInjections.add(baseInjection);
                continue;
            }
            BaseInjection existing = null;
            for (BaseInjection injection : matchingInjections) {
                if (injection.equals(baseInjection)) continue block2;
                if (existing != null || !injection.sameLanguageParameters(baseInjection)) continue;
                existing = injection;
            }
            if (existing == null) continue;
            BaseInjection newInjection = existing.copy();
            newInjection.mergeOriginalPlacesFrom(baseInjection, true);
            if (newInjection.equals(existing)) continue;
            originalInjections.add(existing);
            newInjections.add(newInjection);
        }
    }

    private void configurationModified() {
        this.incModificationCount();
    }

    @Nullable
    public BaseInjection findExistingInjection(@NotNull BaseInjection injection) {
        if (injection == null) {
            Configuration.$$$reportNull$$$0(1);
        }
        List<BaseInjection> list = this.getInjections(injection.getSupportId());
        for (BaseInjection cur : list) {
            if (!cur.intersectsWith(injection)) continue;
            return cur;
        }
        return null;
    }

    public boolean setHostInjectionEnabled(PsiLanguageInjectionHost host, Collection<String> languages, boolean enabled) {
        ArrayList<BaseInjection> originalInjections = new ArrayList<BaseInjection>();
        ArrayList<BaseInjection> newInjections = new ArrayList<BaseInjection>();
        for (LanguageInjectionSupport support : InjectorUtils.getActiveInjectionSupports()) {
            for (BaseInjection injection : this.getInjections(support.getId())) {
                if (!languages.contains(injection.getInjectedLanguageId())) continue;
                boolean replace = false;
                ArrayList<InjectionPlace> newPlaces = new ArrayList<InjectionPlace>();
                for (InjectionPlace place : injection.getInjectionPlaces()) {
                    if (place.isEnabled() != enabled && place.getElementPattern() != null && (place.getElementPattern().accepts((Object)host) || place.getElementPattern().accepts((Object)host.getParent()))) {
                        newPlaces.add(place.enabled(enabled));
                        replace = true;
                        continue;
                    }
                    newPlaces.add(place);
                }
                if (!replace) continue;
                originalInjections.add(injection);
                BaseInjection newInjection = injection.copy();
                newInjection.setInjectionPlaces(newPlaces.toArray(InjectionPlace.EMPTY_ARRAY));
                newInjections.add(newInjection);
            }
        }
        if (!originalInjections.isEmpty()) {
            this.replaceInjectionsWithUndo(host.getProject(), host.getContainingFile(), newInjections, originalInjections, Collections.emptyList());
            return true;
        }
        return false;
    }

    protected void setInjections(Collection<? extends BaseInjection> injections) {
        for (BaseInjection baseInjection : injections) {
            this.myInjections.get(baseInjection.getSupportId()).add(baseInjection);
        }
    }

    @NotNull
    public List<BaseInjection> getInjections(String injectorId) {
        List<BaseInjection> list = Collections.unmodifiableList(this.myInjections.get(injectorId));
        if (list == null) {
            Configuration.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public void replaceInjectionsWithUndo(Project project, List<? extends BaseInjection> newInjections, List<? extends BaseInjection> originalInjections, List<? extends PsiElement> psiElementsToRemove) {
        this.replaceInjectionsWithUndo(project, null, newInjections, originalInjections, psiElementsToRemove);
    }

    public void replaceInjectionsWithUndo(Project project, @Nullable PsiFile hostFile, List<? extends BaseInjection> newInjections, List<? extends BaseInjection> originalInjections, List<? extends PsiElement> psiElementsToRemove) {
        Configuration.replaceInjectionsWithUndo(project, hostFile, newInjections, originalInjections, true, psiElementsToRemove, (add, remove) -> {
            this.replaceInjectionsWithUndoInner((List<? extends BaseInjection>)add, (List<? extends BaseInjection>)remove);
            if (ContainerUtil.find((Iterable)add, LANGUAGE_INJECTION_CONDITION) != null || ContainerUtil.find((Iterable)remove, LANGUAGE_INJECTION_CONDITION) != null) {
                FileContentUtil.reparseOpenedFiles();
            }
            return true;
        });
    }

    protected void replaceInjectionsWithUndoInner(List<? extends BaseInjection> add, List<? extends BaseInjection> remove) {
        this.replaceInjections(add, remove, false);
    }

    public static <T> void replaceInjectionsWithUndo(Project project, @Nullable PsiFile hostFile, final T add, final T remove, final boolean global, List<? extends PsiElement> psiElementsToRemove, final PairProcessor<T, T> actualProcessor) {
        Object[] psiFiles = (PsiFile[])((StreamEx)((StreamEx)StreamEx.ofNullable((Object)hostFile).append(psiElementsToRemove.stream().map(e -> e.getContainingFile()))).filter(e -> !(e instanceof PsiCompiledElement))).toArray(PsiFile.class);
        DocumentReference[] documentReferences = (DocumentReference[])ContainerUtil.map2Array((Object[])psiFiles, DocumentReference.class, file -> DocumentReferenceManager.getInstance().create(file.getVirtualFile()));
        BasicUndoableAction action = new BasicUndoableAction(documentReferences){

            public void undo() {
                actualProcessor.process(remove, add);
            }

            public void redo() {
                actualProcessor.process(add, remove);
            }

            public boolean isGlobal() {
                return global;
            }
        };
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])psiFiles).withName(IntelliLangBundle.message("command.name.language.injection.configuration.update", new Object[0])).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).run(() -> Configuration.lambda$replaceInjectionsWithUndo$12(psiElementsToRemove, actualProcessor, add, remove, project, (UndoableAction)action));
    }

    public boolean replaceInjections(List<? extends BaseInjection> newInjections, List<? extends BaseInjection> originalInjections, boolean forceLevel) {
        boolean changed = false;
        for (BaseInjection baseInjection : originalInjections) {
            changed |= this.myInjections.get(baseInjection.getSupportId()).remove(baseInjection);
        }
        for (BaseInjection baseInjection : newInjections) {
            changed |= this.myInjections.get(baseInjection.getSupportId()).add(baseInjection);
        }
        if (changed) {
            this.configurationModified();
        }
        return changed;
    }

    public void withInjections(List<? extends BaseInjection> injections, Runnable runnable) {
        this.replaceInjections(injections, ContainerUtil.emptyList(), true);
        try {
            runnable.run();
        }
        finally {
            this.replaceInjections(ContainerUtil.emptyList(), injections, true);
        }
    }

    private static /* synthetic */ void lambda$replaceInjectionsWithUndo$12(List psiElementsToRemove, PairProcessor actualProcessor, Object add, Object remove, Project project, UndoableAction action) throws RuntimeException {
        for (PsiElement annotation : psiElementsToRemove) {
            if (!annotation.isValid()) continue;
            annotation.delete();
        }
        actualProcessor.process(add, remove);
        UndoManager.getInstance((Project)project).undoableActionPerformed(action);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/Configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/Configuration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjections";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findExistingInjection";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class AdvancedConfiguration {
        @NotNull
        private InstrumentationType myInstrumentationType = InstrumentationType.ASSERT;
        @NotNull
        private String myLanguageAnnotation;
        @NotNull
        private String myPatternAnnotation;
        @NotNull
        private String mySubstAnnotation;
        private boolean myIncludeUncomputablesAsLiterals;
        private DfaOption myDfaOption = DfaOption.RESOLVE;
        private boolean mySourceModificationAllowed;
        private Pair<String, ? extends Set<String>> myLanguageAnnotationPair;
        private Pair<String, ? extends Set<String>> myPatternAnnotationPair;
        private Pair<String, ? extends Set<String>> mySubstAnnotationPair;

        public AdvancedConfiguration() {
            this.setLanguageAnnotation("org.intellij.lang.annotations.Language");
            this.setPatternAnnotation("org.intellij.lang.annotations.Pattern");
            this.setSubstAnnotation("org.intellij.lang.annotations.Subst");
        }

        public String getLanguageAnnotationClass() {
            return this.myLanguageAnnotation;
        }

        public String getPatternAnnotationClass() {
            return this.myPatternAnnotation;
        }

        public String getSubstAnnotationClass() {
            return this.mySubstAnnotation;
        }

        public void setInstrumentationType(@Nullable String type) {
            if (type != null) {
                this.setInstrumentationType(InstrumentationType.valueOf(type));
            }
        }

        public void setInstrumentationType(@NotNull InstrumentationType type) {
            if (type == null) {
                AdvancedConfiguration.$$$reportNull$$$0(0);
            }
            this.myInstrumentationType = type;
        }

        public void setLanguageAnnotation(@Nullable String languageAnnotation) {
            if (languageAnnotation == null) {
                return;
            }
            this.myLanguageAnnotation = languageAnnotation;
            this.myLanguageAnnotationPair = Pair.create((Object)languageAnnotation, Collections.singleton(languageAnnotation));
        }

        public Pair<String, ? extends Set<String>> getLanguageAnnotationPair() {
            return this.myLanguageAnnotationPair;
        }

        public void setPatternAnnotation(@Nullable String patternAnnotation) {
            if (patternAnnotation == null) {
                return;
            }
            this.myPatternAnnotation = patternAnnotation;
            this.myPatternAnnotationPair = Pair.create((Object)patternAnnotation, Collections.singleton(patternAnnotation));
        }

        public Pair<String, ? extends Set<String>> getPatternAnnotationPair() {
            return this.myPatternAnnotationPair;
        }

        public void setSubstAnnotation(@Nullable String substAnnotation) {
            if (substAnnotation == null) {
                return;
            }
            this.mySubstAnnotation = substAnnotation;
            this.mySubstAnnotationPair = Pair.create((Object)substAnnotation, Collections.singleton(substAnnotation));
        }

        public Pair<String, ? extends Set<String>> getSubstAnnotationPair() {
            return this.mySubstAnnotationPair;
        }

        public boolean isIncludeUncomputablesAsLiterals() {
            return this.myIncludeUncomputablesAsLiterals;
        }

        public void setIncludeUncomputablesAsLiterals(boolean flag) {
            this.myIncludeUncomputablesAsLiterals = flag;
        }

        @NotNull
        public DfaOption getDfaOption() {
            DfaOption dfaOption = this.myDfaOption;
            if (dfaOption == null) {
                AdvancedConfiguration.$$$reportNull$$$0(1);
            }
            return dfaOption;
        }

        public void setDfaOption(@NotNull DfaOption dfaOption) {
            if (dfaOption == null) {
                AdvancedConfiguration.$$$reportNull$$$0(2);
            }
            this.myDfaOption = dfaOption;
        }

        public boolean isSourceModificationAllowed() {
            return this.mySourceModificationAllowed;
        }

        public void setSourceModificationAllowed(boolean sourceModificationAllowed) {
            this.mySourceModificationAllowed = sourceModificationAllowed;
        }

        public InstrumentationType getInstrumentation() {
            return this.myInstrumentationType;
        }

        private void writeState(@NotNull Element element) {
            if (element == null) {
                AdvancedConfiguration.$$$reportNull$$$0(3);
            }
            AdvancedConfiguration defaults = new AdvancedConfiguration();
            if (this.myInstrumentationType != defaults.myInstrumentationType) {
                JDOMExternalizerUtil.writeField((Element)element, (String)Configuration.INSTRUMENTATION_TYPE_NAME, (String)this.myInstrumentationType.toString());
            }
            JDOMExternalizerUtil.writeField((Element)element, (String)Configuration.LANGUAGE_ANNOTATION_NAME, (String)this.myLanguageAnnotation, (String)defaults.myLanguageAnnotation);
            JDOMExternalizerUtil.writeField((Element)element, (String)Configuration.PATTERN_ANNOTATION_NAME, (String)this.myPatternAnnotation, (String)defaults.myPatternAnnotation);
            JDOMExternalizerUtil.writeField((Element)element, (String)Configuration.SUBST_ANNOTATION_NAME, (String)this.mySubstAnnotation, (String)defaults.mySubstAnnotation);
            if (this.myIncludeUncomputablesAsLiterals) {
                JDOMExternalizerUtil.writeField((Element)element, (String)Configuration.INCLUDE_UNCOMPUTABLES_AS_LITERALS, (String)"true");
            }
            if (this.mySourceModificationAllowed) {
                JDOMExternalizerUtil.writeField((Element)element, (String)Configuration.SOURCE_MODIFICATION_ALLOWED, (String)"true");
            }
            if (this.myDfaOption != DfaOption.RESOLVE) {
                switch (this.myDfaOption) {
                    case OFF: {
                        break;
                    }
                    case ASSIGNMENTS: {
                        JDOMExternalizerUtil.writeField((Element)element, (String)Configuration.LOOK_FOR_VAR_ASSIGNMENTS, (String)Boolean.TRUE.toString());
                        break;
                    }
                    case DFA: {
                        JDOMExternalizerUtil.writeField((Element)element, (String)Configuration.USE_DFA_IF_AVAILABLE, (String)Boolean.TRUE.toString());
                    }
                }
            }
        }

        private void loadState(Element element) {
            this.setInstrumentationType(JDOMExternalizerUtil.readField((Element)element, (String)Configuration.INSTRUMENTATION_TYPE_NAME));
            this.setLanguageAnnotation(JDOMExternalizerUtil.readField((Element)element, (String)Configuration.LANGUAGE_ANNOTATION_NAME));
            this.setPatternAnnotation(JDOMExternalizerUtil.readField((Element)element, (String)Configuration.PATTERN_ANNOTATION_NAME));
            this.setSubstAnnotation(JDOMExternalizerUtil.readField((Element)element, (String)Configuration.SUBST_ANNOTATION_NAME));
            if (Configuration.readBoolean(element, Configuration.RESOLVE_REFERENCES, true)) {
                this.setDfaOption(DfaOption.RESOLVE);
            }
            if (Configuration.readBoolean(element, Configuration.LOOK_FOR_VAR_ASSIGNMENTS, false)) {
                this.setDfaOption(DfaOption.ASSIGNMENTS);
            }
            if (Configuration.readBoolean(element, Configuration.USE_DFA_IF_AVAILABLE, false)) {
                this.setDfaOption(DfaOption.DFA);
            }
            this.setIncludeUncomputablesAsLiterals(Configuration.readBoolean(element, Configuration.INCLUDE_UNCOMPUTABLES_AS_LITERALS, false));
            this.setSourceModificationAllowed(Configuration.readBoolean(element, Configuration.SOURCE_MODIFICATION_ALLOWED, false));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/intelliLang/Configuration$AdvancedConfiguration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dfaOption";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/intelliLang/Configuration$AdvancedConfiguration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDfaOption";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setInstrumentationType";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setDfaOption";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "writeState";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum DfaOption {
        OFF,
        RESOLVE,
        ASSIGNMENTS,
        DFA;

    }

    public static enum InstrumentationType {
        NONE,
        ASSERT,
        EXCEPTION;

    }

    @State(name="LanguageInjectionConfiguration", defaultStateAsResource=true, storages={@Storage(value="IntelliLang.xml")})
    public static class Prj
    extends Configuration {
        private final Configuration myParentConfiguration = Configuration.getInstance();

        Prj() {
        }

        @Override
        public AdvancedConfiguration getAdvancedConfiguration() {
            return this.myParentConfiguration.getAdvancedConfiguration();
        }

        @Override
        public List<BaseInjection> getDefaultInjections() {
            return this.myParentConfiguration.getDefaultInjections();
        }

        @Override
        protected Collection<BaseInjection> getAllInjections() {
            Collection<BaseInjection> injections = super.getAllInjections();
            injections.addAll(this.myParentConfiguration.getAllInjections());
            return injections;
        }

        @Override
        @NotNull
        public List<BaseInjection> getInjections(String injectorId) {
            List list = ContainerUtil.concat(this.myParentConfiguration.getInjections(injectorId), this.getOwnInjections(injectorId));
            if (list == null) {
                Prj.$$$reportNull$$$0(0);
            }
            return list;
        }

        public Configuration getParentConfiguration() {
            return this.myParentConfiguration;
        }

        public List<BaseInjection> getOwnInjections(String injectorId) {
            return super.getInjections(injectorId);
        }

        public long getModificationCount() {
            return super.getModificationCount() + this.myParentConfiguration.getModificationCount();
        }

        @Override
        public boolean replaceInjections(List<? extends BaseInjection> newInjections, List<? extends BaseInjection> originalInjections, boolean forceLevel) {
            if (!forceLevel && !originalInjections.isEmpty() && this.myParentConfiguration.replaceInjections(Collections.emptyList(), originalInjections, false)) {
                this.myParentConfiguration.replaceInjections(newInjections, Collections.emptyList(), false);
                return true;
            }
            return super.replaceInjections(newInjections, originalInjections, forceLevel);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/Configuration$Prj", "getInjections"));
        }
    }

    @State(name="LanguageInjectionConfiguration", defaultStateAsResource=true, storages={@Storage(value="IntelliLang.xml")})
    public static class App
    extends Configuration {
        private final List<BaseInjection> myDefaultInjections = Configuration.access$000();
        private final AdvancedConfiguration myAdvancedConfiguration = new AdvancedConfiguration();

        App() {
            LanguageInjectionSupport.CONFIG_EP_NAME.addChangeListener(this::reloadInjections, null);
            LanguageInjectionSupport.EP_NAME.addChangeListener(this::reloadInjections, null);
        }

        private void reloadInjections() {
            this.myDefaultInjections.clear();
            this.myDefaultInjections.addAll(Configuration.loadDefaultInjections());
        }

        @Override
        public List<BaseInjection> getDefaultInjections() {
            return this.myDefaultInjections;
        }

        @Override
        public AdvancedConfiguration getAdvancedConfiguration() {
            return this.myAdvancedConfiguration;
        }

        @Override
        public void loadState(@NotNull Element element) {
            if (element == null) {
                App.$$$reportNull$$$0(0);
            }
            this.myAdvancedConfiguration.loadState(element);
            super.loadState(element);
        }

        @Override
        public Element getState() {
            Element element = new Element(Configuration.COMPONENT_NAME);
            this.myAdvancedConfiguration.writeState(element);
            return this.getState(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/intelliLang/Configuration$App", "loadState"));
        }
    }
}

