/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.compiler.PatternCompiler;
import com.intellij.patterns.compiler.PatternCompilerImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.intellij.plugins.intelliLang.inject.config.ui.AbstractInjectionPanel;
import org.intellij.plugins.intelliLang.inject.config.ui.AdvancedPanel;
import org.intellij.plugins.intelliLang.inject.config.ui.LanguagePanel;

public class BaseInjectionPanel
extends AbstractInjectionPanel<BaseInjection> {
    LanguagePanel myLanguagePanel;
    JPanel myCenterPanel;
    EditorTextField myTextArea;
    AdvancedPanel myAdvancedPanel;
    private JPanel myRoot;
    private JTextField myNameTextField;
    private final PatternCompiler<PsiElement> myHelper;

    public BaseInjectionPanel(BaseInjection injection, Project project) {
        super(injection, project);
        this.$$$setupUI$$$();
        this.myHelper = injection.getCompiler();
        FileType groovy = FileTypeManager.getInstance().getFileTypeByExtension("groovy");
        LanguageFileType realFileType = groovy == UnknownFileType.INSTANCE ? FileTypes.PLAIN_TEXT : groovy;
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("injection." + realFileType.getDefaultExtension(), (FileType)realFileType, (CharSequence)"", 0L, true);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        psiFile.putUserData(BaseInjection.INJECTION_KEY, (Object)injection);
        this.myTextArea = new EditorTextField(document, project, (FileType)realFileType){

            protected EditorEx createEditor() {
                EditorEx ex = super.createEditor();
                ex.setVerticalScrollbarVisible(true);
                ex.setHorizontalScrollbarVisible(true);
                return ex;
            }

            protected boolean isOneLineMode() {
                return false;
            }
        };
        this.myCenterPanel.add((Component)this.myTextArea, "Center");
        this.myTextArea.setFontInheritedFromLAF(false);
        this.init(injection.copy());
    }

    @Override
    protected void apply(BaseInjection other) {
        String displayName = this.myNameTextField.getText();
        if (StringUtil.isEmpty((String)displayName)) {
            throw new IllegalArgumentException("Display name should not be empty");
        }
        other.setDisplayName(displayName);
        boolean enabled = true;
        StringBuilder sb = new StringBuilder();
        ArrayList<InjectionPlace> places = new ArrayList<InjectionPlace>();
        for (String s : this.myTextArea.getText().split("\\s*\n\\s*")) {
            boolean nextEnabled;
            if (s.startsWith("+")) {
                nextEnabled = true;
                s = s.substring(1).trim();
            } else if (s.startsWith("-")) {
                nextEnabled = false;
                s = s.substring(1).trim();
            } else {
                sb.append(s.trim());
                continue;
            }
            if (sb.length() > 0) {
                String text = sb.toString();
                places.add(new InjectionPlace((ElementPattern<? extends PsiElement>)this.myHelper.compileElementPattern(text), enabled));
                sb.setLength(0);
            }
            sb.append(s);
            enabled = nextEnabled;
        }
        if (sb.length() > 0) {
            String text = sb.toString();
            places.add(new InjectionPlace((ElementPattern<? extends PsiElement>)this.myHelper.compileElementPattern(text), enabled));
        }
        for (InjectionPlace place : places) {
            ElementPattern<? extends PsiElement> pattern = place.getElementPattern();
            if (!(pattern instanceof PatternCompilerImpl.LazyPresentablePattern)) continue;
            try {
                ((PatternCompilerImpl.LazyPresentablePattern)pattern).compile();
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Pattern failed to compile:", ex);
            }
        }
        other.setInjectionPlaces(places.toArray(InjectionPlace.EMPTY_ARRAY));
    }

    @Override
    protected void resetImpl() {
        StringBuilder sb = new StringBuilder();
        for (InjectionPlace place : this.myOrigInjection.getInjectionPlaces()) {
            sb.append(place.isEnabled() ? "+ " : "- ").append(place.getText()).append("\n");
        }
        this.myTextArea.setText(sb.toString());
        this.myNameTextField.setText(this.myOrigInjection.getDisplayName());
    }

    @Override
    public JPanel getComponent() {
        return this.myRoot;
    }

    private void createUIComponents() {
        this.myLanguagePanel = new LanguagePanel(this.myProject, this.myOrigInjection);
        this.myAdvancedPanel = new AdvancedPanel(this.myProject, this.myOrigInjection);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRoot = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        LanguagePanel languagePanel = this.myLanguagePanel;
        JComponent jComponent = languagePanel.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myCenterPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Places Patterns", (int)0, (int)0, null, null));
        AdvancedPanel advancedPanel = this.myAdvancedPanel;
        JComponent jComponent2 = advancedPanel.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent2, new GridConstraints(3, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Name:");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameTextField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }
}

