/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u000fH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/completion/ml/MLFeaturesUtil;", "", "()V", "CLASS_NAMES_CACHE", "Lcom/google/common/cache/Cache;", "", "Lcom/intellij/completion/ml/MLFeaturesUtil$ClassNames;", "THIRD_PARTY_NAME", "getClassNameSafe", "feature", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue$ClassNameValue;", "valueAsString", "featureValue", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "getNames", "Ljava/lang/Class;", "ClassNames", "intellij.statsCollector"})
public final class MLFeaturesUtil {
    private static final ClassNames THIRD_PARTY_NAME;
    private static final Cache<String, ClassNames> CLASS_NAMES_CACHE;
    public static final MLFeaturesUtil INSTANCE;

    @NotNull
    public final String valueAsString(@NotNull MLFeatureValue featureValue) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)featureValue, (String)"featureValue");
        MLFeatureValue mLFeatureValue = featureValue;
        if (mLFeatureValue instanceof MLFeatureValue.BinaryValue) {
            string = ((MLFeatureValue.BinaryValue)featureValue).getValue().booleanValue() ? "1" : "0";
        } else if (mLFeatureValue instanceof MLFeatureValue.FloatValue) {
            string = String.valueOf(((MLFeatureValue.FloatValue)featureValue).getValue());
        } else if (mLFeatureValue instanceof MLFeatureValue.CategoricalValue) {
            string = ((MLFeatureValue.CategoricalValue)featureValue).getValue();
        } else if (mLFeatureValue instanceof MLFeatureValue.ClassNameValue) {
            string = this.getClassNameSafe((MLFeatureValue.ClassNameValue)featureValue);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final ClassNames getNames(@NotNull Class<?> $this$getNames) {
        String string = $this$getNames.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"simpleName");
        String string2 = $this$getNames.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
        return new ClassNames(string, string2);
    }

    private final String getClassNameSafe(MLFeatureValue.ClassNameValue feature) {
        Class clazz = feature.getValue();
        ClassNames names2 = (ClassNames)CLASS_NAMES_CACHE.get((Object)clazz.getName(), (Callable)new Callable<ClassNames>(clazz){
            final /* synthetic */ Class $clazz;

            public final ClassNames call() {
                return PluginInfoDetectorKt.getPluginInfo((Class)this.$clazz).isSafeToReport() ? MLFeaturesUtil.access$getNames(MLFeaturesUtil.INSTANCE, this.$clazz) : MLFeaturesUtil.access$getTHIRD_PARTY_NAME$p(MLFeaturesUtil.INSTANCE);
            }
            {
                this.$clazz = clazz;
            }
        });
        return feature.getUseSimpleName() ? names2.getSimpleName() : names2.getFullName();
    }

    private MLFeaturesUtil() {
    }

    static {
        MLFeaturesUtil mLFeaturesUtil;
        INSTANCE = mLFeaturesUtil = new MLFeaturesUtil();
        THIRD_PARTY_NAME = new ClassNames("third.party", "third.party");
        Cache cache = CacheBuilder.newBuilder().maximumSize(100L).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)cache, (String)"CacheBuilder\n    .newBui\u2026mumSize(100)\n    .build()");
        CLASS_NAMES_CACHE = cache;
    }

    public static final /* synthetic */ ClassNames access$getNames(MLFeaturesUtil $this, Class $this$access_u24getNames) {
        return $this.getNames($this$access_u24getNames);
    }

    public static final /* synthetic */ ClassNames access$getTHIRD_PARTY_NAME$p(MLFeaturesUtil $this) {
        MLFeaturesUtil mLFeaturesUtil = $this;
        return THIRD_PARTY_NAME;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/completion/ml/MLFeaturesUtil$ClassNames;", "", "simpleName", "", "fullName", "(Ljava/lang/String;Ljava/lang/String;)V", "getFullName", "()Ljava/lang/String;", "getSimpleName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.statsCollector"})
    private static final class ClassNames {
        @NotNull
        private final String simpleName;
        @NotNull
        private final String fullName;

        @NotNull
        public final String getSimpleName() {
            return this.simpleName;
        }

        @NotNull
        public final String getFullName() {
            return this.fullName;
        }

        public ClassNames(@NotNull String simpleName, @NotNull String fullName) {
            Intrinsics.checkParameterIsNotNull((Object)simpleName, (String)"simpleName");
            Intrinsics.checkParameterIsNotNull((Object)fullName, (String)"fullName");
            this.simpleName = simpleName;
            this.fullName = fullName;
        }

        @NotNull
        public final String component1() {
            return this.simpleName;
        }

        @NotNull
        public final String component2() {
            return this.fullName;
        }

        @NotNull
        public final ClassNames copy(@NotNull String simpleName, @NotNull String fullName) {
            Intrinsics.checkParameterIsNotNull((Object)simpleName, (String)"simpleName");
            Intrinsics.checkParameterIsNotNull((Object)fullName, (String)"fullName");
            return new ClassNames(simpleName, fullName);
        }

        public static /* synthetic */ ClassNames copy$default(ClassNames classNames, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = classNames.simpleName;
            }
            if ((n & 2) != 0) {
                string2 = classNames.fullName;
            }
            return classNames.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ClassNames(simpleName=" + this.simpleName + ", fullName=" + this.fullName + ")";
        }

        public int hashCode() {
            String string = this.simpleName;
            String string2 = this.fullName;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ClassNames)) break block3;
                    ClassNames classNames = (ClassNames)object;
                    if (!Intrinsics.areEqual((Object)this.simpleName, (Object)classNames.simpleName) || !Intrinsics.areEqual((Object)this.fullName, (Object)classNames.fullName)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

