/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.sender;

import com.intellij.stats.sender.DailyLimitSendingWatcher;
import java.text.SimpleDateFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003J\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/stats/sender/DailyLimitSendingWatcher;", "", "dailyLimit", "", "info", "Lcom/intellij/stats/sender/DailyLimitSendingWatcher$SentDataInfo;", "(ILcom/intellij/stats/sender/DailyLimitSendingWatcher$SentDataInfo;)V", "dataSent", "", "size", "isLimitReached", "", "SentDataInfo", "intellij.statsCollector"})
public final class DailyLimitSendingWatcher {
    private final int dailyLimit;
    private final SentDataInfo info;

    public final boolean isLimitReached() {
        return this.info.sentToday(System.currentTimeMillis()) >= this.dailyLimit;
    }

    public final void dataSent(int size) {
        this.info.dataSent(System.currentTimeMillis(), size);
    }

    public DailyLimitSendingWatcher(int dailyLimit, @NotNull SentDataInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        this.dailyLimit = dailyLimit;
        this.info = info;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\nJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0004R\u0018\u0010\u0003\u001a\u00020\u0004X\u00a4\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00020\nX\u00a4\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/stats/sender/DailyLimitSendingWatcher$SentDataInfo;", "", "()V", "latestSendingTimestamp", "", "getLatestSendingTimestamp", "()J", "setLatestSendingTimestamp", "(J)V", "sentCount", "", "getSentCount", "()I", "setSentCount", "(I)V", "dataSent", "", "timestamp", "bytesCount", "isSameDay", "", "ts1", "ts2", "sentToday", "Companion", "DumbInfo", "intellij.statsCollector"})
    public static abstract class SentDataInfo {
        private static final SimpleDateFormat FORMAT;
        public static final Companion Companion;

        public final int sentToday(long timestamp) {
            if (!this.isSameDay(timestamp, this.getLatestSendingTimestamp())) {
                return 0;
            }
            return this.getSentCount();
        }

        public final void dataSent(long timestamp, int bytesCount) {
            this.setSentCount(this.sentToday(timestamp) + bytesCount);
            this.setLatestSendingTimestamp(timestamp);
        }

        private final boolean isSameDay(long ts1, long ts2) {
            isSameDay.1 $fun$asString$1 = isSameDay.1.INSTANCE;
            return Intrinsics.areEqual((Object)$fun$asString$1.invoke(ts1), (Object)$fun$asString$1.invoke(ts2));
        }

        protected abstract int getSentCount();

        protected abstract void setSentCount(int var1);

        protected abstract long getLatestSendingTimestamp();

        protected abstract void setLatestSendingTimestamp(long var1);

        static {
            Companion = new Companion(null);
            FORMAT = new SimpleDateFormat("yyyyMMdd");
        }

        public static final /* synthetic */ SimpleDateFormat access$getFORMAT$cp() {
            return FORMAT;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/stats/sender/DailyLimitSendingWatcher$SentDataInfo$DumbInfo;", "Lcom/intellij/stats/sender/DailyLimitSendingWatcher$SentDataInfo;", "()V", "latestSendingTimestamp", "", "getLatestSendingTimestamp", "()J", "setLatestSendingTimestamp", "(J)V", "sentCount", "", "getSentCount", "()I", "setSentCount", "(I)V", "intellij.statsCollector"})
        public static final class DumbInfo
        extends SentDataInfo {
            private int sentCount;
            private long latestSendingTimestamp;

            @Override
            protected int getSentCount() {
                return this.sentCount;
            }

            @Override
            protected void setSentCount(int n) {
                this.sentCount = n;
            }

            @Override
            protected long getLatestSendingTimestamp() {
                return this.latestSendingTimestamp;
            }

            @Override
            protected void setLatestSendingTimestamp(long l) {
                this.latestSendingTimestamp = l;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/stats/sender/DailyLimitSendingWatcher$SentDataInfo$Companion;", "", "()V", "FORMAT", "Ljava/text/SimpleDateFormat;", "intellij.statsCollector"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

