/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.beans;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupContextData;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.EnumValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.ValidationSimpleRuleFactory;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventGroupRules {
    public static final EventGroupRules EMPTY = new EventGroupRules(Collections.emptySet(), Collections.emptyMap(), EventGroupContextData.EMPTY);
    private final FUSRule[] eventIdRules;
    private final Map<String, FUSRule[]> eventDataRules;

    private EventGroupRules(@Nullable Set<String> eventIdRules, @Nullable Map<String, Set<String>> eventDataRules, @NotNull EventGroupContextData contextData) {
        if (contextData == null) {
            EventGroupRules.$$$reportNull$$$0(0);
        }
        this.eventDataRules = new ConcurrentHashMap<String, FUSRule[]>();
        this.eventIdRules = EventGroupRules.getRules(eventIdRules, contextData);
        if (eventDataRules != null) {
            for (Map.Entry<String, Set<String>> entry : eventDataRules.entrySet()) {
                if (FeatureUsageData.Companion.getPlatformDataKeys().contains(entry.getKey())) {
                    this.eventDataRules.put(entry.getKey(), new FUSRule[]{FUSRule.TRUE});
                    continue;
                }
                this.eventDataRules.put(entry.getKey(), EventGroupRules.getRules(entry.getValue(), contextData));
            }
        }
    }

    public FUSRule[] getEventIdRules() {
        return this.eventIdRules;
    }

    public Map<String, FUSRule[]> getEventDataRules() {
        return this.eventDataRules;
    }

    private static FUSRule @NotNull [] getRules(@Nullable Set<String> rules, @NotNull EventGroupContextData contextData) {
        if (contextData == null) {
            EventGroupRules.$$$reportNull$$$0(1);
        }
        if (rules == null) {
            if (FUSRule.EMPTY_ARRAY == null) {
                EventGroupRules.$$$reportNull$$$0(2);
            }
            return FUSRule.EMPTY_ARRAY;
        }
        SortedList fusRules = new SortedList(EventGroupRules.getRulesComparator());
        for (String rule : rules) {
            ContainerUtil.addIfNotNull((Collection)fusRules, (Object)ValidationSimpleRuleFactory.createRule(rule, contextData));
        }
        FUSRule[] fUSRuleArray = fusRules.toArray(FUSRule.EMPTY_ARRAY);
        if (fUSRuleArray == null) {
            EventGroupRules.$$$reportNull$$$0(3);
        }
        return fUSRuleArray;
    }

    @NotNull
    private static Comparator<FUSRule> getRulesComparator() {
        Comparator comparator = (o1, o2) -> {
            if (o1 instanceof EnumValidationRule) {
                return o2 instanceof EnumValidationRule ? -1 : 0;
            }
            return o2 instanceof EnumValidationRule ? 0 : 1;
        };
        if (comparator == null) {
            EventGroupRules.$$$reportNull$$$0(4);
        }
        return comparator;
    }

    public boolean areEventIdRulesDefined() {
        return this.eventIdRules.length > 0;
    }

    public boolean areEventDataRulesDefined() {
        return this.eventDataRules.size() > 0;
    }

    public ValidationResultType validateEventId(@NotNull EventContext context) {
        if (context == null) {
            EventGroupRules.$$$reportNull$$$0(5);
        }
        ValidationResultType prevResult = null;
        for (FUSRule rule : this.eventIdRules) {
            ValidationResultType resultType = rule.validate(context.eventId, context);
            if (resultType.isFinal()) {
                return resultType;
            }
            prevResult = resultType;
        }
        return prevResult != null ? prevResult : ValidationResultType.REJECTED;
    }

    public Object validateEventData(@NotNull String key, @Nullable Object data, @NotNull EventContext context) {
        if (key == null) {
            EventGroupRules.$$$reportNull$$$0(6);
        }
        if (context == null) {
            EventGroupRules.$$$reportNull$$$0(7);
        }
        if (FeatureUsageData.Companion.getPlatformDataKeys().contains(key)) {
            return data;
        }
        if (data == null) {
            return ValidationResultType.REJECTED.getDescription();
        }
        if (data instanceof Map) {
            HashMap validatedData = new HashMap();
            for (Map.Entry entry : ((Map)data).entrySet()) {
                Object entryKey = entry.getKey();
                if (entryKey instanceof String) {
                    validatedData.put(entryKey, this.validateEventData(key + "." + entryKey, entry.getValue(), context));
                    continue;
                }
                validatedData.put(entryKey, ValidationResultType.REJECTED.getDescription());
            }
            return validatedData;
        }
        if (data instanceof List) {
            return ContainerUtil.map((Collection)((List)data), value -> this.validateEventData(key, value, context));
        }
        FUSRule[] rules = this.eventDataRules.get(key);
        if (rules == null || rules.length == 0) {
            return ValidationResultType.UNDEFINED_RULE.getDescription();
        }
        return EventGroupRules.validateValue(data, context, rules);
    }

    private static Object validateValue(@NotNull Object data, @NotNull EventContext context, FUSRule @NotNull [] rules) {
        ValidationResultType resultType;
        if (data == null) {
            EventGroupRules.$$$reportNull$$$0(8);
        }
        if (context == null) {
            EventGroupRules.$$$reportNull$$$0(9);
        }
        if (rules == null) {
            EventGroupRules.$$$reportNull$$$0(10);
        }
        return (resultType = EventGroupRules.acceptRule(data.toString(), context, rules)) == ValidationResultType.ACCEPTED ? data : resultType.getDescription();
    }

    private static ValidationResultType acceptRule(@NotNull String ruleData, @NotNull EventContext context, FUSRule ... rules) {
        if (ruleData == null) {
            EventGroupRules.$$$reportNull$$$0(11);
        }
        if (context == null) {
            EventGroupRules.$$$reportNull$$$0(12);
        }
        if (rules == null) {
            return ValidationResultType.UNDEFINED_RULE;
        }
        ValidationResultType prevResult = null;
        for (FUSRule rule : rules) {
            ValidationResultType resultType = rule.validate(ruleData, context);
            if (resultType.isFinal()) {
                return resultType;
            }
            prevResult = resultType;
        }
        return prevResult != null ? prevResult : ValidationResultType.REJECTED;
    }

    @NotNull
    public static EventGroupRules create(@NotNull FUStatisticsWhiteListGroupsService.WLGroup group, @Nullable Map<String, Set<String>> globalEnums, @Nullable Map<String, String> globalRegexps) {
        FUStatisticsWhiteListGroupsService.WLRule rules;
        if (group == null) {
            EventGroupRules.$$$reportNull$$$0(13);
        }
        return (rules = group.rules) == null ? EMPTY : new EventGroupRules(rules.event_id, rules.event_data, EventGroupContextData.create(rules.enums, globalEnums, rules.regexps, globalRegexps));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextData";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/rules/beans/EventGroupRules";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ruleData";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/rules/beans/EventGroupRules";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRules";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRulesComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRules";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateEventId";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "validateEventData";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "validateValue";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "acceptRule";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

