/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionResult {
    private final LookupElement myLookupElement;
    private final PrefixMatcher myMatcher;
    private final CompletionSorter mySorter;

    protected CompletionResult(LookupElement lookupElement, PrefixMatcher matcher, CompletionSorter sorter) {
        this.myLookupElement = lookupElement;
        this.myMatcher = matcher;
        this.mySorter = sorter;
    }

    @Nullable
    public static CompletionResult wrap(@NotNull LookupElement lookupElement, @NotNull PrefixMatcher matcher, @NotNull CompletionSorter sorter) {
        if (lookupElement == null) {
            CompletionResult.$$$reportNull$$$0(0);
        }
        if (matcher == null) {
            CompletionResult.$$$reportNull$$$0(1);
        }
        if (sorter == null) {
            CompletionResult.$$$reportNull$$$0(2);
        }
        if (matcher.prefixMatches(lookupElement)) {
            return new CompletionResult(lookupElement, matcher, sorter);
        }
        return null;
    }

    public PrefixMatcher getPrefixMatcher() {
        return this.myMatcher;
    }

    public CompletionSorter getSorter() {
        return this.mySorter;
    }

    public LookupElement getLookupElement() {
        return this.myLookupElement;
    }

    @NotNull
    public CompletionResult withLookupElement(@NotNull LookupElement element) {
        if (element == null) {
            CompletionResult.$$$reportNull$$$0(3);
        }
        if (!this.myMatcher.prefixMatches(element)) {
            throw new AssertionError((Object)"The new element doesn't match the prefix");
        }
        return new CompletionResult(element, this.myMatcher, this.mySorter);
    }

    public boolean isStartMatch() {
        return this.myMatcher.isStartMatch(this.myLookupElement);
    }

    public String toString() {
        return this.myLookupElement.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sorter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/CompletionResult";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "wrap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "withLookupElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

