/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LineRange {
    private static final Logger LOG = Logger.getInstance(LineRange.class);
    public final int startLine;
    public final int endLine;
    public PsiElement firstElement;
    public PsiElement lastElement;

    public LineRange(int startLine, int endLine) {
        this.startLine = startLine;
        this.endLine = endLine;
        LOG.assertTrue(startLine >= 0, (Object)"Negative start line");
        if (startLine > endLine) {
            LOG.error("start > end: start=" + startLine + "; end=" + endLine);
        }
    }

    public LineRange(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull Document document) {
        if (startElement == null) {
            LineRange.$$$reportNull$$$0(0);
        }
        if (endElement == null) {
            LineRange.$$$reportNull$$$0(1);
        }
        if (document == null) {
            LineRange.$$$reportNull$$$0(2);
        }
        this(document.getLineNumber(startElement.getTextRange().getStartOffset()), document.getLineNumber(endElement.getTextRange().getEndOffset()) + 1);
    }

    public LineRange(@NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (startElement == null) {
            LineRange.$$$reportNull$$$0(3);
        }
        if (endElement == null) {
            LineRange.$$$reportNull$$$0(4);
        }
        this(startElement, endElement, startElement.getContainingFile().getViewProvider().getDocument());
    }

    public LineRange(@NotNull PsiElement element) {
        if (element == null) {
            LineRange.$$$reportNull$$$0(5);
        }
        this(element, element);
    }

    @NonNls
    public String toString() {
        return "line range: [" + this.startLine + "-" + this.endLine + "]";
    }

    public boolean containsLine(int lineNumber) {
        return this.startLine <= lineNumber && this.endLine > lineNumber;
    }

    public boolean contains(LineRange range) {
        return this.startLine <= range.startLine && this.endLine >= range.endLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "startElement";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "endElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "document";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/editorActions/moveUpDown/LineRange";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

