/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionInGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.ActionStubBase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultActionGroup
extends ActionGroup {
    private static final Logger LOG = Logger.getInstance(DefaultActionGroup.class);
    private static final String CANT_ADD_ITSELF = "Cannot add a group to itself: ";
    private static final String CANT_ADD_ACTION_TWICE = "Cannot add an action twice: ";
    private final List<AnAction> mySortedChildren;
    private final List<Pair<AnAction, Constraints>> myPairs;
    private int myModificationStamp;

    public DefaultActionGroup() {
        this(Presentation.NULL_STRING, false);
    }

    public DefaultActionGroup(AnAction ... actions) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(0);
        }
        this(Arrays.asList(actions));
    }

    public DefaultActionGroup(@NotNull List<? extends AnAction> actions) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(1);
        }
        this(Presentation.NULL_STRING, actions);
    }

    public DefaultActionGroup(@NotNull Supplier<@NlsActions.ActionText String> name, @NotNull List<? extends AnAction> actions) {
        if (name == null) {
            DefaultActionGroup.$$$reportNull$$$0(2);
        }
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(3);
        }
        this(name, false);
        this.addActions(actions);
    }

    public DefaultActionGroup(@Nullable @NlsActions.ActionText String name, @NotNull List<? extends AnAction> actions) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(4);
        }
        this(() -> name, actions);
    }

    public DefaultActionGroup(@Nullable @NlsActions.ActionText String shortName, boolean popup) {
        this(() -> shortName, popup);
    }

    protected DefaultActionGroup(@NotNull Supplier<@NlsActions.ActionText String> shortName, boolean popup) {
        if (shortName == null) {
            DefaultActionGroup.$$$reportNull$$$0(5);
        }
        super(shortName, popup);
        this.mySortedChildren = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myPairs = ContainerUtil.createLockFreeCopyOnWriteList();
    }

    public static DefaultActionGroup createPopupGroup(@NotNull Supplier<@NlsActions.ActionText String> shortName) {
        if (shortName == null) {
            DefaultActionGroup.$$$reportNull$$$0(6);
        }
        return new DefaultActionGroup(shortName, true);
    }

    public static DefaultActionGroup createFlatGroup(@NotNull Supplier<@NlsActions.ActionText String> shortName) {
        if (shortName == null) {
            DefaultActionGroup.$$$reportNull$$$0(7);
        }
        return new DefaultActionGroup(shortName, false);
    }

    public static DefaultActionGroup createPopupGroupWithEmptyText() {
        return DefaultActionGroup.createPopupGroup(() -> "");
    }

    private void incrementModificationStamp() {
        ++this.myModificationStamp;
    }

    public int getModificationStamp() {
        return this.myModificationStamp;
    }

    private void addActions(@NotNull List<? extends AnAction> actions) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(8);
        }
        HashSet<AnAction> actionSet = new HashSet<AnAction>();
        ArrayList<AnAction> uniqueActions = new ArrayList<AnAction>(actions.size());
        for (AnAction anAction : actions) {
            if (anAction == this) {
                throw new IllegalArgumentException(CANT_ADD_ITSELF + anAction);
            }
            if (!(anAction instanceof Separator) && !actionSet.add(anAction)) {
                LOG.error(CANT_ADD_ACTION_TWICE + anAction);
                continue;
            }
            uniqueActions.add(anAction);
        }
        this.mySortedChildren.addAll(uniqueActions);
        this.incrementModificationStamp();
    }

    public final void add(@NotNull AnAction action, @NotNull ActionManager actionManager) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(9);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(10);
        }
        this.add(action, Constraints.LAST, actionManager);
    }

    public final void add(@NotNull AnAction action) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(11);
        }
        this.addAction(action, Constraints.LAST);
    }

    @NotNull
    public final ActionInGroup addAction(@NotNull AnAction action) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(12);
        }
        return this.addAction(action, Constraints.LAST);
    }

    public final void addSeparator() {
        this.add(Separator.create());
    }

    public final void add(@NotNull AnAction action, @NotNull Constraints constraint) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(13);
        }
        if (constraint == null) {
            DefaultActionGroup.$$$reportNull$$$0(14);
        }
        this.add(action, constraint, ActionManager.getInstance());
    }

    @NotNull
    public final ActionInGroup addAction(@NotNull AnAction action, @NotNull Constraints constraint) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(15);
        }
        if (constraint == null) {
            DefaultActionGroup.$$$reportNull$$$0(16);
        }
        return this.addAction(action, constraint, ActionManager.getInstance());
    }

    public final void add(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull ActionManager actionManager) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(17);
        }
        if (constraint == null) {
            DefaultActionGroup.$$$reportNull$$$0(18);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(19);
        }
        this.addAction(action, constraint, actionManager);
    }

    @NotNull
    public final ActionInGroup addAction(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull ActionManager actionManager) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(20);
        }
        if (constraint == null) {
            DefaultActionGroup.$$$reportNull$$$0(21);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(22);
        }
        if (action == this) {
            throw new IllegalArgumentException(CANT_ADD_ITSELF + action);
        }
        if (!(action instanceof Separator) && this.containsAction(action)) {
            LOG.error(CANT_ADD_ACTION_TWICE + action);
            this.remove(action, actionManager.getId(action));
        }
        constraint = (Constraints)constraint.clone();
        if (constraint.myAnchor == Anchor.FIRST) {
            this.mySortedChildren.add(0, action);
        } else if (constraint.myAnchor == Anchor.LAST) {
            this.mySortedChildren.add(action);
        } else {
            this.myPairs.add((Pair<AnAction, Constraints>)Pair.create((Object)action, (Object)constraint));
        }
        this.addAllToSortedList(actionManager);
        this.incrementModificationStamp();
        return new ActionInGroup(this, action);
    }

    private boolean containsAction(@NotNull AnAction action) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(23);
        }
        if (this.mySortedChildren.contains(action)) {
            return true;
        }
        for (Pair<AnAction, Constraints> pair : this.myPairs) {
            if (!action.equals(pair.first)) continue;
            return true;
        }
        return false;
    }

    private void addAllToSortedList(@NotNull ActionManager actionManager) {
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(24);
        }
        block0: while (!this.myPairs.isEmpty()) {
            for (int i = 0; i < this.myPairs.size(); ++i) {
                Pair<AnAction, Constraints> pair = this.myPairs.get(i);
                if (!this.addToSortedList((AnAction)pair.first, (Constraints)pair.second, actionManager)) continue;
                this.myPairs.remove(i);
                continue block0;
            }
        }
    }

    private boolean addToSortedList(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull ActionManager actionManager) {
        int index;
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(25);
        }
        if (constraint == null) {
            DefaultActionGroup.$$$reportNull$$$0(26);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(27);
        }
        if ((index = DefaultActionGroup.findIndex(constraint.myRelativeToActionId, this.mySortedChildren, actionManager)) == -1) {
            return false;
        }
        if (constraint.myAnchor == Anchor.BEFORE) {
            this.mySortedChildren.add(index, action);
        } else {
            this.mySortedChildren.add(index + 1, action);
        }
        return true;
    }

    private static int findIndex(String actionId, @NotNull List<? extends AnAction> actions, @NotNull ActionManager actionManager) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(28);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(29);
        }
        for (int i = 0; i < actions.size(); ++i) {
            String id;
            AnAction action = actions.get(i);
            if (!(action instanceof ActionStub ? ((ActionStub)action).getId().equals(actionId) : (id = actionManager.getId(action)) != null && id.equals(actionId))) continue;
            return i;
        }
        return -1;
    }

    public final void remove(@NotNull AnAction action) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(30);
        }
        this.remove(action, ActionManager.getInstance());
    }

    public final void remove(@NotNull AnAction action, @NotNull ActionManager actionManager) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(31);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(32);
        }
        this.remove(action, actionManager.getId(action));
    }

    public final void remove(@NotNull AnAction action, @Nullable String id) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(33);
        }
        if (!this.mySortedChildren.remove(action) && !this.mySortedChildren.removeIf(oldAction -> oldAction instanceof ActionStubBase && ((ActionStubBase)((Object)oldAction)).getId().equals(id))) {
            for (int i = 0; i < this.myPairs.size(); ++i) {
                Pair<AnAction, Constraints> pair = this.myPairs.get(i);
                if (!((AnAction)pair.first).equals(action) && (!(pair.first instanceof ActionStubBase) || !((ActionStubBase)pair.first).getId().equals(id))) continue;
                this.myPairs.remove(i);
                this.incrementModificationStamp();
                break;
            }
        }
    }

    public final void removeAll() {
        this.mySortedChildren.clear();
        this.myPairs.clear();
        this.incrementModificationStamp();
    }

    public boolean replaceAction(@NotNull AnAction oldAction, @NotNull AnAction newAction) {
        int index;
        if (oldAction == null) {
            DefaultActionGroup.$$$reportNull$$$0(34);
        }
        if (newAction == null) {
            DefaultActionGroup.$$$reportNull$$$0(35);
        }
        if ((index = this.mySortedChildren.indexOf(oldAction)) >= 0) {
            this.mySortedChildren.set(index, newAction);
            this.incrementModificationStamp();
            return true;
        }
        for (int i = 0; i < this.myPairs.size(); ++i) {
            Pair<AnAction, Constraints> pair = this.myPairs.get(i);
            if (!((AnAction)pair.first).equals(newAction)) continue;
            this.myPairs.set(i, (Pair<AnAction, Constraints>)Pair.create((Object)newAction, (Object)((Constraints)pair.second)));
            this.incrementModificationStamp();
            return true;
        }
        return false;
    }

    public void copyFromGroup(@NotNull DefaultActionGroup other) {
        if (other == null) {
            DefaultActionGroup.$$$reportNull$$$0(36);
        }
        this.copyFrom(other);
        this.setPopup(other.isPopup());
        this.mySortedChildren.clear();
        this.mySortedChildren.addAll(other.mySortedChildren);
        this.myPairs.clear();
        this.myPairs.addAll(other.myPairs);
        this.incrementModificationStamp();
    }

    @Override
    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        return this.getChildren(e, e != null ? e.getActionManager() : ActionManager.getInstance());
    }

    @Override
    public final AnAction @NotNull [] getChildren(@Nullable AnActionEvent e, @NotNull ActionManager actionManager) {
        int i;
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(37);
        }
        boolean hasNulls = false;
        int sortedSize = this.mySortedChildren.size();
        Object[] children = new AnAction[sortedSize + this.myPairs.size()];
        for (i = 0; i < sortedSize; ++i) {
            AnAction action = this.mySortedChildren.get(i);
            if (action == null) {
                LOG.error("Empty sorted child: " + this + ", " + this.getClass() + "; index=" + i);
            }
            if (action instanceof ActionStubBase) {
                if ((action = this.unStub(actionManager, (ActionStubBase)((Object)action))) == null) {
                    LOG.error("Can't unstub " + this.mySortedChildren.get(i));
                } else {
                    this.mySortedChildren.set(i, action);
                }
            }
            hasNulls |= action == null;
            children[i] = action;
        }
        for (i = 0; i < this.myPairs.size(); ++i) {
            Pair<AnAction, Constraints> pair = this.myPairs.get(i);
            AnAction action = (AnAction)pair.first;
            if (action == null) {
                LOG.error("Empty pair child: " + this + ", " + this.getClass() + "; index=" + i);
            } else if (action instanceof ActionStubBase) {
                if ((action = this.unStub(actionManager, (ActionStubBase)((Object)action))) == null) {
                    LOG.error("Can't unstub " + pair);
                } else {
                    this.myPairs.set(i, (Pair<AnAction, Constraints>)Pair.create((Object)action, (Object)((Constraints)pair.second)));
                }
            }
            hasNulls |= action == null;
            children[i + sortedSize] = action;
        }
        if (hasNulls) {
            AnAction[] anActionArray = (AnAction[])ContainerUtil.mapNotNull((Object[])children, (Function)FunctionUtil.id(), (Object[])AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                DefaultActionGroup.$$$reportNull$$$0(38);
            }
            return anActionArray;
        }
        if (children == null) {
            DefaultActionGroup.$$$reportNull$$$0(39);
        }
        return children;
    }

    @Nullable
    private AnAction unStub(@NotNull ActionManager actionManager, @NotNull ActionStubBase stub) {
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(40);
        }
        if (stub == null) {
            DefaultActionGroup.$$$reportNull$$$0(41);
        }
        try {
            AnAction action = actionManager.getAction(stub.getId());
            if (action == null) {
                LOG.error("Null child action in group " + this + " of class " + this.getClass() + ", id=" + stub.getId());
                return null;
            }
            this.replace((AnAction)((Object)stub), action);
            return action;
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (Throwable e1) {
            LOG.error(e1);
            return null;
        }
    }

    public final int getChildrenCount() {
        return this.mySortedChildren.size() + this.myPairs.size();
    }

    public final AnAction @NotNull [] getChildActionsOrStubs() {
        int i;
        int sortedSize = this.mySortedChildren.size();
        AnAction[] children = new AnAction[sortedSize + this.myPairs.size()];
        for (i = 0; i < sortedSize; ++i) {
            children[i] = this.mySortedChildren.get(i);
        }
        for (i = 0; i < this.myPairs.size(); ++i) {
            children[i + sortedSize] = (AnAction)this.myPairs.get((int)i).first;
        }
        if (children == null) {
            DefaultActionGroup.$$$reportNull$$$0(42);
        }
        return children;
    }

    public final void addAll(@NotNull ActionGroup group) {
        if (group == null) {
            DefaultActionGroup.$$$reportNull$$$0(43);
        }
        this.addAll(group.getChildren(null));
    }

    public final void addAll(@NotNull Collection<? extends AnAction> actionList) {
        if (actionList == null) {
            DefaultActionGroup.$$$reportNull$$$0(44);
        }
        this.addAll(actionList, ActionManager.getInstance());
    }

    public final void addAll(@NotNull Collection<? extends AnAction> actionList, @NotNull ActionManager actionManager) {
        if (actionList == null) {
            DefaultActionGroup.$$$reportNull$$$0(45);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(46);
        }
        if (actionList.isEmpty()) {
            return;
        }
        for (AnAction anAction : actionList) {
            this.addAction(anAction, Constraints.LAST, actionManager);
        }
    }

    public final void addAll(AnAction ... actions) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(47);
        }
        if (actions.length == 0) {
            return;
        }
        ActionManager actionManager = ActionManager.getInstance();
        for (AnAction action : actions) {
            this.addAction(action, Constraints.LAST, actionManager);
        }
    }

    public void addSeparator(@Nullable @NlsContexts.Separator String separatorText) {
        this.add(Separator.create(separatorText));
    }

    public static DefaultActionGroup createUserDataAwareGroup(final String templateText) {
        return new DefaultActionGroup(){

            @Override
            @Nullable
            public String getTemplateText() {
                return templateText;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 38: 
            case 39: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 38: 
            case 39: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 23: 
            case 25: 
            case 30: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 10: 
            case 19: 
            case 22: 
            case 24: 
            case 27: 
            case 29: 
            case 32: 
            case 37: 
            case 40: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldAction";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newAction";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 38: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/DefaultActionGroup";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/DefaultActionGroup";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildActionsOrStubs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPopupGroup";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFlatGroup";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addActions";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addAction";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "containsAction";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addAllToSortedList";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addToSortedList";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findIndex";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "replaceAction";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "copyFromGroup";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 38: 
            case 39: 
            case 42: {
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "unStub";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 38: 
            case 39: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

