/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.ReflectionUtil;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class CustomCodeStyleSettings
implements Cloneable {
    private CodeStyleSettings myContainer;
    private final String myTagName;
    private static final Logger LOG = Logger.getInstance(CustomCodeStyleSettings.class);

    protected CustomCodeStyleSettings(@NonNls @NotNull String tagName, CodeStyleSettings container) {
        if (tagName == null) {
            CustomCodeStyleSettings.$$$reportNull$$$0(0);
        }
        this.myTagName = tagName;
        this.myContainer = container;
    }

    public final CodeStyleSettings getContainer() {
        return this.myContainer;
    }

    @NonNls
    @NotNull
    public final String getTagName() {
        String string = this.myTagName;
        if (string == null) {
            CustomCodeStyleSettings.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public List<String> getKnownTagNames() {
        List<String> list = Collections.singletonList(this.getTagName());
        if (list == null) {
            CustomCodeStyleSettings.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void readExternal(Element parentElement) throws InvalidDataException {
        Element child = parentElement.getChild(this.myTagName);
        if (child != null) {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)child);
            LOG.info("Loaded " + this.getClass().getName());
        }
    }

    public void writeExternal(Element parentElement, @NotNull CustomCodeStyleSettings parentSettings) throws WriteExternalException {
        if (parentSettings == null) {
            CustomCodeStyleSettings.$$$reportNull$$$0(3);
        }
        Element childElement = new Element(this.myTagName);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)childElement, (DefaultJDOMExternalizer.JDOMFilter)new DifferenceFilter((Object)this, (Object)parentSettings));
        if (!childElement.getContent().isEmpty()) {
            parentElement.addContent(childElement);
        }
    }

    CustomCodeStyleSettings copyWith(@NotNull CodeStyleSettings container) {
        if (container == null) {
            CustomCodeStyleSettings.$$$reportNull$$$0(4);
        }
        CustomCodeStyleSettings cloned = (CustomCodeStyleSettings)this.clone();
        cloned.myContainer = container;
        return cloned;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void importLegacySettings(@NotNull CodeStyleSettings rootSettings) {
        if (rootSettings == null) {
            CustomCodeStyleSettings.$$$reportNull$$$0(5);
        }
    }

    protected void beforeLoading() {
    }

    protected void afterLoaded() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CustomCodeStyleSettings)) {
            return false;
        }
        return ReflectionUtil.comparePublicNonFinalFields((Object)this, (Object)obj);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/CustomCodeStyleSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/CustomCodeStyleSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownTagNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyWith";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "importLegacySettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

