/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Condition;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ListUtil {
    public static final String SELECTED_BY_MOUSE_EVENT = "byMouseEvent";
    private static final ListModelExtension DEFAULT_MODEL = new ListModelExtension<Object, DefaultListModel<Object>>(){

        @Override
        public Object get(DefaultListModel<Object> model, int index) {
            return model.get(index);
        }

        @Override
        public void set(DefaultListModel<Object> model, int index, Object item) {
            model.set(index, item);
        }

        @Override
        public void remove(DefaultListModel<Object> model, int index) {
            model.remove(index);
        }

        @Override
        public void removeAll(DefaultListModel<Object> model) {
            model.removeAllElements();
        }

        @Override
        public void addAll(DefaultListModel<Object> model, List<?> item) {
            model.addElement(item);
        }
    };
    private static final ListModelExtension COLLECTION_MODEL = new ListModelExtension<Object, CollectionListModel<Object>>(){

        @Override
        public Object get(CollectionListModel<Object> model, int index) {
            return model.getElementAt(index);
        }

        @Override
        public void set(CollectionListModel<Object> model, int index, Object item) {
            model.setElementAt(item, index);
        }

        @Override
        public void remove(CollectionListModel<Object> model, int index) {
            model.remove(index);
        }

        @Override
        public void removeAll(CollectionListModel<Object> model) {
            model.removeAll();
        }

        @Override
        public void addAll(CollectionListModel<Object> model, List<?> items) {
            model.addAll(model.getSize(), items);
        }
    };
    private static final ListModelExtension SORTED_MODEL = new ListModelExtension<Object, SortedListModel<Object>>(){

        @Override
        public Object get(SortedListModel<Object> model, int index) {
            return model.get(index);
        }

        @Override
        public void set(SortedListModel<Object> model, int index, Object item) {
            model.remove(index);
            model.add(item);
        }

        @Override
        public void remove(SortedListModel<Object> model, int index) {
            model.remove(index);
        }

        @Override
        public void removeAll(SortedListModel<Object> model) {
            model.clear();
        }

        @Override
        public void addAll(SortedListModel<Object> model, List<?> items) {
            model.addAll(items);
        }
    };
    private static final ListModelExtension FILTERED_MODEL = new ListModelExtension<Object, FilteringListModel<Object>>(){

        @Override
        public Object get(FilteringListModel<Object> model, int index) {
            return model.getElementAt(index);
        }

        @Override
        public void set(FilteringListModel<Object> model, int index, Object item) {
            ListUtil.getExtension(model.getOriginalModel()).set(model.getOriginalModel(), index, item);
        }

        @Override
        public void remove(FilteringListModel<Object> model, int index) {
            model.remove(index);
        }

        @Override
        public void removeAll(FilteringListModel<Object> model) {
            model.replaceAll(Collections.emptyList());
        }

        @Override
        public void addAll(FilteringListModel<Object> model, List<?> items) {
            model.addAll(items);
        }
    };

    public static <T> MouseMotionListener installAutoSelectOnMouseMove(final @NotNull JList<T> list) {
        if (list == null) {
            ListUtil.$$$reportNull$$$0(0);
        }
        MouseMotionAdapter listener2 = new MouseMotionAdapter(){
            boolean myIsEngaged = false;

            @Override
            public void mouseMoved(MouseEvent e) {
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (this.myIsEngaged && !UIUtil.isSelectionButtonDown((MouseEvent)e) && !(focusOwner instanceof JRootPane)) {
                    Point point = e.getPoint();
                    int index = list.locationToIndex(point);
                    list.putClientProperty(ListUtil.SELECTED_BY_MOUSE_EVENT, Boolean.TRUE);
                    list.setSelectedIndex(index);
                    list.putClientProperty(ListUtil.SELECTED_BY_MOUSE_EVENT, Boolean.FALSE);
                } else {
                    this.myIsEngaged = true;
                }
            }
        };
        list.addMouseMotionListener(listener2);
        return listener2;
    }

    @NotNull
    public static <T> List<T> removeSelectedItems(@NotNull JList<T> list) {
        if (list == null) {
            ListUtil.$$$reportNull$$$0(1);
        }
        return ListUtil.removeSelectedItems(list, null);
    }

    @NotNull
    public static <T> List<T> removeIndices(@NotNull JList<T> list, int[] indices) {
        if (list == null) {
            ListUtil.$$$reportNull$$$0(2);
        }
        List<T> list2 = ListUtil.removeIndices(list, indices, null);
        if (list2 == null) {
            ListUtil.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public static <T> List<T> removeSelectedItems(@NotNull JList<T> list, @Nullable Condition<? super T> condition) {
        if (list == null) {
            ListUtil.$$$reportNull$$$0(4);
        }
        int[] indices = list.getSelectedIndices();
        List<? super T> list2 = ListUtil.removeIndices(list, indices, condition);
        if (list2 == null) {
            ListUtil.$$$reportNull$$$0(5);
        }
        return list2;
    }

    public static <T> void removeItem(@NotNull ListModel<T> model, int index) {
        if (model == null) {
            ListUtil.$$$reportNull$$$0(6);
        }
        ListUtil.getExtension(model).remove(model, index);
    }

    public static <T> void removeAllItems(@NotNull ListModel<T> model) {
        if (model == null) {
            ListUtil.$$$reportNull$$$0(7);
        }
        ListUtil.getExtension(model).removeAll(model);
    }

    public static <T> void addAllItems(@NotNull ListModel<T> model, @NotNull List<? extends T> items) {
        if (model == null) {
            ListUtil.$$$reportNull$$$0(8);
        }
        if (items == null) {
            ListUtil.$$$reportNull$$$0(9);
        }
        ListUtil.getExtension(model).addAll(model, items);
    }

    private static <T> List<T> removeIndices(@NotNull JList<T> list, int @NotNull [] indices, @Nullable Condition<? super T> condition) {
        if (list == null) {
            ListUtil.$$$reportNull$$$0(10);
        }
        if (indices == null) {
            ListUtil.$$$reportNull$$$0(11);
        }
        if (indices.length == 0) {
            return new ArrayList(0);
        }
        ListModel<T> model = list.getModel();
        ListModelExtension<T, ListModel<T>> extension = ListUtil.getExtension(model);
        int firstSelectedIndex = indices[0];
        ArrayList<T> removedItems = new ArrayList<T>();
        int deletedCount = 0;
        for (int idx1 : indices) {
            int index = idx1 - deletedCount;
            if (index < 0 || index >= model.getSize()) continue;
            T obj = extension.get(model, index);
            if (condition != null && !condition.value(obj)) continue;
            removedItems.add(obj);
            extension.remove(model, index);
            ++deletedCount;
        }
        if (model.getSize() == 0) {
            list.clearSelection();
        } else if (list.getSelectedValue() == null) {
            if (firstSelectedIndex >= model.getSize()) {
                list.setSelectedIndex(model.getSize() - 1);
            } else {
                list.setSelectedIndex(firstSelectedIndex);
            }
        }
        return removedItems;
    }

    public static <T> boolean canRemoveSelectedItems(@NotNull JList<T> list) {
        if (list == null) {
            ListUtil.$$$reportNull$$$0(12);
        }
        return ListUtil.canRemoveSelectedItems(list, null);
    }

    public static <T> boolean canRemoveSelectedItems(@NotNull JList<T> list, @Nullable Condition<? super T> condition) {
        int[] indices;
        if (list == null) {
            ListUtil.$$$reportNull$$$0(13);
        }
        if ((indices = list.getSelectedIndices()).length == 0) {
            return false;
        }
        ListModel<T> model = list.getModel();
        ListModelExtension<T, ListModel<T>> extension = ListUtil.getExtension(model);
        for (int index : indices) {
            if (index < 0 || index >= model.getSize()) continue;
            T obj = extension.get(model, index);
            if (condition != null && !condition.value(obj)) continue;
            return true;
        }
        return false;
    }

    public static <T> int moveSelectedItemsUp(@NotNull JList<T> list) {
        if (list == null) {
            ListUtil.$$$reportNull$$$0(14);
        }
        ListModel<T> model = list.getModel();
        ListModelExtension<T, ListModel<T>> extension = ListUtil.getExtension(model);
        int[] indices = list.getSelectedIndices();
        if (!ListUtil.canMoveSelectedItemsUp(list)) {
            return 0;
        }
        for (int index : indices) {
            T temp = extension.get(model, index);
            extension.set(model, index, extension.get(model, index - 1));
            extension.set(model, index - 1, temp);
            list.removeSelectionInterval(index, index);
            list.addSelectionInterval(index - 1, index - 1);
        }
        Rectangle cellBounds = list.getCellBounds(indices[0] - 1, indices[indices.length - 1] - 1);
        if (cellBounds != null) {
            list.scrollRectToVisible(cellBounds);
        }
        return indices.length;
    }

    public static <T> boolean canMoveSelectedItemsUp(@NotNull JList<T> list) {
        int[] indices;
        if (list == null) {
            ListUtil.$$$reportNull$$$0(15);
        }
        return (indices = list.getSelectedIndices()).length > 0 && indices[0] > 0;
    }

    public static <T> int moveSelectedItemsDown(@NotNull JList<T> list) {
        if (list == null) {
            ListUtil.$$$reportNull$$$0(16);
        }
        ListModel<T> model = list.getModel();
        ListModelExtension<T, ListModel<T>> extension = ListUtil.getExtension(model);
        int[] indices = list.getSelectedIndices();
        if (!ListUtil.canMoveSelectedItemsDown(list)) {
            return 0;
        }
        for (int i = indices.length - 1; i >= 0; --i) {
            int index = indices[i];
            T temp = extension.get(model, index);
            extension.set(model, index, extension.get(model, index + 1));
            extension.set(model, index + 1, temp);
            list.removeSelectionInterval(index, index);
            list.addSelectionInterval(index + 1, index + 1);
        }
        Rectangle cellBounds = list.getCellBounds(indices[0] + 1, indices[indices.length - 1] + 1);
        if (cellBounds != null) {
            list.scrollRectToVisible(cellBounds);
        }
        return indices.length;
    }

    public static <T> boolean isPointOnSelection(@NotNull JList<T> list, int x, int y) {
        int row;
        if (list == null) {
            ListUtil.$$$reportNull$$$0(17);
        }
        if ((row = list.locationToIndex(new Point(x, y))) < 0) {
            return false;
        }
        return list.isSelectedIndex(row);
    }

    @Nullable
    public static <E> Component getDeepestRendererChildComponentAt(@NotNull JList<E> list, @NotNull Point point) {
        int idx;
        if (list == null) {
            ListUtil.$$$reportNull$$$0(18);
        }
        if (point == null) {
            ListUtil.$$$reportNull$$$0(19);
        }
        if ((idx = list.locationToIndex(point)) < 0) {
            return null;
        }
        Rectangle cellBounds = list.getCellBounds(idx, idx);
        if (!cellBounds.contains(point)) {
            return null;
        }
        E value = list.getModel().getElementAt(idx);
        if (value == null) {
            return null;
        }
        Component rendererComponent = list.getCellRenderer().getListCellRendererComponent(list, value, idx, true, true);
        rendererComponent.setBounds(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height);
        UIUtil.layoutRecursively((Component)rendererComponent);
        int rendererRelativeX = point.x - cellBounds.x;
        int rendererRelativeY = point.y - cellBounds.y;
        return UIUtil.getDeepestComponentAt((Component)rendererComponent, (int)rendererRelativeX, (int)rendererRelativeY);
    }

    public static <T> boolean canMoveSelectedItemsDown(@NotNull JList<T> list) {
        if (list == null) {
            ListUtil.$$$reportNull$$$0(20);
        }
        ListModel<T> model = list.getModel();
        int[] indices = list.getSelectedIndices();
        return indices.length > 0 && indices[indices.length - 1] < model.getSize() - 1;
    }

    public static <T> Updatable addMoveUpListener(@NotNull JButton button, final @NotNull JList<T> list) {
        if (button == null) {
            ListUtil.$$$reportNull$$$0(21);
        }
        if (list == null) {
            ListUtil.$$$reportNull$$$0(22);
        }
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListUtil.moveSelectedItemsUp(list);
                list.requestFocusInWindow();
            }
        });
        return ListUtil.disableWhenNoSelection(button, list);
    }

    public static <T> Updatable addMoveDownListener(@NotNull JButton button, final @NotNull JList<T> list) {
        if (button == null) {
            ListUtil.$$$reportNull$$$0(23);
        }
        if (list == null) {
            ListUtil.$$$reportNull$$$0(24);
        }
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListUtil.moveSelectedItemsDown(list);
                list.requestFocusInWindow();
            }
        });
        return ListUtil.disableWhenNoSelection(button, list);
    }

    public static <T> Updatable addRemoveListener(@NotNull JButton button, @NotNull JList<T> list) {
        if (button == null) {
            ListUtil.$$$reportNull$$$0(25);
        }
        if (list == null) {
            ListUtil.$$$reportNull$$$0(26);
        }
        return ListUtil.addRemoveListener(button, list, null);
    }

    public static <T> Updatable addRemoveListener(@NotNull JButton button, final @NotNull JList<T> list, final @Nullable RemoveNotification<T> notification) {
        if (button == null) {
            ListUtil.$$$reportNull$$$0(27);
        }
        if (list == null) {
            ListUtil.$$$reportNull$$$0(28);
        }
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List items = ListUtil.removeSelectedItems(list);
                if (notification != null) {
                    notification.itemsRemoved(items);
                }
                list.requestFocusInWindow();
            }
        });
        class MyListSelectionListener
        extends Updatable
        implements ListSelectionListener {
            final /* synthetic */ JList val$list;

            MyListSelectionListener(JButton jButton) {
                this.val$list = jButton;
                super(button);
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                this.setButtonEnabled(ListUtil.canRemoveSelectedItems(this.val$list));
            }

            @Override
            protected void update() {
                this.valueChanged(null);
            }
        }
        MyListSelectionListener listener2 = new MyListSelectionListener(button, list);
        list.getSelectionModel().addListSelectionListener(listener2);
        listener2.update();
        return listener2;
    }

    public static <T> Updatable disableWhenNoSelection(@NotNull JButton button, @NotNull JList<T> list) {
        if (button == null) {
            ListUtil.$$$reportNull$$$0(29);
        }
        if (list == null) {
            ListUtil.$$$reportNull$$$0(30);
        }
        class MyListSelectionListener
        extends Updatable
        implements ListSelectionListener {
            final /* synthetic */ JList val$list;

            MyListSelectionListener(JButton jButton) {
                this.val$list = jButton;
                super(button);
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                this.setButtonEnabled(this.val$list.getSelectedIndex() != -1);
            }

            @Override
            public void update() {
                this.valueChanged(null);
            }
        }
        MyListSelectionListener listener2 = new MyListSelectionListener(button, list);
        list.getSelectionModel().addListSelectionListener(listener2);
        listener2.update();
        return listener2;
    }

    @NotNull
    private static <T, ModelType extends ListModel<T>> ListModelExtension<T, ModelType> getExtension(@NotNull ModelType model) {
        if (model == null) {
            ListUtil.$$$reportNull$$$0(31);
        }
        if (model instanceof DefaultListModel) {
            ListModelExtension listModelExtension = DEFAULT_MODEL;
            if (listModelExtension == null) {
                ListUtil.$$$reportNull$$$0(32);
            }
            return listModelExtension;
        }
        if (model instanceof SortedListModel) {
            ListModelExtension listModelExtension = SORTED_MODEL;
            if (listModelExtension == null) {
                ListUtil.$$$reportNull$$$0(33);
            }
            return listModelExtension;
        }
        if (model instanceof FilteringListModel) {
            ListModelExtension listModelExtension = FILTERED_MODEL;
            if (listModelExtension == null) {
                ListUtil.$$$reportNull$$$0(34);
            }
            return listModelExtension;
        }
        if (model instanceof CollectionListModel) {
            ListModelExtension listModelExtension = COLLECTION_MODEL;
            if (listModelExtension == null) {
                ListUtil.$$$reportNull$$$0(35);
            }
            return listModelExtension;
        }
        throw new AssertionError((Object)("Unknown model class: " + model.getClass().getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: 
            case 5: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ListUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ListUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "removeIndices";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "removeSelectedItems";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installAutoSelectOnMouseMove";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeSelectedItems";
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeIndices";
                break;
            }
            case 3: 
            case 5: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeItem";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeAllItems";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addAllItems";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canRemoveSelectedItems";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "moveSelectedItemsUp";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "canMoveSelectedItemsUp";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "moveSelectedItemsDown";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isPointOnSelection";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestRendererChildComponentAt";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "canMoveSelectedItemsDown";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addMoveUpListener";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addMoveDownListener";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addRemoveListener";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "disableWhenNoSelection";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface ListModelExtension<T, ModelType extends ListModel<T>> {
        public T get(ModelType var1, int var2);

        public void set(ModelType var1, int var2, T var3);

        public void remove(ModelType var1, int var2);

        public void removeAll(ModelType var1);

        public void addAll(ModelType var1, List<? extends T> var2);
    }

    public static interface RemoveNotification<ItemType> {
        public void itemsRemoved(List<ItemType> var1);
    }

    public static abstract class Updatable {
        private final JButton myButton;
        private boolean myEnabled = true;

        public Updatable(JButton button) {
            this.myButton = button;
        }

        public void enable(boolean enable) {
            this.myEnabled = enable;
            this.update();
        }

        protected void setButtonEnabled(boolean enabled) {
            this.myButton.setEnabled(enabled && this.myEnabled);
        }

        protected abstract void update();
    }
}

