/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.table;

import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabLayout;
import com.intellij.ui.tabs.impl.table.TablePassInfo;
import com.intellij.ui.tabs.impl.table.TableRow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TableLayout
extends TabLayout {
    private final JBTabsImpl myTabs;
    public TablePassInfo myLastTableLayout;

    public TableLayout(JBTabsImpl tabs) {
        this.myTabs = tabs;
    }

    private TablePassInfo computeLayoutTable(List<TabInfo> visibleInfos) {
        TablePassInfo data = new TablePassInfo(this.myTabs, visibleInfos);
        Insets insets = this.myTabs.getLayoutInsets();
        data.toFitRec = new Rectangle(insets.left, insets.top, this.myTabs.getWidth() - insets.left - insets.right, this.myTabs.getHeight() - insets.top - insets.bottom);
        int eachRow = 0;
        int eachX = data.toFitRec.x;
        TableRow eachTableRow = new TableRow(data);
        data.table.add(eachTableRow);
        data.requiredRows = 1;
        for (TabInfo eachInfo : data.myVisibleInfos) {
            TabLabel eachLabel = this.myTabs.myInfo2Label.get(eachInfo);
            Dimension size = eachLabel.getPreferredSize();
            if ((double)(eachX + size.width) >= data.toFitRec.getMaxX()) {
                ++data.requiredRows;
                eachX = data.toFitRec.x;
            }
            this.myTabs.layout(eachLabel, eachX, 0, size.width, 1);
            eachX += size.width + this.myTabs.getTabHGap();
            data.requiredWidth += size.width + this.myTabs.getTabHGap();
        }
        int selectedRow = -1;
        eachX = data.toFitRec.x;
        data.rowToFitMaxX = (int)data.toFitRec.getMaxX();
        if (data.requiredRows > 1) {
            int rowFit = insets.left + data.requiredWidth / data.requiredRows;
            for (TabInfo eachInfo : data.myVisibleInfos) {
                TabLabel eachLabel = this.myTabs.myInfo2Label.get(eachInfo);
                Rectangle eachBounds = eachLabel.getBounds();
                if (!eachBounds.contains(rowFit, 0)) continue;
                data.rowToFitMaxX = (int)eachLabel.getBounds().getMaxX();
                break;
            }
        }
        for (TabInfo eachInfo : data.myVisibleInfos) {
            TabLabel eachLabel = this.myTabs.myInfo2Label.get(eachInfo);
            Dimension size = eachLabel.getPreferredSize();
            if (eachX + size.width <= data.rowToFitMaxX) {
                eachTableRow.add(eachInfo);
                if (this.myTabs.getSelectedInfo() == eachInfo) {
                    selectedRow = eachRow;
                }
                eachX += size.width + this.myTabs.getTabHGap();
                continue;
            }
            eachTableRow = new TableRow(data);
            data.table.add(eachTableRow);
            ++eachRow;
            eachX = insets.left + size.width;
            eachTableRow.add(eachInfo);
            if (this.myTabs.getSelectedInfo() != eachInfo) continue;
            selectedRow = eachRow;
        }
        ArrayList<TableRow> toMove = new ArrayList<TableRow>();
        for (int i = selectedRow + 1; i < data.table.size(); ++i) {
            toMove.add(data.table.get(i));
        }
        return data;
    }

    public boolean isLastRow(TabInfo info) {
        if (info == null) {
            return false;
        }
        List<TableRow> rows = this.myLastTableLayout.table;
        if (rows.size() > 0) {
            for (TabInfo tabInfo : rows.get((int)(rows.size() - 1)).myColumns) {
                if (tabInfo != info) continue;
                return true;
            }
        }
        return false;
    }

    public LayoutPassInfo layoutTable(List<TabInfo> visibleInfos) {
        this.myTabs.resetLayout(true);
        Insets insets = this.myTabs.getLayoutInsets();
        int eachY = insets.top;
        TablePassInfo data = new TablePassInfo(this.myTabs, visibleInfos);
        if (!this.myTabs.isHideTabs()) {
            data = this.computeLayoutTable(visibleInfos);
            insets = this.myTabs.getLayoutInsets();
            eachY = insets.top;
            for (TableRow eachRow : data.table) {
                int eachX = insets.left;
                int deltaToFit = 0;
                boolean toAjust = false;
                if (eachRow.width < data.toFitRec.width && data.table.size() > 1) {
                    deltaToFit = (int)Math.floor((double)(data.toFitRec.width - eachRow.width) / (double)eachRow.myColumns.size());
                    toAjust = true;
                }
                for (int i = 0; i < eachRow.myColumns.size(); ++i) {
                    TabInfo tabInfo = eachRow.myColumns.get(i);
                    TabLabel label = this.myTabs.myInfo2Label.get(tabInfo);
                    label.putClientProperty("Layout.stretchedByWidth", toAjust);
                    int width = i < eachRow.myColumns.size() - 1 || !toAjust ? label.getPreferredSize().width + deltaToFit : data.toFitRec.width + insets.left - eachX;
                    this.myTabs.layout(label, eachX, eachY, width, this.myTabs.myHeaderFitSize.height);
                    label.setAlignmentToCenter(deltaToFit > 0);
                    boolean lastCell = i == eachRow.myColumns.size() - 1;
                    eachX += width + (lastCell ? 0 : this.myTabs.getTabHGap());
                }
                eachY += this.myTabs.myHeaderFitSize.height;
            }
        }
        if (this.myTabs.getSelectedInfo() != null) {
            JBTabsImpl.Toolbar selectedToolbar = this.myTabs.myInfo2Toolbar.get(this.myTabs.getSelectedInfo());
            int componentY = eachY + (this.myTabs.isEditorTabs() ? 0 : 2) - this.myTabs.getLayoutInsets().top;
            if (!this.myTabs.myHorizontalSide && selectedToolbar != null && !selectedToolbar.isEmpty()) {
                int vSeparatorWidth;
                int toolbarWidth = selectedToolbar.getPreferredSize().width;
                int n = vSeparatorWidth = toolbarWidth > 0 ? this.myTabs.getSeparatorWidth() : 0;
                if (this.myTabs.isSideComponentBefore()) {
                    Rectangle compRect = this.myTabs.layoutComp(toolbarWidth + vSeparatorWidth, componentY, this.myTabs.getSelectedInfo().getComponent(), 0, 0);
                    this.myTabs.layout(selectedToolbar, compRect.x - toolbarWidth - vSeparatorWidth, compRect.y, toolbarWidth, compRect.height);
                } else {
                    int width = this.myTabs.getWidth() - toolbarWidth - vSeparatorWidth;
                    Rectangle compRect = this.myTabs.layoutComp(new Rectangle(0, componentY, width, this.myTabs.getHeight()), this.myTabs.getSelectedInfo().getComponent(), 0, 0);
                    this.myTabs.layout(selectedToolbar, compRect.x + compRect.width + vSeparatorWidth, compRect.y, toolbarWidth, compRect.height);
                }
            } else {
                this.myTabs.layoutComp(0, componentY, this.myTabs.getSelectedInfo().getComponent(), 0, 0);
            }
        }
        this.myLastTableLayout = data;
        return data;
    }

    @Override
    public boolean isDragOut(@NotNull TabLabel tabLabel, int deltaX, int deltaY) {
        if (tabLabel == null) {
            TableLayout.$$$reportNull$$$0(0);
        }
        if (this.myLastTableLayout == null) {
            return super.isDragOut(tabLabel, deltaX, deltaY);
        }
        Rectangle area = new Rectangle(this.myLastTableLayout.toFitRec.width, tabLabel.getBounds().height);
        for (int i = 0; i < this.myLastTableLayout.myVisibleInfos.size(); ++i) {
            area = area.union(this.myTabs.myInfo2Label.get(this.myLastTableLayout.myVisibleInfos.get(i)).getBounds());
        }
        return (double)Math.abs(deltaY) > (double)area.height * TableLayout.getDragOutMultiplier();
    }

    @Override
    public int getDropIndexFor(Point point) {
        if (this.myLastTableLayout == null) {
            return -1;
        }
        int result = -1;
        Component c = this.myTabs.getComponentAt(point);
        if (c instanceof JBTabsImpl) {
            for (int i = 0; i < this.myLastTableLayout.myVisibleInfos.size() - 1; ++i) {
                boolean between;
                TabLabel first = this.myTabs.myInfo2Label.get(this.myLastTableLayout.myVisibleInfos.get(i));
                TabLabel second = this.myTabs.myInfo2Label.get(this.myLastTableLayout.myVisibleInfos.get(i + 1));
                Rectangle firstBounds = first.getBounds();
                Rectangle secondBounds = second.getBounds();
                boolean bl = between = firstBounds.getMaxX() < (double)point.x && secondBounds.getX() > (double)point.x && firstBounds.y < point.y && secondBounds.getMaxY() > (double)point.y;
                if (!between) continue;
                c = first;
                break;
            }
        }
        if (c instanceof TabLabel) {
            TabInfo info = ((TabLabel)c).getInfo();
            int index = this.myLastTableLayout.myVisibleInfos.indexOf(info);
            boolean isDropTarget = this.myTabs.isDropTarget(info);
            if (!isDropTarget) {
                for (int i = 0; i <= index; ++i) {
                    if (!this.myTabs.isDropTarget((TabInfo)this.myLastTableLayout.myVisibleInfos.get(i))) continue;
                    --index;
                    break;
                }
                result = index;
            } else if (index < this.myLastTableLayout.myVisibleInfos.size()) {
                result = index;
            }
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabLabel", "com/intellij/ui/tabs/impl/table/TableLayout", "isDragOut"));
    }
}

