/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.net.ssl.CertificateListener;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.CertificateUtil;
import com.intellij.util.net.ssl.CertificateWarningDialog;
import com.intellij.util.net.ssl.ClientOnlyTrustManager;
import com.intellij.util.net.ssl.UntrustedCertificateStrategy;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfirmingTrustManager
extends ClientOnlyTrustManager {
    private static final Logger LOG = Logger.getInstance(ConfirmingTrustManager.class);
    private static final X509Certificate[] NO_CERTIFICATES = new X509Certificate[0];
    private static final X509TrustManager MISSING_TRUST_MANAGER = new ClientOnlyTrustManager(){

        @Override
        public void checkServerTrusted(X509Certificate[] certificates, String s) throws CertificateException {
            LOG.debug("Trust manager is missing. Retreating.");
            throw new CertificateException("Missing trust manager");
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return NO_CERTIFICATES;
        }
    };
    final ThreadLocal<UntrustedCertificateStrategy> myUntrustedCertificateStrategy = ThreadLocal.withInitial(() -> UntrustedCertificateStrategy.ASK_USER);
    private final X509TrustManager mySystemManager;
    private final MutableTrustManager myCustomManager;

    public static ConfirmingTrustManager createForStorage(@NotNull String path2, @NotNull String password) {
        if (path2 == null) {
            ConfirmingTrustManager.$$$reportNull$$$0(0);
        }
        if (password == null) {
            ConfirmingTrustManager.$$$reportNull$$$0(1);
        }
        return new ConfirmingTrustManager(ConfirmingTrustManager.getSystemDefault(), new MutableTrustManager(path2, password));
    }

    private static X509TrustManager getSystemDefault() {
        try {
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init((KeyStore)null);
            X509TrustManager systemManager = ConfirmingTrustManager.findX509TrustManager(factory.getTrustManagers());
            if (systemManager != null && systemManager.getAcceptedIssuers().length != 0) {
                return systemManager;
            }
        }
        catch (Exception e) {
            LOG.error("Cannot get system trust store", (Throwable)e);
        }
        return MISSING_TRUST_MANAGER;
    }

    private ConfirmingTrustManager(X509TrustManager system, MutableTrustManager custom) {
        this.mySystemManager = system;
        this.myCustomManager = custom;
    }

    private static X509TrustManager findX509TrustManager(TrustManager[] managers) {
        for (TrustManager manager : managers) {
            if (!(manager instanceof X509TrustManager)) continue;
            return (X509TrustManager)manager;
        }
        return null;
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String s) throws CertificateException {
        boolean askUser = this.myUntrustedCertificateStrategy.get() == UntrustedCertificateStrategy.ASK_USER;
        this.checkServerTrusted(certificates, s, true, askUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkServerTrusted(X509Certificate[] certificates, String s, boolean addToKeyStore, boolean askUser) throws CertificateException {
        try {
            this.mySystemManager.checkServerTrusted(certificates, s);
        }
        catch (CertificateException e) {
            MutableTrustManager mutableTrustManager = this.myCustomManager;
            synchronized (mutableTrustManager) {
                block7: {
                    try {
                        this.myCustomManager.checkServerTrusted(certificates, s);
                    }
                    catch (CertificateException e2) {
                        if (!this.myCustomManager.isBroken() && this.confirmAndUpdate(certificates, addToKeyStore, askUser)) break block7;
                        throw e;
                    }
                }
            }
        }
    }

    private boolean confirmAndUpdate(X509Certificate[] chain, boolean addToKeyStore, boolean askUser) {
        boolean accepted;
        Application app = ApplicationManager.getApplication();
        X509Certificate endPoint = chain[0];
        String threadClassName = StringUtil.notNullize((String)Thread.currentThread().getClass().getCanonicalName());
        if (threadClassName.equals("sun.awt.image.ImageFetcher")) {
            LOG.debug("Image Fetcher thread is detected. Certificate check will be skipped.");
            return true;
        }
        if (app.isUnitTestMode() || app.isHeadlessEnvironment() || CertificateManager.getInstance().getState().ACCEPT_AUTOMATICALLY) {
            LOG.debug("Certificate will be accepted automatically");
            if (addToKeyStore) {
                this.myCustomManager.addCertificate(endPoint);
            }
            return true;
        }
        boolean bl = accepted = askUser && CertificateManager.showAcceptDialog(() -> CertificateWarningDialog.createUntrustedCertificateWarning(endPoint));
        if (accepted) {
            LOG.info("Certificate was accepted by user");
            if (addToKeyStore) {
                this.myCustomManager.addCertificate(endPoint);
            }
        }
        return accepted;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return (X509Certificate[])ArrayUtil.mergeArrays((Object[])this.mySystemManager.getAcceptedIssuers(), (Object[])this.myCustomManager.getAcceptedIssuers());
    }

    public X509TrustManager getSystemManager() {
        return this.mySystemManager;
    }

    public MutableTrustManager getCustomManager() {
        return this.myCustomManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "path";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "password";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/net/ssl/ConfirmingTrustManager";
        objectArray[2] = "createForStorage";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MutableTrustManager
    extends ClientOnlyTrustManager {
        private final String myPath;
        private final String myPassword;
        private final TrustManagerFactory myFactory;
        private final KeyStore myKeyStore;
        private final ReadWriteLock myLock;
        private final Lock myReadLock;
        private final Lock myWriteLock;
        private X509TrustManager myTrustManager;
        private final EventDispatcher<CertificateListener> myDispatcher;

        private MutableTrustManager(@NotNull String path2, @NotNull String password) {
            if (path2 == null) {
                MutableTrustManager.$$$reportNull$$$0(0);
            }
            if (password == null) {
                MutableTrustManager.$$$reportNull$$$0(1);
            }
            this.myLock = new ReentrantReadWriteLock();
            this.myReadLock = this.myLock.readLock();
            this.myWriteLock = this.myLock.writeLock();
            this.myDispatcher = EventDispatcher.create(CertificateListener.class);
            this.myPath = path2;
            this.myPassword = password;
            this.myWriteLock.lock();
            try {
                this.myFactory = MutableTrustManager.createFactory();
                this.myKeyStore = MutableTrustManager.createKeyStore(path2, password);
                this.myTrustManager = this.initFactoryAndGetManager();
            }
            finally {
                this.myWriteLock.unlock();
            }
        }

        private static TrustManagerFactory createFactory() {
            try {
                return TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error("Cannot create trust manager factory", (Throwable)e);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static KeyStore createKeyStore(@NotNull String path2, @NotNull String password) {
            KeyStore keyStore;
            block8: {
                if (path2 == null) {
                    MutableTrustManager.$$$reportNull$$$0(2);
                }
                if (password == null) {
                    MutableTrustManager.$$$reportNull$$$0(3);
                }
                try {
                    keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    File cacertsFile = new File(path2);
                    if (cacertsFile.exists()) {
                        FileInputStream stream = null;
                        try {
                            stream = new FileInputStream(path2);
                            keyStore.load(stream, password.toCharArray());
                        }
                        catch (Throwable throwable) {
                            StreamUtil.closeStream(stream);
                            throw throwable;
                        }
                        StreamUtil.closeStream((Closeable)stream);
                        break block8;
                    }
                    if (!FileUtil.createParentDirs((File)cacertsFile)) {
                        LOG.error("Cannot create directories: " + cacertsFile.getParent());
                        return null;
                    }
                    keyStore.load(null, password.toCharArray());
                }
                catch (Exception e) {
                    LOG.error("Cannot create key store", (Throwable)e);
                    return null;
                }
            }
            return keyStore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addCertificate(@NotNull X509Certificate certificate) {
            if (certificate == null) {
                MutableTrustManager.$$$reportNull$$$0(4);
            }
            this.myWriteLock.lock();
            try {
                if (this.isBroken()) {
                    boolean bl = false;
                    return bl;
                }
                this.myKeyStore.setCertificateEntry(MutableTrustManager.createAlias(certificate), certificate);
                this.flushKeyStore();
                this.myTrustManager = this.initFactoryAndGetManager();
                ((CertificateListener)this.myDispatcher.getMulticaster()).certificateAdded(certificate);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                LOG.error("Cannot add certificate", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                this.myWriteLock.unlock();
            }
        }

        public boolean addCertificate(@NotNull String path2) {
            X509Certificate certificate;
            if (path2 == null) {
                MutableTrustManager.$$$reportNull$$$0(5);
            }
            return (certificate = CertificateUtil.loadX509Certificate(path2)) != null && this.addCertificate(certificate);
        }

        private static String createAlias(@NotNull X509Certificate certificate) {
            if (certificate == null) {
                MutableTrustManager.$$$reportNull$$$0(6);
            }
            return CertificateUtil.getCommonName(certificate);
        }

        public boolean removeCertificate(@NotNull X509Certificate certificate) {
            if (certificate == null) {
                MutableTrustManager.$$$reportNull$$$0(7);
            }
            return this.removeCertificate(MutableTrustManager.createAlias(certificate));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeCertificate(@NotNull String alias) {
            if (alias == null) {
                MutableTrustManager.$$$reportNull$$$0(8);
            }
            this.myWriteLock.lock();
            try {
                if (this.isBroken()) {
                    boolean bl = false;
                    return bl;
                }
                X509Certificate certificate = this.getCertificate(alias);
                if (certificate == null) {
                    LOG.error("No certificate found for alias: " + alias);
                    boolean bl = false;
                    return bl;
                }
                this.myKeyStore.deleteEntry(alias);
                this.flushKeyStore();
                this.myTrustManager = this.initFactoryAndGetManager();
                ((CertificateListener)this.myDispatcher.getMulticaster()).certificateRemoved(certificate);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                LOG.error("Cannot remove certificate for alias: " + alias, (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                this.myWriteLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public X509Certificate getCertificate(@NotNull String alias) {
            if (alias == null) {
                MutableTrustManager.$$$reportNull$$$0(9);
            }
            this.myReadLock.lock();
            try {
                X509Certificate x509Certificate = (X509Certificate)this.myKeyStore.getCertificate(alias);
                return x509Certificate;
            }
            catch (KeyStoreException e) {
                X509Certificate x509Certificate = null;
                return x509Certificate;
            }
            finally {
                this.myReadLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<X509Certificate> getCertificates() {
            this.myReadLock.lock();
            try {
                ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
                for (String alias : Collections.list(this.myKeyStore.aliases())) {
                    certificates.add(this.getCertificate(alias));
                }
                ImmutableList immutableList = ContainerUtil.immutableList(certificates);
                return immutableList;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                List list = ContainerUtil.emptyList();
                return list;
            }
            finally {
                this.myReadLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsCertificate(@NotNull String alias) {
            if (alias == null) {
                MutableTrustManager.$$$reportNull$$$0(10);
            }
            this.myReadLock.lock();
            try {
                boolean bl = this.myKeyStore.containsAlias(alias);
                return bl;
            }
            catch (KeyStoreException e) {
                LOG.error((Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                this.myReadLock.unlock();
            }
        }

        boolean removeAllCertificates() {
            for (X509Certificate certificate : this.getCertificates()) {
                if (this.removeCertificate(certificate)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certificates, String s) throws CertificateException {
            this.myReadLock.lock();
            try {
                if (this.keyStoreIsEmpty() || this.isBroken()) {
                    throw new CertificateException();
                }
                this.myTrustManager.checkServerTrusted(certificates, s);
            }
            finally {
                this.myReadLock.unlock();
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            this.myReadLock.lock();
            try {
                if (this.keyStoreIsEmpty() || this.isBroken()) {
                    X509Certificate[] x509CertificateArray = NO_CERTIFICATES;
                    return x509CertificateArray;
                }
                X509Certificate[] x509CertificateArray = this.myTrustManager.getAcceptedIssuers();
                return x509CertificateArray;
            }
            finally {
                this.myReadLock.unlock();
            }
        }

        public void addListener(@NotNull CertificateListener listener2) {
            if (listener2 == null) {
                MutableTrustManager.$$$reportNull$$$0(11);
            }
            this.myDispatcher.addListener((EventListener)listener2);
        }

        public void removeListener(@NotNull CertificateListener listener2) {
            if (listener2 == null) {
                MutableTrustManager.$$$reportNull$$$0(12);
            }
            this.myDispatcher.removeListener((EventListener)listener2);
        }

        private boolean keyStoreIsEmpty() {
            try {
                return this.myKeyStore.size() == 0;
            }
            catch (KeyStoreException e) {
                LOG.error((Throwable)e);
                return true;
            }
        }

        private X509TrustManager initFactoryAndGetManager() {
            try {
                if (this.myFactory != null && this.myKeyStore != null) {
                    this.myFactory.init(this.myKeyStore);
                    Object[] trustManagers = this.myFactory.getTrustManagers();
                    X509TrustManager result = ConfirmingTrustManager.findX509TrustManager((TrustManager[])trustManagers);
                    if (result == null) {
                        LOG.error("Cannot find X509 trust manager among " + Arrays.toString(trustManagers));
                    }
                    return result;
                }
            }
            catch (KeyStoreException e) {
                LOG.error("Cannot initialize trust store", (Throwable)e);
            }
            return null;
        }

        private boolean isBroken() {
            return this.myKeyStore == null || this.myFactory == null || this.myTrustManager == null;
        }

        private void flushKeyStore() throws Exception {
            FileOutputStream stream = new FileOutputStream(this.myPath);
            try {
                this.myKeyStore.store(stream, this.myPassword.toCharArray());
            }
            finally {
                StreamUtil.closeStream((Closeable)stream);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "password";
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "certificate";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alias";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/net/ssl/ConfirmingTrustManager$MutableTrustManager";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createKeyStore";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCertificate";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createAlias";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeCertificate";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCertificate";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "containsCertificate";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addListener";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeListener";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

