/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import one.util.streamex.BaseStreamEx;

class StreamContext {
    static final StreamContext SEQUENTIAL = new StreamContext(false);
    static final StreamContext PARALLEL = new StreamContext(true);
    boolean parallel;
    ForkJoinPool fjp;
    Runnable closeHandler;

    private StreamContext(boolean parallel) {
        this.parallel = parallel;
    }

    <T> T terminate(Supplier<T> terminalOperation) {
        return (T)((ForkJoinTask)this.fjp.submit(terminalOperation::get)).join();
    }

    <T, U> T terminate(U value, Function<U, T> terminalOperation) {
        return (T)((ForkJoinTask)this.fjp.submit(() -> terminalOperation.apply(value))).join();
    }

    StreamContext parallel() {
        if (this == SEQUENTIAL) {
            return PARALLEL;
        }
        this.parallel = true;
        this.fjp = null;
        return this;
    }

    StreamContext sequential() {
        if (this == PARALLEL) {
            return SEQUENTIAL;
        }
        this.parallel = false;
        this.fjp = null;
        return this;
    }

    StreamContext parallel(ForkJoinPool fjp) {
        StreamContext context = this.detach();
        context.parallel = true;
        context.fjp = fjp;
        return context;
    }

    StreamContext detach() {
        if (this == PARALLEL || this == SEQUENTIAL) {
            return new StreamContext(this.parallel);
        }
        return this;
    }

    StreamContext onClose(Runnable r) {
        StreamContext context = this.detach();
        context.closeHandler = StreamContext.compose(context.closeHandler, r);
        return context;
    }

    void close() {
        if (this.closeHandler != null) {
            Runnable r = this.closeHandler;
            this.closeHandler = null;
            r.run();
        }
    }

    static Runnable compose(Runnable r1, Runnable r2) {
        if (r1 == null) {
            return r2;
        }
        return () -> {
            try {
                r1.run();
            }
            finally {
                r2.run();
            }
        };
    }

    StreamContext combine(BaseStream<?, ?> other) {
        if (other == null) {
            return this;
        }
        StreamContext otherStrategy = StreamContext.of(other);
        StreamContext result = this;
        if (other.isParallel() && !this.parallel) {
            result = this.parallel();
        }
        if (otherStrategy.closeHandler != null) {
            result = result.onClose(otherStrategy.closeHandler);
        }
        return result;
    }

    static StreamContext of(BaseStream<?, ?> stream) {
        if (stream instanceof BaseStreamEx) {
            return ((BaseStreamEx)stream).context;
        }
        return new StreamContext(stream.isParallel()).onClose(stream::close);
    }
}

