/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.loader;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.lang.ClassPath;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class LoadedResourcesDumper
implements ClassPath.ResourceLoadingLogger {
    private PrintStream myOrder;
    private long myOrderSize;
    private final Set<String> myOrderedUrls = new HashSet<String>();

    @Override
    public void logResource(String url, URL baseLoaderURL, long resourceSize) {
        if (!this.myOrderedUrls.add(url)) {
            return;
        }
        String home = FileUtil.toSystemIndependentName(PathManager.getHomePath());
        if (resourceSize != -1L) {
            this.myOrderSize += resourceSize;
        }
        if (this.myOrder == null) {
            File orderFile = new File(PathManager.getBinPath(), "order.txt");
            try {
                if (!FileUtil.ensureCanCreateFile(orderFile)) {
                    return;
                }
                this.myOrder = new PrintStream(new FileOutputStream(orderFile, true));
                ShutDownTracker.getInstance().registerShutdownTask(this::closeOrderStream);
            }
            catch (IOException e) {
                return;
            }
        }
        if (this.myOrder != null) {
            String jarURL;
            Pair<String, String> pair = URLUtil.splitJarUrl(baseLoaderURL.toExternalForm());
            String string = jarURL = pair != null ? (String)pair.first : null;
            if (jarURL != null && jarURL.startsWith(home)) {
                jarURL = jarURL.replaceFirst(home, "");
                jarURL = StringUtil.trimEnd(jarURL, "!/");
                this.myOrder.println(url + ":" + jarURL);
            }
        }
    }

    private synchronized void closeOrderStream() {
        this.myOrder.close();
        System.out.println(this.myOrderSize);
    }
}

