/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ShowContentAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.DefaultTerminalRunnerFactory;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalTabCloseListener;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.TerminalToolWindowPanel;
import org.jetbrains.plugins.terminal.action.MoveTerminalToolWindowTabLeftAction;
import org.jetbrains.plugins.terminal.action.MoveTerminalToolWindowTabRightAction;
import org.jetbrains.plugins.terminal.action.RenameTerminalSessionAction;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementManager;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementState;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;
import org.jetbrains.plugins.terminal.ui.TerminalContainer;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

public final class TerminalView {
    private static final Key<JBTerminalWidget> TERMINAL_WIDGET_KEY = new Key("TerminalWidget");
    private static final Logger LOG = Logger.getInstance(TerminalView.class);
    private ToolWindow myToolWindow;
    private final Project myProject;
    private final AbstractTerminalRunner<?> myTerminalRunner;
    private TerminalDockContainer myDockContainer;
    private final Map<JBTerminalWidget, TerminalContainer> myContainerByWidgetMap;

    @NotNull
    public AbstractTerminalRunner<?> getTerminalRunner() {
        AbstractTerminalRunner<?> abstractTerminalRunner = this.myTerminalRunner;
        if (abstractTerminalRunner == null) {
            TerminalView.$$$reportNull$$$0(0);
        }
        return abstractTerminalRunner;
    }

    public TerminalView(@NotNull Project project) {
        if (project == null) {
            TerminalView.$$$reportNull$$$0(1);
        }
        this.myContainerByWidgetMap = new HashMap<JBTerminalWidget, TerminalContainer>();
        this.myProject = project;
        this.myTerminalRunner = ((DefaultTerminalRunnerFactory)ApplicationManager.getApplication().getService(DefaultTerminalRunnerFactory.class)).create(project);
    }

    public static TerminalView getInstance(@NotNull Project project) {
        if (project == null) {
            TerminalView.$$$reportNull$$$0(2);
        }
        return (TerminalView)project.getService(TerminalView.class);
    }

    void initToolWindow(final @NotNull ToolWindowEx toolWindow) {
        if (toolWindow == null) {
            TerminalView.$$$reportNull$$$0(3);
        }
        if (this.myToolWindow != null) {
            LOG.error("Terminal tool window already initialized");
            return;
        }
        this.myToolWindow = toolWindow;
        toolWindow.setTabActions(new AnAction[]{new DumbAwareAction(IdeBundle.messagePointer((String)"action.DumbAware.TerminalView.text.new.session", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.DumbAware.TerminalView.description.create.new.session", (Object[])new Object[0]), AllIcons.General.Add){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                TerminalView.this.newTab((ToolWindow)toolWindow, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/terminal/TerminalView$1", "actionPerformed"));
            }
        }});
        toolWindow.setTabDoubleClickActions(Collections.singletonList(new RenameTerminalSessionAction()));
        toolWindow.setToHideOnEmptyContent(true);
        this.myProject.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void toolWindowShown(@NotNull String id, @NotNull ToolWindow toolWindow) {
                if (id == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (toolWindow == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ("Terminal".equals(id) && TerminalView.this.myToolWindow == toolWindow && toolWindow.isVisible() && toolWindow.getContentManager().getContentCount() == 0) {
                    TerminalView.this.createNewSession(TerminalView.this.myTerminalRunner, null, true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "id";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "toolWindow";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/terminal/TerminalView$2";
                objectArray[2] = "toolWindowShown";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (this.myDockContainer == null) {
            this.myDockContainer = new TerminalDockContainer();
            DockManager.getInstance((Project)this.myProject).register((DockContainer)this.myDockContainer, toolWindow.getDisposable());
        }
    }

    void restoreTabs(@Nullable TerminalArrangementState arrangementState) {
        ContentManager contentManager = this.myToolWindow.getContentManager();
        if (arrangementState != null) {
            for (TerminalTabState tabState : arrangementState.myTabStates) {
                this.createNewSession(this.myTerminalRunner, tabState, false);
            }
            Content content = contentManager.getContent(arrangementState.mySelectedTabIndex);
            if (content != null) {
                contentManager.setSelectedContent(content);
            }
        }
    }

    public void createNewSession(@NotNull AbstractTerminalRunner<?> terminalRunner) {
        if (terminalRunner == null) {
            TerminalView.$$$reportNull$$$0(4);
        }
        this.createNewSession(terminalRunner, null);
    }

    public void createNewSession(@NotNull AbstractTerminalRunner<?> terminalRunner, @Nullable TerminalTabState tabState) {
        if (terminalRunner == null) {
            TerminalView.$$$reportNull$$$0(5);
        }
        this.createNewSession(terminalRunner, tabState, true);
    }

    @NotNull
    public ShellTerminalWidget createLocalShellWidget(@Nullable String workingDirectory, @Nullable String tabName) {
        TerminalTabState tabState = new TerminalTabState();
        tabState.myTabName = tabName;
        tabState.myWorkingDirectory = workingDirectory;
        JBTerminalWidget widget = this.createNewSession(this.myTerminalRunner, tabState, true);
        ShellTerminalWidget shellTerminalWidget = (ShellTerminalWidget)Objects.requireNonNull(widget);
        if (shellTerminalWidget == null) {
            TerminalView.$$$reportNull$$$0(6);
        }
        return shellTerminalWidget;
    }

    @NotNull
    private JBTerminalWidget createNewSession(@NotNull AbstractTerminalRunner<?> terminalRunner, @Nullable TerminalTabState tabState, boolean requestFocus) {
        if (terminalRunner == null) {
            TerminalView.$$$reportNull$$$0(7);
        }
        ToolWindow toolWindow = this.getOrInitToolWindow();
        Content content = this.createNewTab(null, terminalRunner, toolWindow, tabState, requestFocus);
        JBTerminalWidget jBTerminalWidget = Objects.requireNonNull(TerminalView.getWidgetByContent(content));
        if (jBTerminalWidget == null) {
            TerminalView.$$$reportNull$$$0(8);
        }
        return jBTerminalWidget;
    }

    @NotNull
    private ToolWindow getOrInitToolWindow() {
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow == null) {
            toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Terminal");
            Objects.requireNonNull(toolWindow).getContentManager();
            LOG.assertTrue(toolWindow == this.myToolWindow);
        }
        ToolWindow toolWindow2 = toolWindow;
        if (toolWindow2 == null) {
            TerminalView.$$$reportNull$$$0(9);
        }
        return toolWindow2;
    }

    @NotNull
    private Content newTab(@NotNull ToolWindow toolWindow, @Nullable JBTerminalWidget terminalWidget) {
        if (toolWindow == null) {
            TerminalView.$$$reportNull$$$0(10);
        }
        return this.createNewTab(terminalWidget, this.myTerminalRunner, toolWindow, null, true);
    }

    @NotNull
    private Content createNewTab(@Nullable JBTerminalWidget terminalWidget, @NotNull AbstractTerminalRunner<?> terminalRunner, @NotNull ToolWindow toolWindow, @Nullable TerminalTabState tabState, boolean requestFocus) {
        if (terminalRunner == null) {
            TerminalView.$$$reportNull$$$0(11);
        }
        if (toolWindow == null) {
            TerminalView.$$$reportNull$$$0(12);
        }
        Content content = this.createTerminalContent(terminalRunner, toolWindow, terminalWidget, tabState);
        ContentManager contentManager = toolWindow.getContentManager();
        contentManager.addContent(content);
        new TerminalTabCloseListener(content, this.myProject);
        Runnable selectRunnable = () -> contentManager.setSelectedContent(content, requestFocus);
        if (requestFocus && !toolWindow.isActive()) {
            LOG.info("Activating " + toolWindow.getId() + " tool window");
            toolWindow.activate(selectRunnable, true, true);
        } else {
            selectRunnable.run();
        }
        Content content2 = content;
        if (content2 == null) {
            TerminalView.$$$reportNull$$$0(13);
        }
        return content2;
    }

    private static String generateUniqueName(String suggestedName, List<String> tabs) {
        HashSet names = Sets.newHashSet(tabs);
        return UniqueNameGenerator.generateUniqueName((String)suggestedName, (String)"", (String)"", (String)" (", (String)")", o -> !names.contains(o));
    }

    @NotNull
    private Content createTerminalContent(@NotNull AbstractTerminalRunner<?> terminalRunner, @NotNull ToolWindow toolWindow, @Nullable JBTerminalWidget terminalWidget, @Nullable TerminalTabState tabState) {
        if (terminalRunner == null) {
            TerminalView.$$$reportNull$$$0(14);
        }
        if (toolWindow == null) {
            TerminalView.$$$reportNull$$$0(15);
        }
        TerminalToolWindowPanel panel = new TerminalToolWindowPanel(PropertiesComponent.getInstance((Project)this.myProject), toolWindow);
        String tabName = (String)ObjectUtils.notNull((Object)(tabState != null ? tabState.myTabName : null), (Object)TerminalOptionsProvider.getInstance().getTabName());
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)((Object)panel), tabName, false);
        if (terminalWidget == null) {
            VirtualFile currentWorkingDir = TerminalView.getCurrentWorkingDir(tabState);
            terminalWidget = terminalRunner.createTerminalWidget((Disposable)content, currentWorkingDir);
            TerminalArrangementManager.getInstance(this.myProject).register(terminalWidget, tabState);
            TerminalWorkingDirectoryManager.setInitialWorkingDirectory(content, currentWorkingDir);
        } else {
            terminalWidget.setVirtualFile(null);
            terminalWidget.moveDisposable((Disposable)content);
        }
        this.setupTerminalWidget(toolWindow, terminalWidget, tabState, content, true);
        content.setCloseable(true);
        content.putUserData(TERMINAL_WIDGET_KEY, (Object)terminalWidget);
        TerminalContainer container = new TerminalContainer(this.myProject, content, terminalWidget, this);
        panel.setContent(container.getComponent());
        panel.addFocusListener(TerminalView.createFocusListener(toolWindow));
        panel.updateDFState();
        TerminalView.updatePreferredFocusableComponent(content, terminalWidget);
        Content content2 = content;
        if (content2 == null) {
            TerminalView.$$$reportNull$$$0(16);
        }
        return content2;
    }

    private void setupTerminalWidget(final @NotNull ToolWindow toolWindow, final @NotNull JBTerminalWidget terminalWidget, final @Nullable TerminalTabState tabState, final @NotNull Content content, final boolean updateContentDisplayName) {
        if (toolWindow == null) {
            TerminalView.$$$reportNull$$$0(17);
        }
        if (terminalWidget == null) {
            TerminalView.$$$reportNull$$$0(18);
        }
        if (content == null) {
            TerminalView.$$$reportNull$$$0(19);
        }
        final MoveTerminalToolWindowTabLeftAction moveTabLeftAction = new MoveTerminalToolWindowTabLeftAction();
        final MoveTerminalToolWindowTabRightAction moveTabRightAction = new MoveTerminalToolWindowTabRightAction();
        terminalWidget.setListener(new JBTerminalWidgetListener(){

            public void onNewSession() {
                TerminalView.this.newTab(toolWindow, null);
            }

            public void onTerminalStarted() {
                if (updateContentDisplayName && (tabState == null || StringUtil.isEmpty((String)tabState.myTabName))) {
                    String name = terminalWidget.getSettingsProvider().tabName(terminalWidget.getTtyConnector(), terminalWidget.getSessionName());
                    ArrayList contents = ContainerUtil.newArrayList((Object[])toolWindow.getContentManager().getContents());
                    contents.remove(content);
                    content.setDisplayName(TerminalView.generateUniqueName(name, ContainerUtil.map((Collection)contents, c -> c.getDisplayName())));
                }
            }

            public void onPreviousTabSelected() {
                if (toolWindow.getContentManager().getContentCount() > 1) {
                    toolWindow.getContentManager().selectPreviousContent();
                }
            }

            public void onNextTabSelected() {
                if (toolWindow.getContentManager().getContentCount() > 1) {
                    toolWindow.getContentManager().selectNextContent();
                }
            }

            public void onSessionClosed() {
                terminalWidget.close();
            }

            public void showTabs() {
                ShowContentAction action = new ShowContentAction(toolWindow, toolWindow.getComponent(), (Disposable)toolWindow.getContentManager());
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)toolWindow.getComponent());
                KeyEvent fakeKeyEvent = new KeyEvent(toolWindow.getComponent(), 1001, System.currentTimeMillis(), 0, 0, '\u0000');
                AnActionEvent event = AnActionEvent.createFromInputEvent((InputEvent)fakeKeyEvent, (String)"unknown", null, (DataContext)dataContext);
                action.actionPerformed(event);
            }

            public void moveTabRight() {
                moveTabRightAction.move(content, TerminalView.this.myProject);
            }

            public void moveTabLeft() {
                moveTabLeftAction.move(content, TerminalView.this.myProject);
            }

            public boolean canMoveTabRight() {
                return moveTabRightAction.isAvailable(content);
            }

            public boolean canMoveTabLeft() {
                return moveTabLeftAction.isAvailable(content);
            }

            public boolean canSplit(boolean vertically) {
                return true;
            }

            public void split(boolean vertically) {
                TerminalView.this.split(terminalWidget, vertically);
            }

            public boolean isGotoNextSplitTerminalAvailable() {
                return TerminalView.this.isSplitTerminal(terminalWidget);
            }

            public void gotoNextSplitTerminal(boolean forward) {
                TerminalView.this.gotoNextSplitTerminal(terminalWidget, forward);
            }
        });
        terminalWidget.getTerminalPanel().addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TerminalView.updatePreferredFocusableComponent(content, terminalWidget);
            }
        });
    }

    private static void updatePreferredFocusableComponent(@NotNull Content content, @NotNull JBTerminalWidget terminalWidget) {
        if (content == null) {
            TerminalView.$$$reportNull$$$0(20);
        }
        if (terminalWidget == null) {
            TerminalView.$$$reportNull$$$0(21);
        }
        content.setPreferredFocusableComponent(terminalWidget.getPreferredFocusableComponent());
    }

    public boolean isSplitTerminal(@NotNull JBTerminalWidget widget) {
        if (widget == null) {
            TerminalView.$$$reportNull$$$0(22);
        }
        TerminalContainer container = Objects.requireNonNull(this.myContainerByWidgetMap.get(widget));
        return container.isSplitTerminal();
    }

    public void gotoNextSplitTerminal(@NotNull JBTerminalWidget widget, boolean forward) {
        TerminalContainer container;
        JBTerminalWidget next;
        if (widget == null) {
            TerminalView.$$$reportNull$$$0(23);
        }
        if ((next = (container = Objects.requireNonNull(this.myContainerByWidgetMap.get(widget))).getNextSplitTerminal(forward)) != null) {
            container.requestFocus(next);
        }
    }

    public void split(@NotNull JBTerminalWidget widget, boolean vertically) {
        if (widget == null) {
            TerminalView.$$$reportNull$$$0(24);
        }
        TerminalContainer container = Objects.requireNonNull(this.myContainerByWidgetMap.get(widget));
        JBTerminalWidget newWidget = this.myTerminalRunner.createTerminalWidget((Disposable)container.getContent(), null);
        this.setupTerminalWidget(this.myToolWindow, newWidget, null, container.getContent(), false);
        container.split(!vertically, newWidget);
    }

    public void register(@NotNull TerminalContainer terminalContainer) {
        if (terminalContainer == null) {
            TerminalView.$$$reportNull$$$0(25);
        }
        this.myContainerByWidgetMap.put(terminalContainer.getTerminalWidget(), terminalContainer);
    }

    public void unregister(@NotNull TerminalContainer terminalContainer) {
        if (terminalContainer == null) {
            TerminalView.$$$reportNull$$$0(26);
        }
        this.myContainerByWidgetMap.remove(terminalContainer.getTerminalWidget());
        if (TerminalView.getWidgetByContent(terminalContainer.getContent()) == terminalContainer.getTerminalWidget()) {
            terminalContainer.getContent().putUserData(TERMINAL_WIDGET_KEY, (Object)this.findWidgetForContent(terminalContainer.getContent()));
        }
    }

    @Nullable
    private JBTerminalWidget findWidgetForContent(@NotNull Content content) {
        if (content == null) {
            TerminalView.$$$reportNull$$$0(27);
        }
        JBTerminalWidget any = null;
        for (Map.Entry<JBTerminalWidget, TerminalContainer> entry : this.myContainerByWidgetMap.entrySet()) {
            JBTerminalWidget terminalWidget;
            if (entry.getValue().getContent() != content) continue;
            any = terminalWidget = entry.getKey();
            if (!terminalWidget.getTerminalPanel().hasFocus()) continue;
            return terminalWidget;
        }
        return any;
    }

    @NotNull
    public TerminalContainer getContainer(@NotNull JBTerminalWidget terminalWidget) {
        if (terminalWidget == null) {
            TerminalView.$$$reportNull$$$0(28);
        }
        TerminalContainer terminalContainer = Objects.requireNonNull(this.myContainerByWidgetMap.get(terminalWidget));
        if (terminalContainer == null) {
            TerminalView.$$$reportNull$$$0(29);
        }
        return terminalContainer;
    }

    @Nullable
    private static VirtualFile getCurrentWorkingDir(@Nullable TerminalTabState tabState) {
        String dir = tabState != null ? tabState.myWorkingDirectory : null;
        VirtualFile result = null;
        if (dir != null) {
            result = LocalFileSystem.getInstance().findFileByPath(dir);
        }
        return result;
    }

    public void closeTab(@NotNull Content content) {
        if (content == null) {
            TerminalView.$$$reportNull$$$0(30);
        }
        this.myToolWindow.getContentManager().removeContent(content, true, true, true);
    }

    @NotNull
    private static FocusListener createFocusListener(final @NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            TerminalView.$$$reportNull$$$0(31);
        }
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JComponent component = TerminalView.getComponentToFocus(toolWindow);
                if (component != null) {
                    component.requestFocusInWindow();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
    }

    @Nullable
    private static JComponent getComponentToFocus(@NotNull ToolWindow toolWindow) {
        Content selectedContent;
        if (toolWindow == null) {
            TerminalView.$$$reportNull$$$0(32);
        }
        if ((selectedContent = toolWindow.getContentManager().getSelectedContent()) != null) {
            return selectedContent.getPreferredFocusableComponent();
        }
        return toolWindow.getComponent();
    }

    public void openTerminalIn(@Nullable VirtualFile fileToOpen) {
        TerminalTabState state = new TerminalTabState();
        if (fileToOpen != null) {
            state.myWorkingDirectory = fileToOpen.getPath();
        }
        this.createNewSession(this.myTerminalRunner, state);
    }

    @Nullable
    public static JBTerminalWidget getWidgetByContent(@NotNull Content content) {
        if (content == null) {
            TerminalView.$$$reportNull$$$0(33);
        }
        return (JBTerminalWidget)content.getUserData(TERMINAL_WIDGET_KEY);
    }

    public void detachWidgetAndRemoveContent(@NotNull Content content) {
        ContentManager contentManager;
        if (content == null) {
            TerminalView.$$$reportNull$$$0(34);
        }
        LOG.assertTrue((contentManager = this.myToolWindow.getContentManager()).getIndexOfContent(content) >= 0, (Object)"Not a terminal content");
        contentManager.removeContent(content, true);
        content.putUserData(TERMINAL_WIDGET_KEY, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/TerminalView";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalRunner";
                break;
            }
            case 18: 
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalWidget";
                break;
            }
            case 19: 
            case 20: 
            case 27: 
            case 30: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widget";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalRunner";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalView";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocalShellWidget";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewSession";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrInitToolWindow";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTab";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createTerminalContent";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initToolWindow";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNewSession";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "newTab";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createNewTab";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createTerminalContent";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setupTerminalWidget";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updatePreferredFocusableComponent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isSplitTerminal";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "gotoNextSplitTerminal";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "unregister";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findWidgetForContent";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getContainer";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "closeTab";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createFocusListener";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getComponentToFocus";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getWidgetByContent";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "detachWidgetAndRemoveContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class TerminalDockContainer
    implements DockContainer {
        private TerminalDockContainer() {
        }

        @NotNull
        public RelativeRectangle getAcceptArea() {
            return new RelativeRectangle(TerminalView.this.myToolWindow.getComponent());
        }

        @NotNull
        public DockContainer.ContentResponse getContentResponse(@NotNull DockableContent content, RelativePoint point) {
            if (content == null) {
                TerminalDockContainer.$$$reportNull$$$0(0);
            }
            DockContainer.ContentResponse contentResponse = this.isTerminalSessionContent(content) ? DockContainer.ContentResponse.ACCEPT_MOVE : DockContainer.ContentResponse.DENY;
            if (contentResponse == null) {
                TerminalDockContainer.$$$reportNull$$$0(1);
            }
            return contentResponse;
        }

        public JComponent getContainerComponent() {
            return TerminalView.this.myToolWindow.getComponent();
        }

        public void add(@NotNull DockableContent content, RelativePoint dropTarget) {
            if (content == null) {
                TerminalDockContainer.$$$reportNull$$$0(2);
            }
            if (this.isTerminalSessionContent(content)) {
                TerminalSessionVirtualFileImpl terminalFile = (TerminalSessionVirtualFileImpl)((Object)content.getKey());
                String name = terminalFile.getName();
                Content newContent = TerminalView.this.newTab(TerminalView.this.myToolWindow, terminalFile.getTerminalWidget());
                newContent.setDisplayName(name);
            }
        }

        private boolean isTerminalSessionContent(@NotNull DockableContent<?> content) {
            if (content == null) {
                TerminalDockContainer.$$$reportNull$$$0(3);
            }
            return content.getKey() instanceof TerminalSessionVirtualFileImpl;
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean isDisposeWhenEmpty() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/terminal/TerminalView$TerminalDockContainer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalView$TerminalDockContainer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentResponse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getContentResponse";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isTerminalSessionContent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

