/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.Objects;
import org.intellij.images.search.ImageTagManager;
import org.intellij.images.thumbnail.ThumbnailView;
import org.intellij.images.thumbnail.actions.Filter;

public class TagFilter
implements Filter {
    private final String myTag;
    private final ImageTagManager myManager;

    public TagFilter(String tag, ImageTagManager manager) {
        this.myTag = tag;
        this.myManager = manager;
    }

    @Override
    public String getDisplayName() {
        return this.myTag;
    }

    @Override
    public boolean accepts(VirtualFile file) {
        return this.myManager.hasTag(this.myTag, file);
    }

    @Override
    public boolean isApplicableToProject(Project project) {
        return true;
    }

    @Override
    public void setFilter(ThumbnailView view) {
        TagFilter[] tagFilterArray;
        Object[] filters = view.getTagFilters();
        if (filters != null) {
            tagFilterArray = (TagFilter[])ArrayUtil.append((Object[])filters, (Object)this);
        } else {
            TagFilter[] tagFilterArray2 = new TagFilter[1];
            tagFilterArray = tagFilterArray2;
            tagFilterArray2[0] = this;
        }
        view.setTagFilters(tagFilterArray);
    }

    @Override
    public void clearFilter(ThumbnailView view) {
        Object[] filters = view.getTagFilters();
        if (filters != null) {
            view.setTagFilters((TagFilter[])((filters = (TagFilter[])ArrayUtil.remove((Object[])filters, (Object)this)).length == 0 ? null : filters));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagFilter filter = (TagFilter)o;
        return Objects.equals(this.myTag, filter.myTag);
    }

    public int hashCode() {
        return Objects.hash(this.myTag);
    }
}

