/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.commandInterface.command;

import com.google.common.base.Preconditions;
import com.intellij.openapi.util.Pair;
import com.jetbrains.commandInterface.command.Argument;
import com.jetbrains.commandInterface.command.ArgumentsInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KnownArgumentsInfo
implements ArgumentsInfo {
    @NotNull
    private final List<Argument> myArguments;
    private final int myMinArguments;
    private final int myMaxArguments;

    public KnownArgumentsInfo(@NotNull Collection<Argument> arguments) {
        if (arguments == null) {
            KnownArgumentsInfo.$$$reportNull$$$0(0);
        }
        this(arguments, arguments.size(), arguments.size());
    }

    public KnownArgumentsInfo(int minArguments, int maxArguments, Argument ... arguments) {
        if (arguments == null) {
            KnownArgumentsInfo.$$$reportNull$$$0(1);
        }
        this(Arrays.asList(arguments), minArguments, maxArguments);
    }

    public KnownArgumentsInfo(@NotNull Collection<Argument> arguments, int minArguments) {
        if (arguments == null) {
            KnownArgumentsInfo.$$$reportNull$$$0(2);
        }
        this(arguments, minArguments, Integer.MAX_VALUE);
    }

    public KnownArgumentsInfo(@NotNull Collection<Argument> arguments, int minArguments, int maxArguments) {
        if (arguments == null) {
            KnownArgumentsInfo.$$$reportNull$$$0(3);
        }
        this.myArguments = new ArrayList<Argument>();
        Preconditions.checkArgument((!arguments.isEmpty() ? 1 : 0) != 0, (Object)"At least one argument should be provided");
        this.myArguments.addAll(arguments);
        this.myMinArguments = minArguments;
        this.myMaxArguments = maxArguments;
    }

    @Override
    @Nullable
    public Pair<Boolean, Argument> getArgument(int argumentPosition) {
        boolean optional;
        if (argumentPosition >= this.myMaxArguments) {
            return null;
        }
        boolean bl = optional = argumentPosition >= this.myMinArguments;
        if (this.myArguments.size() > argumentPosition) {
            return Pair.create((Object)(!optional ? 1 : 0), (Object)this.myArguments.get(argumentPosition));
        }
        if (argumentPosition < this.myMaxArguments) {
            return Pair.create((Object)false, (Object)this.myArguments.get(this.myArguments.size() - 1));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/jetbrains/commandInterface/command/KnownArgumentsInfo", "<init>"));
    }
}

