/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.commandInterface.console;

import com.intellij.codeInsight.template.impl.TemplateColors;
import com.intellij.execution.process.ConsoleHighlighter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.jetbrains.commandInterface.command.Argument;
import com.jetbrains.commandInterface.commandLine.ValidationResult;
import com.jetbrains.commandInterface.commandLine.psi.CommandLineFile;
import com.jetbrains.commandInterface.console.CommandConsole;
import java.awt.Color;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

final class ArgumentHintLayer {
    @NotNull
    private static final Pair<String, String> MANDATORY_ARG_BRACES = Pair.create((Object)"<", (Object)">");
    @NotNull
    private static final Pair<String, String> OPTIONAL_ARG_BRACES = Pair.create((Object)"[", (Object)"]");

    private ArgumentHintLayer() {
    }

    @NotNull
    private static String wrapBracesIfNeeded(boolean required, @NotNull String textToShow) {
        if (textToShow == null) {
            ArgumentHintLayer.$$$reportNull$$$0(0);
        }
        if (textToShow.startsWith((String)ArgumentHintLayer.MANDATORY_ARG_BRACES.first) || textToShow.startsWith((String)ArgumentHintLayer.OPTIONAL_ARG_BRACES.first)) {
            String string = textToShow;
            if (string == null) {
                ArgumentHintLayer.$$$reportNull$$$0(1);
            }
            return string;
        }
        Pair<String, String> braces = required ? MANDATORY_ARG_BRACES : OPTIONAL_ARG_BRACES;
        String string = String.format("%s%s%s", braces.first, textToShow, braces.second);
        if (string == null) {
            ArgumentHintLayer.$$$reportNull$$$0(2);
        }
        return string;
    }

    static void attach(@NotNull CommandConsole console) {
        PsiFile consoleFile;
        if (console == null) {
            ArgumentHintLayer.$$$reportNull$$$0(3);
        }
        if (!((consoleFile = console.getFile()) instanceof CommandLineFile)) {
            throw new IllegalArgumentException(String.format("Passed argument is %s, but has to be %s", consoleFile.getClass(), CommandLineFile.class));
        }
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        Color optionalColour = scheme.getAttributes(ConsoleHighlighter.GRAY).getForegroundColor();
        Color requiredColour = scheme.getAttributes(TemplateColors.TEMPLATE_VARIABLE_ATTRIBUTES).getForegroundColor();
        console.getConsoleEditor().registerLineExtensionPainter(line2 -> {
            PsiFile file = console.getFile();
            if (file instanceof CommandLineFile) {
                Pair<Boolean, Argument> arg;
                ValidationResult result = ((CommandLineFile)file).getValidationResult();
                Pair<Boolean, Argument> pair = arg = result != null ? result.getNextArg() : null;
                if (arg != null) {
                    String text2 = ArgumentHintLayer.wrapBracesIfNeeded((Boolean)arg.first, ((Argument)arg.second).getHelp().getHelpString());
                    TextAttributes attributes = ConsoleViewContentType.USER_INPUT.getAttributes();
                    attributes.setForegroundColor((Boolean)arg.first != false ? requiredColour : optionalColour);
                    return Collections.singletonList(new LineExtensionInfo(" " + text2, attributes));
                }
            }
            return Collections.emptyList();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToShow";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/commandInterface/console/ArgumentHintLayer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/commandInterface/console/ArgumentHintLayer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapBracesIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapBracesIfNeeded";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "attach";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

