/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleProcessHandler;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.console.PythonConsoleExecuteActionHandler;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.completion.PydevConsoleElement;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.parsing.console.PythonConsoleData;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PydevConsoleRunner {
    public static final Key<ConsoleCommunication> CONSOLE_COMMUNICATION_KEY = new Key("PYDEV_CONSOLE_COMMUNICATION_KEY");
    public static final Key<Sdk> CONSOLE_SDK = new Key("PYDEV_CONSOLE_SDK_KEY");

    @Nullable
    public static PyRemotePathMapper getPathMapper(@NotNull Project project, Sdk sdk, PyConsoleOptions.PyConsoleSettings consoleSettings) {
        if (project == null) {
            PydevConsoleRunner.$$$reportNull$$$0(0);
        }
        if (PythonSdkUtil.isRemote(sdk)) {
            PyRemoteSdkAdditionalDataBase remoteSdkAdditionalData = (PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData();
            return PydevConsoleRunner.getPathMapper(project, consoleSettings, remoteSdkAdditionalData);
        }
        return null;
    }

    @NotNull
    public static PyRemotePathMapper getPathMapper(@NotNull Project project, PyConsoleOptions.PyConsoleSettings consoleSettings, PyRemoteSdkAdditionalDataBase remoteSdkAdditionalData) {
        if (project == null) {
            PydevConsoleRunner.$$$reportNull$$$0(1);
        }
        PyRemotePathMapper remotePathMapper = PythonRemoteInterpreterManager.appendBasicMappings(project, null, remoteSdkAdditionalData);
        PathMappingSettings mappingSettings = consoleSettings.getMappingSettings();
        remotePathMapper.addAll(mappingSettings.getPathMappings(), PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
        PyRemotePathMapper pyRemotePathMapper = remotePathMapper;
        if (pyRemotePathMapper == null) {
            PydevConsoleRunner.$$$reportNull$$$0(2);
        }
        return pyRemotePathMapper;
    }

    @NotNull
    public static Pair<Sdk, Module> findPythonSdkAndModule(@NotNull Project project, @Nullable Module contextModule) {
        if (project == null) {
            PydevConsoleRunner.$$$reportNull$$$0(3);
        }
        Sdk sdk = null;
        Module module = null;
        PyConsoleOptions.PyConsoleSettings settings = PyConsoleOptions.getInstance(project).getPythonConsoleSettings();
        String sdkHome = settings.getSdkHome();
        if (sdkHome != null) {
            sdk = PythonSdkUtil.findSdkByPath(sdkHome);
            if (settings.getModuleName() != null) {
                module = ModuleManager.getInstance((Project)project).findModuleByName(settings.getModuleName());
            } else {
                module = contextModule;
                if (module == null && ModuleManager.getInstance((Project)project).getModules().length > 0) {
                    module = ModuleManager.getInstance((Project)project).getModules()[0];
                }
            }
        }
        if (sdk == null && settings.isUseModuleSdk()) {
            if (contextModule != null) {
                module = contextModule;
            } else if (settings.getModuleName() != null) {
                module = ModuleManager.getInstance((Project)project).findModuleByName(settings.getModuleName());
            }
            if (module != null && PythonSdkUtil.findPythonSdk(module) != null) {
                sdk = PythonSdkUtil.findPythonSdk(module);
            }
        } else if (contextModule != null) {
            if (module == null) {
                module = contextModule;
            }
            if (sdk == null) {
                sdk = PythonSdkUtil.findPythonSdk(module);
            }
        }
        if (sdk == null) {
            for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
                if (PythonSdkUtil.findPythonSdk(m) == null) continue;
                sdk = PythonSdkUtil.findPythonSdk(m);
                module = m;
                break;
            }
        }
        if (sdk == null && PythonSdkUtil.getAllSdks().size() > 0) {
            sdk = PythonSdkUtil.getAllSdks().get(0);
        }
        Pair pair = Pair.create((Object)sdk, (Object)module);
        if (pair == null) {
            PydevConsoleRunner.$$$reportNull$$$0(4);
        }
        return pair;
    }

    public static String constructPyPathAndWorkingDirCommand(@NotNull Collection<String> pythonPath, @Nullable String workingDir, @NotNull String command) {
        if (pythonPath == null) {
            PydevConsoleRunner.$$$reportNull$$$0(5);
        }
        if (command == null) {
            PydevConsoleRunner.$$$reportNull$$$0(6);
        }
        if (workingDir != null) {
            pythonPath.add(workingDir);
        }
        String path = Joiner.on((String)", ").join((Iterable)Collections2.transform(pythonPath, input -> "'" + input.replace("\\", "\\\\").replace("'", "\\'") + "'"));
        return command.replace("WORKING_DIR_AND_PYTHON_PATHS", path);
    }

    public static Map<String, String> addDefaultEnvironments(Sdk sdk, Map<String, String> envs, @NotNull Project project) {
        if (project == null) {
            PydevConsoleRunner.$$$reportNull$$$0(7);
        }
        PydevConsoleRunner.setCorrectStdOutEncoding(envs, project);
        PythonEnvUtil.initPythonPath(envs, true, PythonCommandLineState.getAddedPaths(sdk));
        return envs;
    }

    public static void setCorrectStdOutEncoding(@NotNull Map<String, String> envs, @NotNull Project project) {
        if (envs == null) {
            PydevConsoleRunner.$$$reportNull$$$0(8);
        }
        if (project == null) {
            PydevConsoleRunner.$$$reportNull$$$0(9);
        }
        Charset defaultCharset = EncodingProjectManager.getInstance((Project)project).getDefaultCharset();
        String encoding = defaultCharset.name();
        PythonEnvUtil.setPythonIOEncoding(PythonEnvUtil.setPythonUnbuffered(envs), encoding);
    }

    public static void setCorrectStdOutEncoding(@NotNull GeneralCommandLine commandLine, @NotNull Project project) {
        if (commandLine == null) {
            PydevConsoleRunner.$$$reportNull$$$0(10);
        }
        if (project == null) {
            PydevConsoleRunner.$$$reportNull$$$0(11);
        }
        Charset defaultCharset = EncodingProjectManager.getInstance((Project)project).getDefaultCharset();
        commandLine.setCharset(defaultCharset);
        PythonEnvUtil.setPythonIOEncoding(commandLine.getEnvironment(), defaultCharset.name());
    }

    public static boolean isInPydevConsole(PsiElement element) {
        return element instanceof PydevConsoleElement || PydevConsoleRunner.getConsoleCommunication(element) != null || PydevConsoleRunner.hasConsoleKey(element);
    }

    public static boolean hasConsoleKey(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        Boolean inConsole = (Boolean)element.getContainingFile().getVirtualFile().getUserData(PythonConsoleView.CONSOLE_KEY);
        return inConsole != null && inConsole != false;
    }

    public static boolean isPythonConsole(@Nullable ASTNode element) {
        return PydevConsoleRunner.getPythonConsoleData(element) != null;
    }

    @Nullable
    public static PythonConsoleData getPythonConsoleData(@Nullable ASTNode element) {
        if (element == null || element.getPsi() == null || element.getPsi().getContainingFile() == null) {
            return null;
        }
        VirtualFile file = PydevConsoleRunnerImpl.getConsoleFile(element.getPsi().getContainingFile());
        if (file == null) {
            return null;
        }
        return (PythonConsoleData)file.getUserData(PyConsoleUtil.PYTHON_CONSOLE_DATA);
    }

    @Nullable
    public static ConsoleCommunication getConsoleCommunication(@NotNull PsiElement element) {
        PsiFile containingFile;
        if (element == null) {
            PydevConsoleRunner.$$$reportNull$$$0(12);
        }
        return (containingFile = element.getContainingFile()) != null ? (ConsoleCommunication)containingFile.getCopyableUserData(CONSOLE_COMMUNICATION_KEY) : null;
    }

    @Nullable
    public static Sdk getConsoleSdk(@NotNull PsiElement element) {
        PsiFile containingFile;
        if (element == null) {
            PydevConsoleRunner.$$$reportNull$$$0(13);
        }
        return (containingFile = element.getContainingFile()) != null ? (Sdk)containingFile.getCopyableUserData(CONSOLE_SDK) : null;
    }

    public void open();

    public void runSync(boolean var1);

    public void run(boolean var1);

    public PydevConsoleCommunication getPydevConsoleCommunication();

    public void addConsoleListener(ConsoleListener var1);

    public PythonConsoleExecuteActionHandler getConsoleExecuteActionHandler();

    public PyConsoleProcessHandler getProcessHandler();

    public PythonConsoleView getConsoleView();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMapper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findPythonSdkAndModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPathMapper";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPythonSdkAndModule";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "constructPyPathAndWorkingDirCommand";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultEnvironments";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setCorrectStdOutEncoding";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleCommunication";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleSdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ConsoleListener {
        public void handleConsoleInitialized(@NotNull LanguageConsoleView var1);
    }
}

