/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.array;

import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.jetbrains.python.debugger.array.AsyncArrayTableModel;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class JBTableWithRowHeaders
extends JBTable {
    private final JBScrollPane myScrollPane;
    private boolean myAutoResize;
    private final RowHeaderTable myRowHeaderTable;
    private final Set<Integer> myNotAdjustableColumns = new HashSet<Integer>();

    public JBTableWithRowHeaders(boolean autoResize) {
        this.myAutoResize = autoResize;
        this.setAutoResizeMode(this.myAutoResize ? 0 : 2);
        this.setRowSelectionAllowed(false);
        this.setMaxItemsForSizeCalculation(50);
        this.setTableHeader((JTableHeader)((Object)new CustomTableHeader((JTable)((Object)this))));
        this.getTableHeader().setDefaultRenderer(new ColumnHeaderRenderer());
        this.getTableHeader().setReorderingAllowed(false);
        this.myScrollPane = new JBScrollPane((Component)((Object)this));
        this.myRowHeaderTable = new RowHeaderTable((JTable)((Object)this));
        this.myRowHeaderTable.getEmptyText().setText("");
        this.myScrollPane.setRowHeaderView((Component)((Object)this.myRowHeaderTable));
        this.myScrollPane.setCorner("UPPER_LEFT_CORNER", (Component)this.myRowHeaderTable.getTableHeader());
    }

    @NotNull
    public Component prepareRenderer(@NotNull TableCellRenderer renderer, int row, int column) {
        if (renderer == null) {
            JBTableWithRowHeaders.$$$reportNull$$$0(0);
        }
        Component component = super.prepareRenderer(renderer, row, column);
        JTableHeader header = this.getTableHeader();
        TableColumn resizingColumn = header.getResizingColumn();
        if (this.myAutoResize && resizingColumn == null && !this.myNotAdjustableColumns.contains(column)) {
            JBTableWithRowHeaders.updateColumnWidth(column, component.getPreferredSize().width, (JTable)((Object)this));
        }
        Component component2 = component;
        if (component2 == null) {
            JBTableWithRowHeaders.$$$reportNull$$$0(1);
        }
        return component2;
    }

    public void setAutoResize(boolean autoResize) {
        this.myNotAdjustableColumns.clear();
        this.myAutoResize = autoResize;
        this.setAutoResizeMode(this.myAutoResize ? 0 : 2);
    }

    private static int updateColumnWidth(int column, int width, @NotNull JTable table) {
        if (table == null) {
            JBTableWithRowHeaders.$$$reportNull$$$0(2);
        }
        TableColumn tableColumn = table.getColumnModel().getColumn(column);
        int headerWidth = new ColumnHeaderRenderer().getTableCellRendererComponent((JTable)table, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)column).getPreferredSize().width + 4;
        int newWidth = Math.max(width, headerWidth) + 2 * table.getIntercellSpacing().width;
        tableColumn.setPreferredWidth(Math.max(newWidth, tableColumn.getPreferredWidth()));
        return newWidth;
    }

    public JBScrollPane getScrollPane() {
        return this.myScrollPane;
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.getPreferredSize().width < this.getParent().getWidth();
    }

    public void setModel(@NotNull TableModel model) {
        if (model == null) {
            JBTableWithRowHeaders.$$$reportNull$$$0(3);
        }
        super.setModel(model);
        if (model instanceof AsyncArrayTableModel) {
            this.myRowHeaderTable.setModel(((AsyncArrayTableModel)model).getRowHeaderModel());
        }
    }

    public void setEmpty() {
        this.setModel(new DefaultTableModel());
        this.myRowHeaderTable.setModel(new DefaultTableModel());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/array/JBTableWithRowHeaders";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/array/JBTableWithRowHeaders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenderer";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateColumnWidth";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DefaultTableHeaderCellRenderer
    extends DefaultTableCellRenderer {
        public DefaultTableHeaderCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(2);
            this.setVerticalAlignment(3);
            this.setOpaque(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JTableHeader tableHeader = table.getTableHeader();
            if (tableHeader != null) {
                this.setForeground(tableHeader.getForeground());
            }
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }

    public static class ColumnHeaderRenderer
    extends DefaultTableHeaderCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            int selectedColumn = table.getSelectedColumn();
            if (selectedColumn == column) {
                this.setFont(this.getFont().deriveFont(1));
            }
            return this;
        }
    }

    public class CustomTableHeader
    extends JBTable.JBTableHeader {
        public CustomTableHeader(JTable table) {
            super((JBTable)JBTableWithRowHeaders.this);
            this.setColumnModel(table.getColumnModel());
            table.getColumnModel().getSelectionModel().addListSelectionListener(e -> this.repaint());
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
            this.repaint();
        }

        public void setResizingColumn(TableColumn column) {
            super.setResizingColumn(column);
            if (column != null) {
                JBTableWithRowHeaders.this.myNotAdjustableColumns.add(column.getModelIndex());
            }
        }
    }

    public class RowHeaderTable
    extends JBTable
    implements PropertyChangeListener,
    TableModelListener {
        private final JTable myMainTable;

        public RowHeaderTable(JTable table) {
            MouseListener[] listeners;
            this.myMainTable = table;
            this.setFocusable(false);
            this.setSelectionModel(this.myMainTable.getSelectionModel());
            this.setSelectionMode(0);
            this.setRowHeight(this.myMainTable.getRowHeight());
            for (MouseListener l : listeners = this.getMouseListeners()) {
                this.removeMouseListener(l);
            }
            this.setModel(new DefaultTableModel(0, 1));
            this.setPreferredScrollableViewportSize(this.getPreferredSize());
        }

        @NotNull
        public Component prepareRenderer(@NotNull TableCellRenderer renderer, int row, int column) {
            if (renderer == null) {
                RowHeaderTable.$$$reportNull$$$0(0);
            }
            Component component = super.prepareRenderer(renderer, row, column);
            if (JBTableWithRowHeaders.this.myAutoResize) {
                this.getPreferredSize().width = JBTableWithRowHeaders.updateColumnWidth(column, component.getPreferredSize().width, (JTable)((Object)this));
            } else {
                this.getColumnModel().getColumn(0).setPreferredWidth(50);
            }
            this.setPreferredScrollableViewportSize(this.getPreferredSize());
            Component component2 = component;
            if (component2 == null) {
                RowHeaderTable.$$$reportNull$$$0(1);
            }
            return component2;
        }

        public void setModel(@NotNull TableModel model) {
            if (model == null) {
                RowHeaderTable.$$$reportNull$$$0(2);
            }
            this.setAutoCreateColumnsFromModel(true);
            super.setModel(model);
            if (this.getColumnModel().getColumnCount() > 0) {
                this.getColumnModel().getColumn(0).setCellRenderer(new RowNumberRenderer());
            }
        }

        public int getRowHeight(int row) {
            int height = super.getRowHeight();
            if (height != this.myMainTable.getRowHeight()) {
                this.setRowHeight(this.myMainTable.getRowHeight());
            }
            return super.getRowHeight(row);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("selectionModel".equals(e.getPropertyName())) {
                this.setSelectionModel(this.myMainTable.getSelectionModel());
            }
            if ("rowHeight".equals(e.getPropertyName())) {
                this.repaint();
            }
            if ("model".equals(e.getPropertyName())) {
                this.revalidate();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/array/JBTableWithRowHeaders$RowHeaderTable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/array/JBTableWithRowHeaders$RowHeaderTable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepareRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareRenderer";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setModel";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class RowNumberRenderer
        extends DefaultTableCellRenderer {
            RowNumberRenderer() {
                this.setHorizontalAlignment(0);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader header;
                if (table != null && (header = table.getTableHeader()) != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
                if (isSelected) {
                    this.setFont(this.getFont().deriveFont(1));
                }
                this.setText(value == null ? "" : value.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        }
    }
}

