/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor.selectWord;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyCommaSelectionHandler
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            PyCommaSelectionHandler.$$$reportNull$$$0(0);
        }
        return e instanceof PyReferenceExpression || e instanceof PyKeyValueExpression || e instanceof PyKeywordArgument || e instanceof PyNumericLiteralExpression || e instanceof PyStringLiteralExpression || e instanceof PyNamedParameter || e instanceof PyStarArgument;
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor2) {
        List<TextRange> textRange;
        if (e == null) {
            PyCommaSelectionHandler.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            PyCommaSelectionHandler.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            PyCommaSelectionHandler.$$$reportNull$$$0(3);
        }
        if ((textRange = PyCommaSelectionHandler.addNextComma(e, cursorOffset)).equals(Collections.emptyList())) {
            return PyCommaSelectionHandler.addPreviousComma(e, cursorOffset);
        }
        return textRange;
    }

    private static List<TextRange> addPreviousComma(PsiElement e, int cursorOffset) {
        PsiElement prevSibling = e.getPrevSibling();
        TextRange textRange = e.getTextRange();
        TextRange offsetRange = null;
        if (prevSibling != null) {
            if (prevSibling instanceof PsiWhiteSpace) {
                IElementType commaType;
                ASTNode node;
                PsiElement prevCommaSibling = prevSibling.getPrevSibling();
                if (prevCommaSibling != null && (node = prevCommaSibling.getNode()) != null && (commaType = node.getElementType()) == PyTokenTypes.COMMA && (offsetRange = new TextRange(textRange.getStartOffset() - 2, textRange.getEndOffset())).contains(cursorOffset) && offsetRange.getLength() > 1) {
                    return Collections.singletonList(offsetRange);
                }
            } else {
                IElementType commaType;
                ASTNode node = prevSibling.getNode();
                if (node != null && (commaType = node.getElementType()) == PyTokenTypes.COMMA) {
                    offsetRange = new TextRange(textRange.getStartOffset() - 1, textRange.getEndOffset());
                }
            }
            if (offsetRange != null && offsetRange.contains(cursorOffset) && offsetRange.getLength() > 1) {
                return Collections.singletonList(offsetRange);
            }
        }
        return Collections.emptyList();
    }

    private static List<TextRange> addNextComma(PsiElement e, int cursorOffset) {
        PsiElement nextSpaceSibling;
        IElementType commaType;
        ASTNode node;
        PsiElement nextCommaSibling = e.getNextSibling();
        if (nextCommaSibling != null && (node = nextCommaSibling.getNode()) != null && (commaType = node.getElementType()) == PyTokenTypes.COMMA && (nextSpaceSibling = nextCommaSibling.getNextSibling()) != null) {
            TextRange textRange = e.getTextRange();
            TextRange offsetRange = nextSpaceSibling instanceof PsiWhiteSpace ? new TextRange(textRange.getStartOffset(), textRange.getEndOffset() + 2) : new TextRange(textRange.getStartOffset(), textRange.getEndOffset() + 1);
            if (offsetRange.contains(cursorOffset) && offsetRange.getLength() > 1) {
                return Collections.singletonList(offsetRange);
            }
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/editor/selectWord/PyCommaSelectionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

