/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.packaging.PyCondaPackageManagerImpl;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.packaging.PyCustomPackageManagers;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerImpl;
import com.jetbrains.python.packaging.PyPackageManagerProvider;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.PyUnsupportedPackageManager;
import com.jetbrains.python.packaging.ui.PyCondaManagementService;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import com.jetbrains.python.sdk.PySdkProvider;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class PyPackageManagersImpl
extends PyPackageManagers
implements Disposable {
    private final Map<String, PyPackageManager> myStandardManagers = new HashMap<String, PyPackageManager>();
    private final Map<String, PyPackageManager> myProvidedManagers = new HashMap<String, PyPackageManager>();

    public PyPackageManagersImpl() {
        PyPackageManagerProvider.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<PyPackageManagerProvider>(){

            public void extensionRemoved(@NotNull PyPackageManagerProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                PyPackageManagersImpl.this.clearProvidedManagersCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/packaging/PyPackageManagersImpl$1";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    @Override
    @NotNull
    public synchronized PyPackageManager forSdk(@NotNull Sdk sdk) {
        String key;
        PyPackageManager manager;
        if (sdk == null) {
            PyPackageManagersImpl.$$$reportNull$$$0(0);
        }
        if ((manager = this.myStandardManagers.get(key = PythonSdkType.getSdkKey(sdk))) == null) {
            manager = this.myProvidedManagers.get(key);
        }
        if (manager == null) {
            Map<String, PyPackageManager> cache2;
            VirtualFile homeDirectory = sdk.getHomeDirectory();
            PyPackageManager customPackageManager = PyCustomPackageManagers.tryCreateCustomPackageManager(sdk);
            if (customPackageManager != null) {
                cache2 = this.myProvidedManagers;
                manager = customPackageManager;
            } else {
                cache2 = this.myStandardManagers;
                manager = PythonSdkUtil.isRemote(sdk) ? new PyUnsupportedPackageManager(sdk) : (PythonSdkUtil.isConda(sdk) && homeDirectory != null && PyCondaPackageService.getCondaExecutable(sdk.getHomePath()) != null ? new PyCondaPackageManagerImpl(sdk) : new PyPackageManagerImpl(sdk));
            }
            cache2.put(key, manager);
        }
        PyPackageManager pyPackageManager = manager;
        if (pyPackageManager == null) {
            PyPackageManagersImpl.$$$reportNull$$$0(1);
        }
        return pyPackageManager;
    }

    public PyPackageManagementService getManagementService(Project project, Sdk sdk) {
        Optional<PyPackageManagementService> provided2 = PySdkProvider.EP_NAME.extensions().map(ext -> ext.tryCreatePackageManagementServiceForSdk(project, sdk)).filter(service -> service != null).findFirst();
        if (provided2.isPresent()) {
            return provided2.get();
        }
        if (PythonSdkUtil.isConda(sdk)) {
            return new PyCondaManagementService(project, sdk);
        }
        return new PyPackageManagementService(project, sdk);
    }

    @Override
    public synchronized void clearCache(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyPackageManagersImpl.$$$reportNull$$$0(2);
        }
        String key = PythonSdkType.getSdkKey(sdk);
        this.myStandardManagers.remove(key);
        this.myProvidedManagers.remove(key);
    }

    private synchronized void clearProvidedManagersCache() {
        this.myProvidedManagers.clear();
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyPackageManagersImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagersImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "forSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forSdk";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "clearCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

