/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd;

import com.thaiopensource.relaxng.edit.AbstractVisitor;
import com.thaiopensource.relaxng.edit.Annotated;
import com.thaiopensource.relaxng.edit.AnnotationChild;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.ComponentVisitor;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementAnnotation;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.InterleavePattern;
import com.thaiopensource.relaxng.edit.ListPattern;
import com.thaiopensource.relaxng.edit.MixedPattern;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.Param;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.PatternVisitor;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.SourceLocation;
import com.thaiopensource.relaxng.edit.TextAnnotation;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.UnaryPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.output.common.Name;
import com.thaiopensource.relaxng.output.common.NameClassSplitter;
import com.thaiopensource.relaxng.output.xsd.ChildType;
import com.thaiopensource.relaxng.output.xsd.Guide;
import com.thaiopensource.relaxng.output.xsd.SchemaInfo;
import com.thaiopensource.relaxng.output.xsd.WildcardBuilder;
import com.thaiopensource.relaxng.output.xsd.basic.Annotation;
import com.thaiopensource.relaxng.output.xsd.basic.Attribute;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroup;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroupRef;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUse;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUseChoice;
import com.thaiopensource.relaxng.output.xsd.basic.Comment;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexType;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeComplexContent;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeNotAllowedContent;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeSimpleContent;
import com.thaiopensource.relaxng.output.xsd.basic.Element;
import com.thaiopensource.relaxng.output.xsd.basic.Facet;
import com.thaiopensource.relaxng.output.xsd.basic.GroupRef;
import com.thaiopensource.relaxng.output.xsd.basic.Occurs;
import com.thaiopensource.relaxng.output.xsd.basic.OptionalAttribute;
import com.thaiopensource.relaxng.output.xsd.basic.Particle;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleAll;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleChoice;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleRepeat;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleSequence;
import com.thaiopensource.relaxng.output.xsd.basic.Schema;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleType;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeList;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeRef;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeRestriction;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeUnion;
import com.thaiopensource.relaxng.output.xsd.basic.Wildcard;
import com.thaiopensource.relaxng.output.xsd.basic.WildcardAttribute;
import com.thaiopensource.relaxng.output.xsd.basic.WildcardElement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class BasicBuilder {
    private final PatternVisitor simpleTypeBuilder = new SimpleTypeBuilder();
    private final PatternVisitor attributeUseBuilder = new AttributeUseBuilder();
    private final PatternVisitor optionalAttributeUseBuilder = new OptionalAttributeUseBuilder();
    private final PatternVisitor particleBuilder = new ParticleBuilder();
    private final PatternVisitor occursCalculator = new OccursCalculator();
    private final ComponentVisitor schemaBuilder;
    private final ErrorReporter er;
    private final String inheritedNamespace;
    private final Schema schema;
    private final SchemaInfo si;
    private final Guide guide;
    private static final String GUIDE_NAMESPACE = "http://www.thaiopensource.com/ns/relaxng/xsd";

    private BasicBuilder(ErrorReporter errorReporter, SchemaInfo schemaInfo, Guide guide, Schema schema, String string, Annotated annotated, boolean bl) {
        this.er = errorReporter;
        this.si = schemaInfo;
        this.guide = guide;
        this.schema = schema;
        this.inheritedNamespace = string;
        this.schemaBuilder = new SchemaBuilder(BasicBuilder.getGroupEnableAbstractElements(annotated, bl));
    }

    static Schema buildBasicSchema(SchemaInfo schemaInfo, Guide guide, ErrorReporter errorReporter) {
        GrammarPattern grammarPattern = schemaInfo.getGrammar();
        Schema schema = new Schema(grammarPattern.getSourceLocation(), BasicBuilder.makeAnnotation(grammarPattern), schemaInfo.getMainUri(), schemaInfo.getEncoding(schemaInfo.getMainUri()));
        new BasicBuilder(errorReporter, schemaInfo, guide, schema, "", grammarPattern, guide.getDefaultGroupEnableAbstractElements()).processGrammar(grammarPattern);
        return schema;
    }

    private void processGrammar(GrammarPattern grammarPattern) {
        BasicBuilder.copyComments(grammarPattern.getLeadingComments(), this.schema.getLeadingComments());
        this.addInitialChildComments(grammarPattern);
        grammarPattern.componentsAccept(this.schemaBuilder);
        BasicBuilder.copyComments(grammarPattern.getFollowingElementAnnotations(), this.schema.getTrailingComments());
    }

    private static SimpleType makeUnionWithEmptySimpleType(SimpleType simpleType, SourceLocation sourceLocation) {
        Vector<SimpleType> vector = new Vector<SimpleType>();
        vector.add(simpleType);
        vector.add(BasicBuilder.makeEmptySimpleType(sourceLocation));
        return new SimpleTypeUnion(sourceLocation, null, vector);
    }

    private static SimpleType makeEmptySimpleType(SourceLocation sourceLocation) {
        Vector<Facet> vector = new Vector<Facet>();
        vector.add(new Facet(sourceLocation, null, "length", "0"));
        return new SimpleTypeRestriction(sourceLocation, null, "token", vector);
    }

    private static SimpleType makeStringType(SourceLocation sourceLocation) {
        return new SimpleTypeRestriction(sourceLocation, null, "string", Collections.EMPTY_LIST);
    }

    private Name makeName(NameNameClass nameNameClass) {
        return new Name(this.resolveNamespace(nameNameClass.getNamespaceUri()), nameNameClass.getLocalName());
    }

    private String resolveNamespace(String string) {
        return BasicBuilder.resolveNamespace(string, this.inheritedNamespace);
    }

    private static String resolveNamespace(String string, String string2) {
        if (string == NameNameClass.INHERIT_NS) {
            return string2;
        }
        return string;
    }

    private static Wildcard[] splitElementWildcard(Wildcard wildcard) {
        if (wildcard == null) {
            return new Wildcard[0];
        }
        if (wildcard.isPositive() || wildcard.getNamespaces().contains("") || wildcard.getNamespaces().size() != 1) {
            return new Wildcard[]{wildcard};
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("");
        HashSet hashSet2 = new HashSet();
        hashSet2.add(wildcard.getNamespaces().iterator().next());
        hashSet2.add("");
        HashSet<Name> hashSet3 = new HashSet<Name>();
        HashSet hashSet4 = new HashSet();
        Iterator iterator = wildcard.getExcludedNames().iterator();
        while (iterator.hasNext()) {
            Name name = (Name)iterator.next();
            (name.getNamespaceUri().equals("") ? hashSet3 : hashSet4).add(name);
        }
        return new Wildcard[]{new Wildcard(false, hashSet2, hashSet4), new Wildcard(true, hashSet, hashSet3)};
    }

    private boolean allowsAnyString(Pattern pattern) {
        while (pattern instanceof RefPattern) {
            pattern = this.si.getBody((RefPattern)pattern);
        }
        if (pattern instanceof TextPattern) {
            return true;
        }
        if (!(pattern instanceof DataPattern)) {
            return false;
        }
        DataPattern dataPattern = (DataPattern)pattern;
        if (dataPattern.getParams().size() != 0) {
            return false;
        }
        String string = dataPattern.getDatatypeLibrary();
        if (string.equals("")) {
            return true;
        }
        if (!string.equals("http://www.w3.org/2001/XMLSchema-datatypes")) {
            return false;
        }
        String string2 = dataPattern.getType();
        return string2.equals("string") || string2.equals("token") || string2.equals("normalizedString");
    }

    private static Annotation makeAnnotation(Annotated annotated) {
        List list = annotated.mayContainText() ? annotated.getFollowingElementAnnotations() : annotated.getChildElementAnnotations();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AnnotationChild annotationChild;
            List list2;
            ElementAnnotation elementAnnotation;
            Object e = iterator.next();
            if (!(e instanceof ElementAnnotation) || !(elementAnnotation = (ElementAnnotation)e).getNamespaceUri().equals("http://relaxng.org/ns/compatibility/annotations/1.0") || !elementAnnotation.getLocalName().equals("documentation") || (list2 = elementAnnotation.getChildren()).size() != 1 || !((annotationChild = (AnnotationChild)list2.get(0)) instanceof TextAnnotation)) continue;
            return new Annotation(((TextAnnotation)annotationChild).getValue());
        }
        return null;
    }

    private static boolean getGroupEnableAbstractElements(Annotated annotated, boolean bl) {
        String string = annotated.getAttributeAnnotation(GUIDE_NAMESPACE, "enableAbstractElements");
        if (string != null) {
            if ((string = string.trim()).equals("true")) {
                bl = true;
            } else if (string.equals("false")) {
                bl = false;
            }
        }
        return bl;
    }

    private void addLeadingComments(Annotated annotated) {
        this.addComments(annotated.getLeadingComments());
    }

    private void addInitialChildComments(Annotated annotated) {
        this.addComments(annotated.getChildElementAnnotations());
    }

    private void addTrailingComments(Annotated annotated) {
        this.addComments(annotated.getFollowingElementAnnotations());
    }

    private void addComments(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof com.thaiopensource.relaxng.edit.Comment)) continue;
            com.thaiopensource.relaxng.edit.Comment comment = (com.thaiopensource.relaxng.edit.Comment)e;
            this.schema.addComment(comment.getValue(), comment.getSourceLocation());
        }
    }

    private static void copyComments(List list, List list2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof com.thaiopensource.relaxng.edit.Comment)) continue;
            com.thaiopensource.relaxng.edit.Comment comment = (com.thaiopensource.relaxng.edit.Comment)e;
            list2.add(new Comment(comment.getSourceLocation(), comment.getValue()));
        }
    }

    class SchemaBuilder
    extends AbstractVisitor {
        boolean groupEnableAbstractElements;

        SchemaBuilder(boolean bl) {
            this.groupEnableAbstractElements = bl;
        }

        public Object visitDefine(DefineComponent defineComponent) {
            BasicBuilder.this.addLeadingComments(defineComponent);
            String string = defineComponent.getName();
            SourceLocation sourceLocation = defineComponent.getSourceLocation();
            Annotation annotation = BasicBuilder.makeAnnotation(defineComponent);
            if (string == DefineComponent.START) {
                if (!BasicBuilder.this.si.isIgnored(defineComponent)) {
                    Pattern pattern = defineComponent.getBody();
                    ChildType childType = BasicBuilder.this.si.getChildType(pattern);
                    if (childType.contains(ChildType.ELEMENT)) {
                        BasicBuilder.this.schema.addRoot((Particle)pattern.accept(BasicBuilder.this.particleBuilder), sourceLocation, annotation);
                    }
                }
            } else {
                Pattern pattern = BasicBuilder.this.si.getBody(defineComponent);
                if (pattern != null) {
                    ChildType childType = BasicBuilder.this.si.getChildType(pattern);
                    if (childType.contains(ChildType.ELEMENT)) {
                        BasicBuilder.this.guide.setGroupEnableAbstractElement(string, BasicBuilder.getGroupEnableAbstractElements(defineComponent, this.groupEnableAbstractElements));
                        BasicBuilder.this.schema.defineGroup(string, (Particle)pattern.accept(BasicBuilder.this.particleBuilder), sourceLocation, annotation);
                    } else if (childType.contains(ChildType.DATA) && !childType.contains(ChildType.TEXT)) {
                        BasicBuilder.this.schema.defineSimpleType(string, (SimpleType)pattern.accept(BasicBuilder.this.simpleTypeBuilder), sourceLocation, annotation);
                    }
                    if (childType.contains(ChildType.ATTRIBUTE)) {
                        BasicBuilder.this.schema.defineAttributeGroup(string, (AttributeUse)pattern.accept(BasicBuilder.this.attributeUseBuilder), sourceLocation, annotation);
                    }
                }
            }
            BasicBuilder.this.addTrailingComments(defineComponent);
            return null;
        }

        public Object visitDiv(DivComponent divComponent) {
            BasicBuilder.this.addLeadingComments(divComponent);
            BasicBuilder.this.addInitialChildComments(divComponent);
            boolean bl = this.groupEnableAbstractElements;
            this.groupEnableAbstractElements = BasicBuilder.getGroupEnableAbstractElements(divComponent, this.groupEnableAbstractElements);
            divComponent.componentsAccept(this);
            this.groupEnableAbstractElements = bl;
            BasicBuilder.this.addTrailingComments(divComponent);
            return null;
        }

        public Object visitInclude(IncludeComponent includeComponent) {
            BasicBuilder.this.addLeadingComments(includeComponent);
            BasicBuilder.this.addInitialChildComments(includeComponent);
            boolean bl = this.groupEnableAbstractElements;
            this.groupEnableAbstractElements = BasicBuilder.getGroupEnableAbstractElements(includeComponent, this.groupEnableAbstractElements);
            includeComponent.componentsAccept(this);
            String string = includeComponent.getHref();
            Schema schema = BasicBuilder.this.schema.addInclude(string, BasicBuilder.this.si.getEncoding(string), includeComponent.getSourceLocation(), BasicBuilder.makeAnnotation(includeComponent));
            GrammarPattern grammarPattern = BasicBuilder.this.si.getSchema(string);
            new BasicBuilder(BasicBuilder.this.er, BasicBuilder.this.si, BasicBuilder.this.guide, schema, BasicBuilder.this.resolveNamespace(includeComponent.getNs()), grammarPattern, this.groupEnableAbstractElements).processGrammar(grammarPattern);
            this.groupEnableAbstractElements = bl;
            BasicBuilder.this.addTrailingComments(includeComponent);
            return null;
        }
    }

    class AttributeUseBuilder
    extends OptionalAttributeUseBuilder {
        AttributeUseBuilder() {
        }

        boolean isOptional() {
            return false;
        }
    }

    class OptionalAttributeUseBuilder
    extends AbstractVisitor {
        OptionalAttributeUseBuilder() {
        }

        public Object visitAttribute(AttributePattern attributePattern) {
            SimpleType simpleType;
            SourceLocation sourceLocation = attributePattern.getSourceLocation();
            Pattern pattern = attributePattern.getChild();
            ChildType childType = BasicBuilder.this.si.getChildType(pattern);
            if (childType.contains(ChildType.DATA) && !childType.contains(ChildType.TEXT)) {
                simpleType = (SimpleType)pattern.accept(BasicBuilder.this.simpleTypeBuilder);
                if (childType.contains(ChildType.EMPTY)) {
                    simpleType = BasicBuilder.makeUnionWithEmptySimpleType(simpleType, sourceLocation);
                }
            } else {
                simpleType = childType.contains(ChildType.EMPTY) && !childType.contains(ChildType.TEXT) ? BasicBuilder.makeEmptySimpleType(sourceLocation) : null;
            }
            List list = NameClassSplitter.split(attributePattern.getNameClass());
            Wildcard wildcard = WildcardBuilder.createWildcard(attributePattern.getNameClass(), BasicBuilder.this.inheritedNamespace);
            Vector<AttributeUse> vector = new Vector<AttributeUse>();
            Annotation annotation = BasicBuilder.makeAnnotation(attributePattern);
            boolean bl = list.size() + (wildcard != null ? 1 : 0) == 1;
            Annotation annotation2 = bl ? annotation : null;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Attribute attribute = new Attribute(sourceLocation, annotation2, BasicBuilder.this.makeName((NameNameClass)iterator.next()), simpleType);
                if (!bl || this.isOptional()) {
                    vector.add(new OptionalAttribute(attribute.getLocation(), null, attribute, attributePattern.getAttributeAnnotation("http://relaxng.org/ns/compatibility/annotations/1.0", "defaultValue")));
                    continue;
                }
                vector.add(attribute);
            }
            if (wildcard != null) {
                if (!BasicBuilder.this.allowsAnyString(pattern)) {
                    BasicBuilder.this.er.warning("wildcard_attribute_value", attributePattern.getSourceLocation());
                }
                if (!this.isOptional()) {
                    BasicBuilder.this.er.warning("wildcard_attribute_optional", attributePattern.getSourceLocation());
                }
                vector.add(new WildcardAttribute(attributePattern.getSourceLocation(), annotation2, wildcard));
            }
            if (vector.size() == 1) {
                return vector.get(0);
            }
            return new AttributeGroup(attributePattern.getSourceLocation(), annotation, vector);
        }

        boolean isOptional() {
            return true;
        }

        public Object visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            return oneOrMorePattern.getChild().accept(this);
        }

        public Object visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            return zeroOrMorePattern.getChild().accept(BasicBuilder.this.optionalAttributeUseBuilder);
        }

        public Object visitOptional(OptionalPattern optionalPattern) {
            return optionalPattern.getChild().accept(BasicBuilder.this.optionalAttributeUseBuilder);
        }

        public Object visitRef(RefPattern refPattern) {
            AttributeGroupRef attributeGroupRef = new AttributeGroupRef(refPattern.getSourceLocation(), BasicBuilder.makeAnnotation(refPattern), refPattern.getName());
            if (!this.isOptional()) {
                return attributeGroupRef;
            }
            Vector<AttributeUse> vector = new Vector<AttributeUse>();
            vector.add(attributeGroupRef);
            vector.add(AttributeGroup.EMPTY);
            return new AttributeUseChoice(refPattern.getSourceLocation(), null, vector);
        }

        public Object visitComposite(CompositePattern compositePattern) {
            Vector<Object> vector = new Vector<Object>();
            Iterator iterator = compositePattern.getChildren().iterator();
            while (iterator.hasNext()) {
                Pattern pattern = (Pattern)iterator.next();
                if (!BasicBuilder.this.si.getChildType(pattern).contains(ChildType.ATTRIBUTE)) continue;
                vector.add(pattern.accept(this));
            }
            if (vector.size() == 0) {
                return AttributeGroup.EMPTY;
            }
            if (vector.size() == 1) {
                return vector.get(0);
            }
            if (this.isOptional()) {
                BasicBuilder.this.er.warning("optional_attribute_group", compositePattern.getSourceLocation());
            }
            return new AttributeGroup(compositePattern.getSourceLocation(), null, vector);
        }

        public Object visitChoice(ChoicePattern choicePattern) {
            PatternVisitor patternVisitor = this;
            Iterator iterator = choicePattern.getChildren().iterator();
            while (iterator.hasNext()) {
                if (BasicBuilder.this.si.getChildType((Pattern)iterator.next()).contains(ChildType.ATTRIBUTE)) continue;
                patternVisitor = BasicBuilder.this.optionalAttributeUseBuilder;
                break;
            }
            boolean bl = false;
            Vector<AttributeUse> vector = new Vector<AttributeUse>();
            Iterator iterator2 = choicePattern.getChildren().iterator();
            while (iterator2.hasNext()) {
                Pattern pattern = (Pattern)iterator2.next();
                ChildType childType = BasicBuilder.this.si.getChildType(pattern);
                if (childType.contains(ChildType.ATTRIBUTE)) {
                    AttributeUse attributeUse = (AttributeUse)pattern.accept(patternVisitor);
                    if (vector.size() != 1 || !attributeUse.equals(vector.get(0))) {
                        vector.add(attributeUse);
                    }
                }
                if (!childType.contains(ChildType.ELEMENT) && !childType.contains(ChildType.DATA) && !childType.contains(ChildType.TEXT)) continue;
                bl = true;
            }
            if (bl) {
                BasicBuilder.this.er.warning("attribute_child_choice", choicePattern.getSourceLocation());
            }
            if (vector.size() == 1) {
                return vector.get(0);
            }
            return new AttributeUseChoice(choicePattern.getSourceLocation(), null, vector);
        }
    }

    class ParticleBuilder
    extends AbstractVisitor {
        ParticleBuilder() {
        }

        public Object visitElement(ElementPattern elementPattern) {
            Object object;
            ComplexType complexType;
            Pattern pattern = elementPattern.getChild();
            ChildType childType = BasicBuilder.this.si.getChildType(pattern);
            AttributeUse attributeUse = childType.contains(ChildType.ATTRIBUTE) ? (AttributeUse)pattern.accept(BasicBuilder.this.attributeUseBuilder) : AttributeGroup.EMPTY;
            Particle particle = null;
            boolean bl = false;
            if (childType.contains(ChildType.ELEMENT)) {
                if (childType.contains(ChildType.DATA)) {
                    bl = true;
                }
                particle = (Particle)pattern.accept(BasicBuilder.this.particleBuilder);
            }
            if (childType.contains(ChildType.TEXT)) {
                bl = true;
            }
            if (particle == null && bl && attributeUse.equals(AttributeGroup.EMPTY)) {
                complexType = new ComplexTypeSimpleContent(attributeUse, BasicBuilder.makeStringType(elementPattern.getSourceLocation()));
            } else if (childType.contains(ChildType.DATA) && !bl && particle == null) {
                object = (SimpleType)pattern.accept(BasicBuilder.this.simpleTypeBuilder);
                if (childType.contains(ChildType.EMPTY)) {
                    object = BasicBuilder.makeUnionWithEmptySimpleType((SimpleType)object, elementPattern.getSourceLocation());
                }
                complexType = new ComplexTypeSimpleContent(attributeUse, (SimpleType)object);
            } else {
                complexType = childType.equals(ChildType.NOT_ALLOWED) ? new ComplexTypeNotAllowedContent() : new ComplexTypeComplexContent(attributeUse, particle, bl);
            }
            object = NameClassSplitter.split(elementPattern.getNameClass());
            Wildcard[] wildcardArray = BasicBuilder.splitElementWildcard(WildcardBuilder.createWildcard(elementPattern.getNameClass(), BasicBuilder.this.inheritedNamespace));
            Annotation annotation = BasicBuilder.makeAnnotation(elementPattern);
            Annotation annotation2 = object.size() + wildcardArray.length == 1 ? annotation : null;
            Vector<Particle> vector = new Vector<Particle>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                vector.add(new Element(elementPattern.getSourceLocation(), annotation2, BasicBuilder.this.makeName((NameNameClass)iterator.next()), complexType));
            }
            int n = 0;
            while (n < wildcardArray.length) {
                vector.add(new WildcardElement(elementPattern.getSourceLocation(), annotation2, wildcardArray[n]));
                ++n;
            }
            if (vector.size() == 1) {
                return vector.get(0);
            }
            return new ParticleChoice(elementPattern.getSourceLocation(), annotation, vector);
        }

        public Object visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            return new ParticleRepeat(oneOrMorePattern.getSourceLocation(), BasicBuilder.makeAnnotation(oneOrMorePattern), (Particle)oneOrMorePattern.getChild().accept(this), Occurs.ONE_OR_MORE);
        }

        public Object visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            return new ParticleRepeat(zeroOrMorePattern.getSourceLocation(), BasicBuilder.makeAnnotation(zeroOrMorePattern), (Particle)zeroOrMorePattern.getChild().accept(this), Occurs.ZERO_OR_MORE);
        }

        public Object visitOptional(OptionalPattern optionalPattern) {
            return new ParticleRepeat(optionalPattern.getSourceLocation(), BasicBuilder.makeAnnotation(optionalPattern), (Particle)optionalPattern.getChild().accept(this), Occurs.OPTIONAL);
        }

        public Object visitChoice(ChoicePattern choicePattern) {
            Object object;
            Object object2;
            Vector<Object> vector = new Vector<Object>();
            boolean bl = false;
            Iterator iterator = choicePattern.getChildren().iterator();
            while (iterator.hasNext()) {
                object2 = (Pattern)iterator.next();
                object = BasicBuilder.this.si.getChildType((Pattern)object2);
                if (((ChildType)object).contains(ChildType.ELEMENT)) {
                    vector.add(((Pattern)object2).accept(this));
                    continue;
                }
                if (((ChildType)object).equals(ChildType.NOT_ALLOWED)) continue;
                bl = true;
            }
            object2 = BasicBuilder.makeAnnotation(choicePattern);
            object = vector.size() == 1 && object2 == null ? (Particle)vector.get(0) : new ParticleChoice(choicePattern.getSourceLocation(), (Annotation)object2, vector);
            if (bl) {
                return new ParticleRepeat(choicePattern.getSourceLocation(), null, (Particle)object, Occurs.OPTIONAL);
            }
            return object;
        }

        public Object visitGroup(GroupPattern groupPattern) {
            Annotation annotation = BasicBuilder.makeAnnotation(groupPattern);
            List list = this.buildChildren(groupPattern);
            if (list.size() == 1 && annotation == null) {
                return list.get(0);
            }
            return new ParticleSequence(groupPattern.getSourceLocation(), annotation, list);
        }

        public Object visitInterleave(InterleavePattern interleavePattern) {
            Annotation annotation = BasicBuilder.makeAnnotation(interleavePattern);
            List list = this.buildChildren(interleavePattern);
            if (list.size() == 1 && annotation == null) {
                return list.get(0);
            }
            return new ParticleAll(interleavePattern.getSourceLocation(), annotation, list);
        }

        private List buildChildren(CompositePattern compositePattern) {
            Vector<Object> vector = new Vector<Object>();
            Iterator iterator = compositePattern.getChildren().iterator();
            while (iterator.hasNext()) {
                Pattern pattern = (Pattern)iterator.next();
                if (!BasicBuilder.this.si.getChildType(pattern).contains(ChildType.ELEMENT)) continue;
                vector.add(pattern.accept(this));
            }
            return vector;
        }

        public Object visitMixed(MixedPattern mixedPattern) {
            return mixedPattern.getChild().accept(this);
        }

        public Object visitRef(RefPattern refPattern) {
            return new GroupRef(refPattern.getSourceLocation(), BasicBuilder.makeAnnotation(refPattern), refPattern.getName());
        }
    }

    class OccursCalculator
    extends AbstractVisitor {
        OccursCalculator() {
        }

        public Object visitOptional(OptionalPattern optionalPattern) {
            return new Occurs(0, ((Occurs)optionalPattern.getChild().accept(this)).getMax());
        }

        public Object visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            return new Occurs(0, Integer.MAX_VALUE);
        }

        public Object visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            return new Occurs(((Occurs)oneOrMorePattern.getChild().accept(this)).getMin(), Integer.MAX_VALUE);
        }

        public Object visitData(DataPattern dataPattern) {
            return Occurs.EXACTLY_ONE;
        }

        public Object visitValue(ValuePattern valuePattern) {
            return Occurs.EXACTLY_ONE;
        }

        public Object visitEmpty(EmptyPattern emptyPattern) {
            return new Occurs(0, 0);
        }

        private Occurs sum(CompositePattern compositePattern) {
            Occurs occurs = new Occurs(0, 0);
            List list = compositePattern.getChildren();
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                occurs = Occurs.add(occurs, (Occurs)((Pattern)list.get(n)).accept(this));
                ++n;
            }
            return occurs;
        }

        public Object visitInterleave(InterleavePattern interleavePattern) {
            return this.sum(interleavePattern);
        }

        public Object visitGroup(GroupPattern groupPattern) {
            return this.sum(groupPattern);
        }

        public Object visitChoice(ChoicePattern choicePattern) {
            List list = choicePattern.getChildren();
            Occurs occurs = (Occurs)((Pattern)list.get(0)).accept(this);
            int n = 1;
            int n2 = list.size();
            while (n < n2) {
                Occurs occurs2 = (Occurs)((Pattern)list.get(n)).accept(this);
                occurs = new Occurs(Math.min(occurs.getMin(), occurs2.getMin()), Math.max(occurs.getMax(), occurs2.getMax()));
                ++n;
            }
            return occurs;
        }

        public Object visitRef(RefPattern refPattern) {
            return BasicBuilder.this.si.getBody(refPattern).accept(this);
        }
    }

    class SimpleTypeBuilder
    extends AbstractVisitor {
        SimpleTypeBuilder() {
        }

        public Object visitData(DataPattern dataPattern) {
            String string = dataPattern.getDatatypeLibrary();
            String string2 = dataPattern.getType();
            Vector<Facet> vector = new Vector<Facet>();
            SourceLocation sourceLocation = dataPattern.getSourceLocation();
            if (!string.equals("") && !string.equals("http://www.w3.org/2001/XMLSchema-datatypes")) {
                string2 = "string";
                BasicBuilder.this.er.warning("unsupported_datatype_library", string, sourceLocation);
            } else {
                if (string2.equals("NOTATION")) {
                    string2 = "QName";
                }
                Iterator iterator = dataPattern.getParams().iterator();
                while (iterator.hasNext()) {
                    Param param = (Param)iterator.next();
                    vector.add(new Facet(param.getSourceLocation(), BasicBuilder.makeAnnotation(param), param.getName(), param.getValue()));
                }
            }
            return new SimpleTypeRestriction(sourceLocation, BasicBuilder.makeAnnotation(dataPattern), string2, vector);
        }

        public Object visitValue(ValuePattern valuePattern) {
            String string = valuePattern.getDatatypeLibrary();
            String string2 = valuePattern.getType();
            Vector<Facet> vector = new Vector<Facet>();
            SourceLocation sourceLocation = valuePattern.getSourceLocation();
            if (!string.equals("") && !string.equals("http://www.w3.org/2001/XMLSchema-datatypes")) {
                string2 = "string";
                BasicBuilder.this.er.warning("unsupported_datatype_library", string, sourceLocation);
            } else {
                if (string2.equals("NOTATION")) {
                    string2 = "QName";
                }
                String string3 = null;
                String string4 = null;
                Iterator iterator = valuePattern.getPrefixMap().entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    string3 = (String)entry.getKey();
                    string4 = BasicBuilder.this.resolveNamespace((String)entry.getValue());
                }
                vector.add(new Facet(sourceLocation, BasicBuilder.makeAnnotation(valuePattern), "enumeration", valuePattern.getValue(), string3, string4));
            }
            return new SimpleTypeRestriction(sourceLocation, null, string2, vector);
        }

        public Object visitComposite(CompositePattern compositePattern) {
            Vector<Object> vector = new Vector<Object>();
            Iterator iterator = compositePattern.getChildren().iterator();
            while (iterator.hasNext()) {
                Pattern pattern = (Pattern)iterator.next();
                if (!BasicBuilder.this.si.getChildType(pattern).contains(ChildType.DATA)) continue;
                vector.add(pattern.accept(this));
            }
            if (vector.size() == 1) {
                return vector.get(0);
            }
            return new SimpleTypeUnion(compositePattern.getSourceLocation(), BasicBuilder.makeAnnotation(compositePattern), vector);
        }

        public Object visitUnary(UnaryPattern unaryPattern) {
            return unaryPattern.getChild().accept(this);
        }

        public Object visitList(ListPattern listPattern) {
            SourceLocation sourceLocation = listPattern.getSourceLocation();
            Pattern pattern = listPattern.getChild();
            ChildType childType = BasicBuilder.this.si.getChildType(pattern);
            if (childType.equals(ChildType.EMPTY)) {
                return BasicBuilder.makeEmptySimpleType(sourceLocation);
            }
            boolean bl = false;
            if (childType.contains(ChildType.ELEMENT)) {
                BasicBuilder.this.er.warning("list_contains_element", sourceLocation);
                bl = true;
            }
            if (childType.contains(ChildType.ATTRIBUTE)) {
                BasicBuilder.this.er.warning("list_contains_attribute", sourceLocation);
                bl = true;
            }
            if (childType.contains(ChildType.TEXT)) {
                BasicBuilder.this.er.warning("list_contains_text", sourceLocation);
                bl = true;
            }
            if (bl) {
                return BasicBuilder.makeStringType(sourceLocation);
            }
            return new SimpleTypeList(sourceLocation, BasicBuilder.makeAnnotation(listPattern), (SimpleType)pattern.accept(this), (Occurs)pattern.accept(BasicBuilder.this.occursCalculator));
        }

        public Object visitRef(RefPattern refPattern) {
            return new SimpleTypeRef(refPattern.getSourceLocation(), BasicBuilder.makeAnnotation(refPattern), refPattern.getName());
        }
    }
}

