/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum JsonSchemaType {
    _string,
    _number,
    _integer,
    _object,
    _array,
    _boolean,
    _null,
    _any,
    _string_number;


    public String getName() {
        return this.name().substring(1);
    }

    public String getDefaultValue() {
        switch (this) {
            case _string: {
                return "\"\"";
            }
            case _number: 
            case _integer: 
            case _string_number: {
                return "0";
            }
            case _object: {
                return "{}";
            }
            case _array: {
                return "[]";
            }
            case _boolean: {
                return "false";
            }
            case _null: {
                return "null";
            }
        }
        return "";
    }

    public boolean isSimple() {
        switch (this) {
            case _string: 
            case _number: 
            case _integer: 
            case _boolean: 
            case _null: {
                return true;
            }
        }
        return false;
    }

    @Nullable
    static JsonSchemaType getType(@NotNull JsonValueAdapter value) {
        if (value == null) {
            JsonSchemaType.$$$reportNull$$$0(0);
        }
        if (value.isNull()) {
            return _null;
        }
        if (value.isBooleanLiteral()) {
            return _boolean;
        }
        if (value.isStringLiteral()) {
            return value.isNumberLiteral() ? _string_number : _string;
        }
        if (value.isArray()) {
            return _array;
        }
        if (value.isObject()) {
            return _object;
        }
        if (value.isNumberLiteral()) {
            return JsonSchemaType.isInteger(value.getDelegate().getText()) ? _integer : _number;
        }
        return null;
    }

    public static boolean isInteger(@NotNull String text) {
        if (text == null) {
            JsonSchemaType.$$$reportNull$$$0(1);
        }
        return JsonSchemaType.getIntegerValue(text) != null;
    }

    @Nullable
    public static Number getIntegerValue(@NotNull String text) {
        if (text == null) {
            JsonSchemaType.$$$reportNull$$$0(2);
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            try {
                return BigInteger.valueOf(Long.parseLong(text));
            }
            catch (NumberFormatException e2) {
                return null;
            }
        }
    }

    public String getDescription() {
        if (this == _any) {
            return "*";
        }
        return this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInteger";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getIntegerValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

