/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.compiler;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class JavacResourcesReader {
    public static final String MSG_PATTERNS_START = "__patterns_start";
    public static final String MSG_PATTERNS_END = "__patterns_end";
    public static final String MSG_PARSING_STARTED = "MSG_PARSING_STARTED";
    public static final String MSG_PARSING_COMPLETED = "MSG_PARSING_COMPLETED";
    public static final String MSG_LOADING = "MSG_LOADING";
    public static final String MSG_CHECKING = "MSG_CHECKING";
    public static final String MSG_WROTE = "MSG_WROTE";
    public static final String MSG_WARNING = "MSG_WARNING";
    public static final String MSG_NOTE = "MSG_NOTE";
    public static final String MSG_STATISTICS = "MSG_STATISTICS";
    public static final String MSG_IGNORED = "MSG_IGNORED";
    private static final String[] BUNDLE_NAMES = new String[]{"com.sun.tools.javac.resources.compiler", "com.sun.tools.javac.v8.resources.compiler", "sun.tools.javac.resources.javac"};
    private static final BundleKey[] MSG_NAME_KEY_PAIRS = new BundleKey[]{new BundleKey("MSG_PARSING_STARTED", "compiler.misc.verbose.parsing.started"), new BundleKey("MSG_PARSING_COMPLETED", "compiler.misc.verbose.parsing.done"), new BundleKey("MSG_PARSING_COMPLETED", "benv.parsed_in"), new BundleKey("MSG_LOADING", "compiler.misc.verbose.loading"), new BundleKey("MSG_LOADING", "benv.loaded_in"), new BundleKey("MSG_CHECKING", "compiler.misc.verbose.checking.attribution"), new BundleKey("MSG_WROTE", "compiler.misc.verbose.wrote.file"), new BundleKey("MSG_WROTE", "main.wrote"), new BundleKey("MSG_WARNING", "compiler.warn.warning"), new BundleKey("MSG_NOTE", new String[]{"compiler.note.note", "compiler.note.deprecated.filename"}), new BundleKey("MSG_NOTE", new String[]{"compiler.note.note", "compiler.note.deprecated.plural"}), new BundleKey("MSG_NOTE", new String[]{"compiler.note.note", "compiler.note.deprecated.recompile"}), new BundleKey("MSG_NOTE", new String[]{"compiler.note.note", "compiler.note.unchecked.filename"}), new BundleKey("MSG_NOTE", new String[]{"compiler.note.note", "compiler.note.unchecked.plural"}), new BundleKey("MSG_NOTE", new String[]{"compiler.note.note", "compiler.note.unchecked.recompile"}), new BundleKey("MSG_STATISTICS", "compiler.misc.count.error"), new BundleKey("MSG_STATISTICS", "compiler.misc.count.error.plural"), new BundleKey("MSG_STATISTICS", "compiler.misc.count.warn"), new BundleKey("MSG_STATISTICS", "compiler.misc.count.warn.plural"), new BundleKey("MSG_STATISTICS", "main.errors"), new BundleKey("MSG_STATISTICS", "main.warnings"), new BundleKey("MSG_STATISTICS", "main.1error"), new BundleKey("MSG_STATISTICS", "main.1warning"), new IgnoredWarningBundleKey("compiler.warn.dir.path.element.not.found"), new IgnoredWarningBundleKey("compiler.warn.path.element.not.found")};
    public static final String CATEGORY_VALUE_DIVIDER = "=";

    public static void main(String[] args) {
        JavacResourcesReader.dumpPatterns();
    }

    public static boolean dumpPatterns() {
        ResourceBundle messagesBundle = JavacResourcesReader.getMessagesBundle();
        if (messagesBundle == null) {
            return false;
        }
        System.err.println(MSG_PATTERNS_START);
        for (BundleKey bundleKey : MSG_NAME_KEY_PAIRS) {
            try {
                System.err.println(bundleKey.category + CATEGORY_VALUE_DIVIDER + bundleKey.getCategoryValue(messagesBundle));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        System.err.println(MSG_PATTERNS_END);
        return true;
    }

    private static ResourceBundle getMessagesBundle() {
        for (String name : BUNDLE_NAMES) {
            try {
                return ResourceBundle.getBundle(name);
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return null;
    }

    private static class IgnoredWarningBundleKey
    extends BundleKey {
        IgnoredWarningBundleKey(String messageKey) {
            super(JavacResourcesReader.MSG_IGNORED, new String[]{"compiler.warn.warning", messageKey});
        }

        @Override
        public String getCategoryValue(ResourceBundle messagesBundle) {
            return messagesBundle.getString(this.keys[0]) + MessageFormat.format(messagesBundle.getString(this.keys[1]), "");
        }
    }

    private static class BundleKey {
        public final String category;
        public final String[] keys;

        BundleKey(String category, String key) {
            this(category, new String[]{key});
        }

        BundleKey(String category, String[] composite) {
            this.category = category;
            this.keys = composite;
        }

        public String getCategoryValue(ResourceBundle messagesBundle) {
            if (this.keys.length == 1) {
                return messagesBundle.getString(this.keys[0]);
            }
            StringBuilder buf = new StringBuilder();
            for (String key : this.keys) {
                buf.append(messagesBundle.getString(key));
            }
            return buf.toString();
        }
    }
}

