/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.Macro;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.IOException;

public class SpChar
extends Macro {
    @Override
    public Object clone() {
        return new SpChar();
    }

    @Override
    public String format() {
        return "^";
    }

    @Override
    public String toString(TeXParser teXParser) {
        return new String(Character.toChars(teXParser.getSpChar()));
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(teXParser.getListener().getOther(teXParser.getSpChar()));
        return teXObjectList;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = teXObjectList.popArg(teXParser);
        TeXObject teXObject2 = teXObjectList.peekStack();
        if (teXObject2 instanceof SpChar) {
            teXObjectList.push(teXParser.getListener().createGroup());
            teXParser.getListener().getTeXApp().error(new TeXSyntaxException(teXParser, "tex.error.double_superscript", teXObject.toString(teXParser)));
        }
        teXParser.getListener().superscript(teXObject);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXObject teXObject = teXParser.popNextArg();
        TeXObject teXObject2 = teXParser.peekStack();
        if (teXObject2 instanceof SpChar) {
            teXParser.push(teXParser.getListener().createGroup());
            teXParser.getListener().getTeXApp().error(new TeXSyntaxException(teXParser, "tex.error.double_superscript", teXObject.toString(teXParser)));
        }
        teXParser.getListener().superscript(teXObject);
    }

    public String show(TeXParser teXParser) throws IOException {
        return String.format("superscript character %s", new String(Character.toChars(teXParser.getSpChar())));
    }
}

