/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Constants;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.HeadersTooLargeException;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.GzipOutputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractOutputBuffer<S>
implements OutputBuffer {
    protected Response response;
    protected boolean committed;
    protected boolean finished;
    protected byte[] buf;
    protected int pos;
    protected OutputFilter[] filterLibrary;
    protected OutputFilter[] activeFilters;
    protected int lastActiveFilter;
    protected OutputBuffer outputStreamOutputBuffer;
    protected long byteCount = 0L;
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.coyote.http11");
    private static final Log log = LogFactory.getLog(AbstractOutputBuffer.class);

    public void addFilter(OutputFilter outputFilter) {
        OutputFilter[] outputFilterArray = new OutputFilter[this.filterLibrary.length + 1];
        for (int i = 0; i < this.filterLibrary.length; ++i) {
            outputFilterArray[i] = this.filterLibrary[i];
        }
        outputFilterArray[this.filterLibrary.length] = outputFilter;
        this.filterLibrary = outputFilterArray;
        this.activeFilters = new OutputFilter[this.filterLibrary.length];
    }

    public OutputFilter[] getFilters() {
        return this.filterLibrary;
    }

    public void addActiveFilter(OutputFilter outputFilter) {
        if (this.lastActiveFilter == -1) {
            outputFilter.setBuffer(this.outputStreamOutputBuffer);
        } else {
            for (int i = 0; i <= this.lastActiveFilter; ++i) {
                if (this.activeFilters[i] != outputFilter) continue;
                return;
            }
            outputFilter.setBuffer(this.activeFilters[this.lastActiveFilter]);
        }
        this.activeFilters[++this.lastActiveFilter] = outputFilter;
        outputFilter.setResponse(this.response);
    }

    @Override
    public int doWrite(ByteChunk byteChunk, Response response) throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.COMMIT, null);
        }
        if (this.lastActiveFilter == -1) {
            return this.outputStreamOutputBuffer.doWrite(byteChunk, response);
        }
        return this.activeFilters[this.lastActiveFilter].doWrite(byteChunk, response);
    }

    @Override
    public long getBytesWritten() {
        if (this.lastActiveFilter == -1) {
            return this.outputStreamOutputBuffer.getBytesWritten();
        }
        return this.activeFilters[this.lastActiveFilter].getBytesWritten();
    }

    public void flush() throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.COMMIT, null);
        }
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            if (!(this.activeFilters[i] instanceof GzipOutputFilter)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Flushing the gzip filter at position " + i + " of the filter chain..."));
            }
            ((GzipOutputFilter)this.activeFilters[i]).flush();
            break;
        }
    }

    public void reset() {
        if (this.committed) {
            throw new IllegalStateException();
        }
        this.pos = 0;
        this.byteCount = 0L;
    }

    public void recycle() {
        this.nextRequest();
    }

    public void nextRequest() {
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.response.recycle();
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
        this.byteCount = 0L;
    }

    public void endRequest() throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.COMMIT, null);
        }
        if (this.finished) {
            return;
        }
        if (this.lastActiveFilter != -1) {
            this.activeFilters[this.lastActiveFilter].end();
        }
        this.finished = true;
    }

    public abstract void init(SocketWrapper<S> var1, AbstractEndpoint<S> var2) throws IOException;

    public abstract void sendAck() throws IOException;

    protected abstract void commit() throws IOException;

    public void sendStatus() {
        this.write(org.apache.coyote.http11.Constants.HTTP_11_BYTES);
        this.buf[this.pos++] = 32;
        int n = this.response.getStatus();
        switch (n) {
            case 200: {
                this.write(org.apache.coyote.http11.Constants._200_BYTES);
                break;
            }
            case 400: {
                this.write(org.apache.coyote.http11.Constants._400_BYTES);
                break;
            }
            case 404: {
                this.write(org.apache.coyote.http11.Constants._404_BYTES);
                break;
            }
            default: {
                this.write(n);
            }
        }
        this.buf[this.pos++] = 32;
        String string = null;
        if (Constants.USE_CUSTOM_STATUS_MSG_IN_HEADER && HttpMessages.isSafeInHttpHeader(this.response.getMessage())) {
            string = this.response.getMessage();
        }
        if (string == null) {
            this.write(HttpMessages.getInstance(this.response.getLocale()).getMessage(n));
        } else {
            this.write(string);
        }
        if (Constants.IS_SECURITY_ENABLED) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    AbstractOutputBuffer.this.buf[AbstractOutputBuffer.this.pos++] = 13;
                    AbstractOutputBuffer.this.buf[AbstractOutputBuffer.this.pos++] = 10;
                    return null;
                }
            });
        } else {
            this.buf[this.pos++] = 13;
            this.buf[this.pos++] = 10;
        }
    }

    public void sendHeader(MessageBytes messageBytes, MessageBytes messageBytes2) {
        this.write(messageBytes);
        this.buf[this.pos++] = 58;
        this.buf[this.pos++] = 32;
        this.write(messageBytes2);
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    public void endHeaders() {
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    protected void write(MessageBytes messageBytes) {
        if (messageBytes.getType() == 2) {
            ByteChunk byteChunk = messageBytes.getByteChunk();
            this.write(byteChunk);
        } else if (messageBytes.getType() == 3) {
            CharChunk charChunk = messageBytes.getCharChunk();
            this.write(charChunk);
        } else {
            this.write(messageBytes.toString());
        }
    }

    protected void write(ByteChunk byteChunk) {
        int n = byteChunk.getLength();
        this.checkLengthBeforeWrite(n);
        System.arraycopy(byteChunk.getBytes(), byteChunk.getStart(), this.buf, this.pos, n);
        this.pos += n;
    }

    protected void write(CharChunk charChunk) {
        int n = charChunk.getStart();
        int n2 = charChunk.getEnd();
        this.checkLengthBeforeWrite(n2 - n);
        char[] cArray = charChunk.getBuffer();
        for (int i = n; i < n2; ++i) {
            int n3 = cArray[i];
            if (n3 <= 31 && n3 != 9 || n3 == 127 || n3 > 255) {
                n3 = 32;
            }
            this.buf[this.pos++] = (byte)n3;
        }
    }

    public void write(byte[] byArray) {
        this.checkLengthBeforeWrite(byArray.length);
        System.arraycopy(byArray, 0, this.buf, this.pos, byArray.length);
        this.pos += byArray.length;
    }

    protected void write(String string) {
        if (string == null) {
            return;
        }
        int n = string.length();
        this.checkLengthBeforeWrite(n);
        for (int i = 0; i < n; ++i) {
            int n2 = string.charAt(i);
            if (n2 <= 31 && n2 != 9 || n2 == 127 || n2 > 255) {
                n2 = 32;
            }
            this.buf[this.pos++] = (byte)n2;
        }
    }

    protected void write(int n) {
        this.write(String.valueOf(n));
    }

    private void checkLengthBeforeWrite(int n) {
        if (this.pos + n + 4 > this.buf.length) {
            throw new HeadersTooLargeException(sm.getString("iob.responseheadertoolarge.error"));
        }
    }
}

