/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.RegistryMBean;
import org.apache.tomcat.util.modeler.modules.ModelerSource;
import org.apache.tomcat.util.res.StringManager;

public class Registry
implements RegistryMBean,
MBeanRegistration {
    private static final Log log = LogFactory.getLog(Registry.class);
    private static final StringManager sm = StringManager.getManager(Registry.class);
    private static HashMap<Object, Registry> perLoaderRegistries = null;
    private static Registry registry = null;
    private MBeanServer server = null;
    private HashMap<String, ManagedBean> descriptors = new HashMap();
    private HashMap<String, ManagedBean> descriptorsByClass = new HashMap();
    private HashMap<String, URL> searchedPaths = new HashMap();
    private Object guard;
    private Hashtable<String, Hashtable<String, Integer>> idDomains = new Hashtable();
    private Hashtable<String, int[]> ids = new Hashtable();

    public static synchronized Registry getRegistry(Object object, Object object2) {
        if (perLoaderRegistries != null) {
            if (object == null) {
                object = Thread.currentThread().getContextClassLoader();
            }
            if (object != null) {
                Registry registry = perLoaderRegistries.get(object);
                if (registry == null) {
                    registry = new Registry();
                    registry.guard = object2;
                    perLoaderRegistries.put(object, registry);
                    return registry;
                }
                if (registry.guard != null && registry.guard != object2) {
                    return null;
                }
                return registry;
            }
        }
        if (registry == null) {
            registry = new Registry();
        }
        if (Registry.registry.guard != null && Registry.registry.guard != object2) {
            return null;
        }
        return registry;
    }

    public static void setUseContextClassLoader(boolean bl) {
        if (bl) {
            perLoaderRegistries = new HashMap();
        }
    }

    @Override
    public void stop() {
        this.descriptorsByClass = new HashMap();
        this.descriptors = new HashMap();
        this.searchedPaths = new HashMap();
    }

    @Override
    public List<ObjectName> loadMBeans(Object object, ClassLoader classLoader) throws Exception {
        return this.load("MbeansSource", object, null);
    }

    @Override
    public void loadMetadata(Object object) throws Exception {
        this.loadDescriptors(null, object, null);
    }

    @Override
    public void registerComponent(Object object, String string, String string2) throws Exception {
        this.registerComponent(object, new ObjectName(string), string2);
    }

    @Override
    public void unregisterComponent(String string) {
        try {
            this.unregisterComponent(new ObjectName(string));
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            log.info((Object)("Error creating object name " + malformedObjectNameException));
        }
    }

    @Override
    public void invoke(List<ObjectName> list, String string, boolean bl) throws Exception {
        if (list == null) {
            return;
        }
        for (ObjectName objectName : list) {
            try {
                if (objectName == null || this.getMethodInfo(objectName, string) == null) continue;
                this.getMBeanServer().invoke(objectName, string, new Object[0], new String[0]);
            }
            catch (Exception exception) {
                if (bl) {
                    throw exception;
                }
                log.info((Object)("Error initializing " + objectName + " " + exception.toString()));
            }
        }
    }

    @Override
    public synchronized int getId(String string, String string2) {
        Integer n;
        Hashtable<String, Integer> hashtable;
        if (string == null) {
            string = "";
        }
        if ((hashtable = this.idDomains.get(string)) == null) {
            hashtable = new Hashtable();
            this.idDomains.put(string, hashtable);
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((n = hashtable.get(string2)) != null) {
            return n;
        }
        int[] nArray = this.ids.get(string);
        if (nArray == null) {
            nArray = new int[1];
            this.ids.put(string, nArray);
        }
        int n2 = nArray[0];
        nArray[0] = n2 + 1;
        int n3 = n2;
        hashtable.put(string2, n3);
        return n3;
    }

    public void addManagedBean(ManagedBean managedBean) {
        this.descriptors.put(managedBean.getName(), managedBean);
        if (managedBean.getType() != null) {
            this.descriptorsByClass.put(managedBean.getType(), managedBean);
        }
    }

    public ManagedBean findManagedBean(String string) {
        ManagedBean managedBean = this.descriptors.get(string);
        if (managedBean == null) {
            managedBean = this.descriptorsByClass.get(string);
        }
        return managedBean;
    }

    public String[] findManagedBeans() {
        return this.descriptors.keySet().toArray(new String[0]);
    }

    public String[] findManagedBeans(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ManagedBean stringArray2 : this.descriptors.values()) {
            if (string == null) {
                if (stringArray2.getGroup() != null) continue;
                arrayList.add(stringArray2.getName());
                continue;
            }
            if (!string.equals(stringArray2.getGroup())) continue;
            arrayList.add(stringArray2.getName());
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public void removeManagedBean(ManagedBean managedBean) {
        this.descriptors.remove(managedBean.getName());
        this.descriptorsByClass.remove(managedBean.getType());
    }

    public String getType(ObjectName objectName, String string) {
        MBeanAttributeInfo[] mBeanAttributeInfoArray;
        String string2 = null;
        MBeanInfo mBeanInfo = null;
        try {
            mBeanInfo = this.server.getMBeanInfo(objectName);
        }
        catch (Exception exception) {
            log.info((Object)("Can't find metadata for object" + objectName));
            return null;
        }
        for (MBeanAttributeInfo mBeanAttributeInfo : mBeanAttributeInfoArray = mBeanInfo.getAttributes()) {
            if (!string.equals(mBeanAttributeInfo.getName())) continue;
            string2 = mBeanAttributeInfo.getType();
            return string2;
        }
        return null;
    }

    public MBeanOperationInfo getMethodInfo(ObjectName objectName, String string) {
        MBeanOperationInfo[] mBeanOperationInfoArray;
        MBeanInfo mBeanInfo = null;
        try {
            mBeanInfo = this.server.getMBeanInfo(objectName);
        }
        catch (Exception exception) {
            log.info((Object)("Can't find metadata " + objectName));
            return null;
        }
        for (MBeanOperationInfo mBeanOperationInfo : mBeanOperationInfoArray = mBeanInfo.getOperations()) {
            if (!string.equals(mBeanOperationInfo.getName())) continue;
            return mBeanOperationInfo;
        }
        return null;
    }

    public MBeanOperationInfo getMethodInfo(ObjectName objectName, String string, int n) throws InstanceNotFoundException {
        MBeanOperationInfo[] mBeanOperationInfoArray;
        MBeanInfo mBeanInfo = null;
        try {
            mBeanInfo = this.getMBeanServer().getMBeanInfo(objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (Exception exception) {
            log.warn((Object)sm.getString("registry.noMetadata", new Object[]{objectName}), (Throwable)exception);
            return null;
        }
        for (MBeanOperationInfo mBeanOperationInfo : mBeanOperationInfoArray = mBeanInfo.getOperations()) {
            if (!string.equals(mBeanOperationInfo.getName()) || n != mBeanOperationInfo.getSignature().length) continue;
            return mBeanOperationInfo;
        }
        return null;
    }

    public void unregisterComponent(ObjectName objectName) {
        try {
            if (objectName != null && this.getMBeanServer().isRegistered(objectName)) {
                this.getMBeanServer().unregisterMBean(objectName);
            }
        }
        catch (Throwable throwable) {
            log.error((Object)"Error unregistering mbean", throwable);
        }
    }

    public synchronized MBeanServer getMBeanServer() {
        long l = System.currentTimeMillis();
        if (this.server == null) {
            if (MBeanServerFactory.findMBeanServer(null).size() > 0) {
                this.server = MBeanServerFactory.findMBeanServer(null).get(0);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using existing MBeanServer " + (System.currentTimeMillis() - l)));
                }
            } else {
                this.server = ManagementFactory.getPlatformMBeanServer();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating MBeanServer" + (System.currentTimeMillis() - l)));
                }
            }
        }
        return this.server;
    }

    public ManagedBean findManagedBean(Object object, Class<?> clazz, String string) throws Exception {
        ManagedBean managedBean;
        if (object != null && clazz == null) {
            clazz = object.getClass();
        }
        if (string == null) {
            string = clazz.getName();
        }
        if ((managedBean = this.findManagedBean(string)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Looking for descriptor ");
            }
            this.findDescriptor(clazz, string);
            managedBean = this.findManagedBean(string);
        }
        if (managedBean == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Introspecting ");
            }
            this.load("MbeansDescriptorsIntrospectionSource", clazz, string);
            managedBean = this.findManagedBean(string);
            if (managedBean == null) {
                log.warn((Object)("No metadata found for " + string));
                return null;
            }
            managedBean.setName(string);
            this.addManagedBean(managedBean);
        }
        return managedBean;
    }

    public Object convertValue(String string, String string2) {
        Object object = string2;
        if (string == null || "java.lang.String".equals(string)) {
            object = string2;
        } else if ("javax.management.ObjectName".equals(string) || "ObjectName".equals(string)) {
            try {
                object = new ObjectName(string2);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                return null;
            }
        } else if ("java.lang.Integer".equals(string) || "int".equals(string)) {
            object = Integer.valueOf(string2);
        } else if ("java.lang.Long".equals(string) || "long".equals(string)) {
            object = Long.valueOf(string2);
        } else if ("java.lang.Boolean".equals(string) || "boolean".equals(string)) {
            object = Boolean.valueOf(string2);
        }
        return object;
    }

    public List<ObjectName> load(String string, Object object, String string2) throws Exception {
        Object object2;
        if (log.isTraceEnabled()) {
            log.trace((Object)("load " + object));
        }
        String string3 = null;
        String string4 = null;
        Object object3 = null;
        if (object instanceof URL) {
            object2 = (URL)object;
            string3 = ((URL)object2).toString();
            string4 = string2;
            object3 = ((URL)object2).openStream();
            if (string == null) {
                string = this.sourceTypeFromExt(string3);
            }
        } else if (object instanceof File) {
            string3 = ((File)object).getAbsolutePath();
            object3 = new FileInputStream((File)object);
            string4 = string2;
            if (string == null) {
                string = this.sourceTypeFromExt(string3);
            }
        } else if (object instanceof InputStream) {
            string4 = string2;
            object3 = object;
        } else if (object instanceof Class) {
            string3 = ((Class)object).getName();
            string4 = string2;
            object3 = object;
            if (string == null) {
                string = "MbeansDescriptorsIntrospectionSource";
            }
        }
        if (string == null) {
            string = "MbeansDescriptorsDigesterSource";
        }
        object2 = this.getModelerSource(string);
        List<ObjectName> list = ((ModelerSource)object2).loadDescriptors(this, string4, object3);
        return list;
    }

    private String sourceTypeFromExt(String string) {
        if (string.endsWith(".ser")) {
            return "MbeansDescriptorsSerSource";
        }
        if (string.endsWith(".xml")) {
            return "MbeansDescriptorsDigesterSource";
        }
        return null;
    }

    public void registerComponent(Object object, ObjectName objectName, String string) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Managed= " + objectName));
        }
        if (object == null) {
            log.error((Object)("Null component " + objectName));
            return;
        }
        try {
            if (string == null) {
                string = object.getClass().getName();
            }
            ManagedBean managedBean = this.findManagedBean(object.getClass(), string);
            DynamicMBean dynamicMBean = managedBean.createMBean(object);
            if (this.getMBeanServer().isRegistered(objectName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Unregistering existing component " + objectName));
                }
                this.getMBeanServer().unregisterMBean(objectName);
            }
            this.getMBeanServer().registerMBean(dynamicMBean, objectName);
        }
        catch (Exception exception) {
            log.error((Object)("Error registering " + objectName), (Throwable)exception);
            throw exception;
        }
    }

    public void loadDescriptors(String string, ClassLoader classLoader) {
        String string2 = string.replace('.', '/');
        if (log.isTraceEnabled()) {
            log.trace((Object)("Finding descriptor " + string2));
        }
        if (this.searchedPaths.get(string) != null) {
            return;
        }
        String string3 = string2 + "/mbeans-descriptors.ser";
        URL uRL = classLoader.getResource(string3);
        if (uRL == null) {
            string3 = string2 + "/mbeans-descriptors.xml";
            uRL = classLoader.getResource(string3);
        }
        if (uRL == null) {
            return;
        }
        log.debug((Object)("Found " + uRL));
        this.searchedPaths.put(string, uRL);
        try {
            if (string3.endsWith(".xml")) {
                this.loadDescriptors("MbeansDescriptorsDigesterSource", uRL, null);
            } else {
                this.loadDescriptors("MbeansDescriptorsSerSource", uRL, null);
            }
            return;
        }
        catch (Exception exception) {
            log.error((Object)("Error loading " + uRL));
            return;
        }
    }

    private void loadDescriptors(String string, Object object, String string2) throws Exception {
        this.load(string, object, string2);
    }

    private void findDescriptor(Class<?> clazz, String string) {
        String string2;
        if (string == null) {
            string = clazz.getName();
        }
        ClassLoader classLoader = null;
        if (clazz != null) {
            classLoader = clazz.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        String string3 = string2 = string;
        while (string3.indexOf(".") > 0) {
            int n = string3.lastIndexOf(".");
            if (n <= 0) {
                return;
            }
            if (this.searchedPaths.get(string3 = string3.substring(0, n)) != null) {
                return;
            }
            this.loadDescriptors(string3, classLoader);
        }
    }

    private ModelerSource getModelerSource(String string) throws Exception {
        if (string == null) {
            string = "MbeansDescriptorsDigesterSource";
        }
        if (!string.contains(".")) {
            string = "org.apache.tomcat.util.modeler.modules." + string;
        }
        Class<?> clazz = Class.forName(string);
        ModelerSource modelerSource = (ModelerSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        return modelerSource;
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.server = mBeanServer;
        return objectName;
    }

    @Override
    public void postRegister(Boolean bl) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    @Deprecated
    public ManagedBean findManagedBean(Class<?> clazz, String string) throws Exception {
        return this.findManagedBean(null, clazz, string);
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this.server = mBeanServer;
    }

    public void resetMetadata() {
        this.stop();
    }
}

