/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tomcat.util.net.NioBlockingSelector;
import org.apache.tomcat.util.net.NioChannel;

public class NioSelectorPool {
    protected NioBlockingSelector blockingSelector;
    protected volatile Selector sharedSelector;
    protected boolean shared = Boolean.parseBoolean(System.getProperty("org.apache.tomcat.util.net.NioSelectorShared", "true"));
    protected int maxSelectors = 200;
    protected long sharedSelectorTimeout = 30000L;
    protected int maxSpareSelectors = -1;
    protected boolean enabled = true;
    protected AtomicInteger active = new AtomicInteger(0);
    protected AtomicInteger spare = new AtomicInteger(0);
    protected ConcurrentLinkedQueue<Selector> selectors = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Selector getSharedSelector() throws IOException {
        if (!this.shared || this.sharedSelector != null) return this.sharedSelector;
        Class<NioSelectorPool> clazz = NioSelectorPool.class;
        synchronized (NioSelectorPool.class) {
            if (this.sharedSelector != null) return this.sharedSelector;
            this.sharedSelector = Selector.open();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.sharedSelector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Selector get() throws IOException {
        if (this.shared) {
            return this.getSharedSelector();
        }
        if (!this.enabled || this.active.incrementAndGet() >= this.maxSelectors) {
            if (this.enabled) {
                this.active.decrementAndGet();
            }
            return null;
        }
        Selector selector = null;
        try {
            Selector selector2 = selector = this.selectors.size() > 0 ? this.selectors.poll() : null;
            if (selector == null) {
                selector = Selector.open();
            } else {
                this.spare.decrementAndGet();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            try {
                selector = Selector.open();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            if (selector == null) {
                this.active.decrementAndGet();
            }
        }
        return selector;
    }

    public void put(Selector selector) throws IOException {
        if (this.shared) {
            return;
        }
        if (this.enabled) {
            this.active.decrementAndGet();
        }
        if (this.enabled && (this.maxSpareSelectors == -1 || this.spare.get() < Math.min(this.maxSpareSelectors, this.maxSelectors))) {
            this.spare.incrementAndGet();
            this.selectors.offer(selector);
        } else {
            selector.close();
        }
    }

    public void close() throws IOException {
        Selector selector;
        this.enabled = false;
        while ((selector = this.selectors.poll()) != null) {
            selector.close();
        }
        this.spare.set(0);
        this.active.set(0);
        if (this.blockingSelector != null) {
            this.blockingSelector.close();
        }
        if (this.shared && this.getSharedSelector() != null) {
            this.getSharedSelector().close();
            this.sharedSelector = null;
        }
    }

    public void open(String string) throws IOException {
        this.enabled = true;
        this.getSharedSelector();
        if (this.shared) {
            this.blockingSelector = new NioBlockingSelector();
            this.blockingSelector.open(string, this.getSharedSelector());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer byteBuffer, NioChannel nioChannel, Selector selector, long l) throws IOException {
        if (this.shared) {
            return this.blockingSelector.write(byteBuffer, nioChannel, l);
        }
        if (nioChannel.getSocketWrapper().previousIOException != null) {
            throw new IOException(nioChannel.getSocketWrapper().previousIOException);
        }
        SelectionKey selectionKey = null;
        int n = 0;
        boolean bl = false;
        int n2 = 1;
        long l2 = System.currentTimeMillis();
        try {
            while (!bl && byteBuffer.hasRemaining()) {
                int n3 = 0;
                if (n2 > 0) {
                    n3 = nioChannel.write(byteBuffer);
                    if (n3 == -1) {
                        throw new EOFException();
                    }
                    n += n3;
                    if (n3 > 0) {
                        l2 = System.currentTimeMillis();
                        continue;
                    }
                }
                if (selector != null) {
                    if (selectionKey == null) {
                        selectionKey = nioChannel.getIOChannel().register(selector, 4);
                    } else {
                        selectionKey.interestOps(4);
                    }
                    if (l == 0L) {
                        bl = byteBuffer.hasRemaining();
                    } else {
                        n2 = l < 0L ? selector.select() : selector.select(l);
                    }
                }
                if (l <= 0L || selector != null && n2 != 0) continue;
                bl = System.currentTimeMillis() - l2 >= l;
            }
            if (bl) {
                nioChannel.getSocketWrapper().previousIOException = new SocketTimeoutException();
                throw nioChannel.getSocketWrapper().previousIOException;
            }
        }
        finally {
            if (selectionKey != null) {
                selectionKey.cancel();
                if (selector != null) {
                    selector.selectNow();
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer byteBuffer, NioChannel nioChannel, Selector selector, long l) throws IOException {
        if (this.shared) {
            return this.blockingSelector.read(byteBuffer, nioChannel, l);
        }
        SelectionKey selectionKey = null;
        int n = 0;
        boolean bl = false;
        int n2 = 1;
        long l2 = System.currentTimeMillis();
        try {
            while (!bl) {
                int n3 = 0;
                if (n2 > 0) {
                    n3 = nioChannel.read(byteBuffer);
                    if (n3 == -1) {
                        if (n != 0) break;
                        n = -1;
                        break;
                    }
                    n += n3;
                    if (n3 > 0) continue;
                    if (n3 == 0 && n > 0) break;
                }
                if (selector != null) {
                    if (selectionKey == null) {
                        selectionKey = nioChannel.getIOChannel().register(selector, 1);
                    } else {
                        selectionKey.interestOps(1);
                    }
                    if (l == 0L) {
                        bl = n == 0;
                    } else {
                        n2 = l < 0L ? selector.select() : selector.select(l);
                    }
                }
                if (l <= 0L || selector != null && n2 != 0) continue;
                bl = System.currentTimeMillis() - l2 >= l;
            }
            if (bl) {
                throw new SocketTimeoutException();
            }
        }
        finally {
            if (selectionKey != null) {
                selectionKey.cancel();
                if (selector != null) {
                    selector.selectNow();
                }
            }
        }
        return n;
    }

    public void setMaxSelectors(int n) {
        this.maxSelectors = n;
    }

    public void setMaxSpareSelectors(int n) {
        this.maxSpareSelectors = n;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setSharedSelectorTimeout(long l) {
        this.sharedSelectorTimeout = l;
    }

    public int getMaxSelectors() {
        return this.maxSelectors;
    }

    public int getMaxSpareSelectors() {
        return this.maxSpareSelectors;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getSharedSelectorTimeout() {
        return this.sharedSelectorTimeout;
    }

    public ConcurrentLinkedQueue<Selector> getSelectors() {
        return this.selectors;
    }

    public AtomicInteger getSpare() {
        return this.spare;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean bl) {
        this.shared = bl;
    }
}

