/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.io;

import java.io.PrintWriter;
import org.netbeans.spi.io.InputOutputProvider;

public abstract class Position {
    static final Position UNSUPPORTED = new Position(){

        @Override
        public void scrollTo() {
        }
    };

    private Position() {
    }

    public abstract void scrollTo();

    static <IO, OW extends PrintWriter, P, F> Position create(InputOutputProvider<IO, OW, P, F> inputOutputProvider, IO IO, OW OW, P p) {
        if (p == null) {
            return UNSUPPORTED;
        }
        return new Impl<IO, OW, P, F>(inputOutputProvider, IO, OW, p);
    }

    private static class Impl<IO, OW extends PrintWriter, P, F>
    extends Position {
        private final InputOutputProvider<IO, OW, P, F> provider;
        private final IO io;
        private final OW ow;
        private final P position;

        public Impl(InputOutputProvider<IO, OW, P, F> inputOutputProvider, IO IO, OW OW, P p) {
            this.provider = inputOutputProvider;
            this.io = IO;
            this.ow = OW;
            this.position = p;
        }

        @Override
        public void scrollTo() {
            this.provider.scrollTo(this.io, this.ow, this.position);
        }
    }
}

