/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoException;
import tim.prune.undo.UndoOperation;

public class UndoDeleteFieldValues
implements UndoOperation {
    private int _startIndex;
    private int _endIndex;
    private Field _field = null;
    private String[] _fieldValues = null;

    public UndoDeleteFieldValues(TrackInfo trackInfo, Field field) {
        this._startIndex = trackInfo.getSelection().getStart();
        this._endIndex = trackInfo.getSelection().getEnd();
        int n = this._endIndex - this._startIndex + 1;
        this._fieldValues = new String[n];
        this._field = field;
        int n2 = this._startIndex;
        while (n2 <= this._endIndex) {
            DataPoint dataPoint = trackInfo.getTrack().getPoint(n2);
            this._fieldValues[n2 - this._startIndex] = dataPoint.getFieldValue(field);
            ++n2;
        }
    }

    @Override
    public String getDescription() {
        return I18nManager.getText("undo.deletefieldvalues");
    }

    @Override
    public void performUndo(TrackInfo trackInfo) throws UndoException {
        Track track = trackInfo.getTrack();
        if (track.getNumPoints() <= this._endIndex || this._endIndex <= this._startIndex) {
            throw new UndoException("Cannot undo conversion, track length doesn't match");
        }
        int n = this._startIndex;
        while (n <= this._endIndex) {
            String string = this._fieldValues[n - this._startIndex];
            if (string != null) {
                track.getPoint(n).setFieldValue(this._field, string, true);
            }
            ++n;
        }
        track.requestRescale();
        trackInfo.getSelection().markInvalid();
        UpdateMessageBroker.informSubscribers();
    }
}

