# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.algorithm import Algorithm


class MNITransformReader(Algorithm):
    """
    MNITransformReader - A reader for MNI transformation files.
    
    Superclass: Algorithm
    
    The MNI .xfm file format is used to store geometrical
    transformations.  Three kinds of transformations are supported by the
    file format: affine, thin-plate spline, and grid transformations.
    This file format was developed at the mc_connell Brain Imaging Centre
    at the Montreal Neurological Institute and is used by their software.
    @sa
    MINCImageReader MNITransformWriter@par Thanks: Thanks to David
    Gobbi for writing this class and Atamai Inc. for contributing it to
    VTK.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMNITransformReader, obj, update, **traits)
    
    file_name = tvtk_base.vtk_file_name("", desc=\
        """
        Set the file name.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    def _get_comments(self):
        return self._vtk_obj.GetComments()
    comments = traits.Property(_get_comments, desc=\
        """
        Get any comments that are included in the file.
        """
    )

    def _get_descriptive_name(self):
        return self._vtk_obj.GetDescriptiveName()
    descriptive_name = traits.Property(_get_descriptive_name, desc=\
        """
        Get the name of this file format.
        """
    )

    def _get_file_extensions(self):
        return self._vtk_obj.GetFileExtensions()
    file_extensions = traits.Property(_get_file_extensions, desc=\
        """
        Get the entension for this file format.
        """
    )

    def get_nth_transform(self, *args):
        """
        V.get_nth_transform(int) -> AbstractTransform
        C++: virtual AbstractTransform *GetNthTransform(int i)
        Get one of the transforms listed in the file.
        """
        ret = self._wrap_call(self._vtk_obj.GetNthTransform, *args)
        return wrap_vtk(ret)

    def _get_number_of_transforms(self):
        return self._vtk_obj.GetNumberOfTransforms()
    number_of_transforms = traits.Property(_get_number_of_transforms, desc=\
        """
        Get the number of transforms in the file.
        """
    )

    def _get_transform(self):
        return wrap_vtk(self._vtk_obj.GetTransform())
    transform = traits.Property(_get_transform, desc=\
        """
        Get the transform that results from concatenating all of the
        transforms in the file.  This will return null if you have not
        specified a file name.
        """
    )

    def can_read_file(self, *args):
        """
        V.can_read_file(string) -> int
        C++: virtual int CanReadFile(const char *name)
        Test whether the specified file can be read.
        """
        ret = self._wrap_call(self._vtk_obj.CanReadFile, *args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('file_name',
    'GetFileName'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'file_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(MNITransformReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit MNITransformReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['file_name']),
            title='Edit MNITransformReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit MNITransformReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

