/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.DataSourceRepository;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.host.Host;
import com.sun.tools.visualvm.host.LocalHostDescriptor;
import com.sun.tools.visualvm.host.RemoteHostDescriptor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.actions.Presenter;

final class ApplicationsSorting
implements Presenter.Menu {
    private static final String PROP_APPS_SORTING = "Applications.sorting";
    private static ApplicationsSorting instance;
    private static final Comparator<DataSource> BY_TIME_COMPARATOR;
    private static final Comparator<DataSource> BY_NAME_COMPARATOR;
    private static final Comparator<DataSource> BY_PID_COMPARATOR;
    private static final List<Comparator<DataSource>> COMPARATORS;
    private final Preferences prefs = NbPreferences.forModule(ApplicationsSorting.class);
    private JMenuItem presenter;
    private final Sorter sorter = new Sorter(){

        @Override
        public void sort(Comparator<DataSource> comparator) {
            DataSourceDescriptor ld = DataSourceDescriptorFactory.getDescriptor((DataSource)Host.LOCALHOST);
            if (ld instanceof LocalHostDescriptor) {
                ((LocalHostDescriptor)ld).setChildrenComparator(comparator);
                ApplicationsSorting.this.prefs.putInt(ApplicationsSorting.PROP_APPS_SORTING, COMPARATORS.indexOf(comparator));
            }
            Set remoteHosts = DataSourceRepository.sharedInstance().getDataSources(Host.class);
            for (Host host : remoteHosts) {
                DataSourceDescriptor rd;
                if (host == Host.LOCALHOST || !((rd = DataSourceDescriptorFactory.getDescriptor((DataSource)host)) instanceof RemoteHostDescriptor)) continue;
                ((RemoteHostDescriptor)rd).setChildrenComparator(comparator);
            }
        }
    };

    public static synchronized ApplicationsSorting instance() {
        if (instance == null) {
            instance = new ApplicationsSorting();
        }
        return instance;
    }

    public JMenuItem getMenuPresenter() {
        if (this.presenter == null) {
            this.presenter = this.createPresenter();
        }
        return this.presenter;
    }

    Comparator<DataSource> getInitialSorting() {
        return COMPARATORS.get(this.prefs.getInt(PROP_APPS_SORTING, COMPARATORS.indexOf(BY_TIME_COMPARATOR)));
    }

    private JMenuItem createPresenter() {
        JMenu menu = new JMenu(){

            @Override
            protected void fireMenuSelected() {
                Component[] items;
                for (Component item : items = this.getMenuComponents()) {
                    if (!(item instanceof SortAction)) continue;
                    ((SortAction)item).updateAction();
                }
            }
        };
        Mnemonics.setLocalizedText((AbstractButton)menu, (String)NbBundle.getMessage(ApplicationsSorting.class, (String)"ACT_SortApps"));
        menu.add(new SortAction(NbBundle.getMessage(ApplicationsSorting.class, (String)"ACT_TimeAdded"), BY_TIME_COMPARATOR, this.sorter));
        menu.add(new SortAction(NbBundle.getMessage(ApplicationsSorting.class, (String)"ACT_DisplayName"), BY_NAME_COMPARATOR, this.sorter));
        menu.add(new SortAction(NbBundle.getMessage(ApplicationsSorting.class, (String)"ACT_Pid"), BY_PID_COMPARATOR, this.sorter));
        return menu;
    }

    private static Comparator<DataSource> byTimeComparator() {
        return null;
    }

    private static Comparator<DataSource> byNameComparator() {
        return new Comparator<DataSource>(){

            @Override
            public int compare(DataSource d1, DataSource d2) {
                DataSourceDescriptor dd1 = DataSourceDescriptorFactory.getDescriptor((DataSource)d1);
                DataSourceDescriptor dd2 = DataSourceDescriptorFactory.getDescriptor((DataSource)d2);
                return dd1.getName().compareTo(dd2.getName());
            }
        };
    }

    private static Comparator<DataSource> byPidComparator() {
        return new Comparator<DataSource>(){

            @Override
            public int compare(DataSource d1, DataSource d2) {
                int d2pid;
                boolean d1app = d1 instanceof Application;
                boolean d2app = d2 instanceof Application;
                if (!d1app && !d2app) {
                    return BY_NAME_COMPARATOR.compare(d1, d2);
                }
                if (!d1app) {
                    return 1;
                }
                if (!d2app) {
                    return -1;
                }
                int d1pid = ((Application)d1).getPid();
                if (d1pid == -1) {
                    d1pid = Integer.MAX_VALUE;
                }
                if ((d2pid = ((Application)d2).getPid()) == -1) {
                    d2pid = Integer.MAX_VALUE;
                }
                if (d1pid == d2pid) {
                    return BY_NAME_COMPARATOR.compare(d1, d2);
                }
                if (d1pid > d2pid) {
                    return 1;
                }
                return -1;
            }
        };
    }

    private ApplicationsSorting() {
    }

    static {
        BY_TIME_COMPARATOR = ApplicationsSorting.byTimeComparator();
        BY_NAME_COMPARATOR = ApplicationsSorting.byNameComparator();
        BY_PID_COMPARATOR = ApplicationsSorting.byPidComparator();
        COMPARATORS = new ArrayList<Comparator<DataSource>>();
        COMPARATORS.add(BY_TIME_COMPARATOR);
        COMPARATORS.add(BY_NAME_COMPARATOR);
        COMPARATORS.add(BY_PID_COMPARATOR);
    }

    private static interface Sorter {
        public void sort(Comparator<DataSource> var1);
    }

    private static class SortAction
    extends JRadioButtonMenuItem {
        private final Sorter sorter;
        private final Comparator<DataSource> comparator;
        private boolean currentlySelected;

        SortAction(String name, Comparator<DataSource> comparator, Sorter sorter) {
            Mnemonics.setLocalizedText((AbstractButton)this, (String)name);
            this.comparator = comparator;
            this.sorter = sorter;
        }

        void updateAction() {
            DataSourceDescriptor d = DataSourceDescriptorFactory.getDescriptor((DataSource)Host.LOCALHOST);
            this.setEnabled(d instanceof LocalHostDescriptor);
            this.currentlySelected = d.getChildrenComparator() == this.comparator;
            this.setSelected(this.currentlySelected);
        }

        @Override
        protected void fireActionPerformed(ActionEvent e) {
            if (!this.currentlySelected) {
                this.sorter.sort(this.comparator);
            }
        }
    }
}

