/* Copyright (c) 2013-2014  Sandro Mani <manisandro@gmail.com>
 *
 * This file is part of gtkspellmm.
 *
 * gtkspellmm is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * gtkspellmm is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GTKSPELLMM_H_INCLUDED
#define GTKSPELLMM_H_INCLUDED

/** @mainpage gtkspellmm Reference Manual
 *
 * @section description Description
 *
 * The gtkspellmm C++ binding provides a C++ interface on top of the gtkspell
 * C library.
 *
 * @section overview Overview
 *
 * The gtkspellmm C++ binding provides a C++ interface on top of the gtkspell
 * C library.
 *
 * @section use Use
 *
 * To use gtkspellmm in your C++ application, include the central header file
 * <tt>\<gtkspellmm.h\></tt>.  The gtkspellmm package ships a @c pkg-config
 * file with the correct include path and link command-line for the compiler.
 */

#include <gtkspellmmconfig.h>
#include <gtkspellmm/gtkspell.h>
#include <gtkspellmm/init.h>

/** @example example/example.cc
 * A gtkspellmm example program.
 */

#endif /* !GTKSPELLMM_H_INCLUDED */
